/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.util;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.cassiokf.industrialrenewal.IndustrialRenewal;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fluids.capability.wrappers.BlockWrapper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class Utils {
    public static final int BUCKET_VOLUME = 1000;
    public static final String WATER_NAME = "Water";
    public static final String STEAM_NAME = "Steam";
    public static final Direction[] VALUES = Direction.values();
    public static final Direction[] BY_HORIZONTAL_INDEX = (Direction[])Arrays.stream(VALUES).filter(direction -> direction.m_122434_().m_122479_()).sorted(Comparator.comparingInt(Direction::m_122416_)).toArray(Direction[]::new);
    private static final Random RANDOM = new Random();
    private static final DecimalFormat form = new DecimalFormat("0.0");
    private static final DecimalFormat preciseForm = new DecimalFormat("0.000");
    public static boolean debugMsg = false;

    public static void debug(String msg, Object ... objects) {
        StringBuilder s = new StringBuilder("DEBUG: ");
        s.append(msg).append(" ");
        for (Object obj : objects) {
            if (obj == null) {
                s.append("EMPTY ");
                continue;
            }
            s.append(obj).append(" ");
        }
        IndustrialRenewal.LOGGER.info(String.valueOf(s));
    }

    public static void sendChatMessage(Player player, String str) {
        if (player == null) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237113_((String)str), false);
        } else {
            player.m_5661_((Component)Component.m_237113_((String)str), false);
        }
    }

    public static void sendConsoleMessage(String str) {
        System.out.println(str);
    }

    public static String formatEnergyString(int energy) {
        String text = energy + " FE";
        if (energy >= 1000 && energy < 1000000) {
            text = form.format((float)energy / 1000.0f) + "K FE";
        } else if (energy >= 1000000 && energy < 1000000000) {
            text = form.format((float)energy / 1000000.0f) + "M FE";
        } else if (energy >= 1000000000) {
            text = form.format((float)energy / 1.0E9f) + "B FE";
        }
        return text;
    }

    public static String formatFluidAmountString(int amount) {
        String text = amount + " mB";
        if (amount >= 10000 && amount < 1000000) {
            text = form.format((float)amount / 1000.0f) + " B";
        } else if (amount >= 1000000 && amount < 1000000000) {
            text = form.format((float)amount / 1000000.0f) + " KB";
        } else if (amount >= 1000000000) {
            text = form.format((float)amount / 1.0E9f) + " BB";
        }
        return text;
    }

    public static float normalizeClamped(float value, float min, float max) {
        return Mth.m_14036_((float)(value - min), (float)min, (float)(max - min)) / (max - min);
    }

    public static float normalize(float value, float min, float max) {
        return (value - min) / (max - min);
    }

    public static int roundtoInteger(double d) {
        int i;
        double dAbs = Math.abs(d);
        double result = dAbs - (double)(i = (int)dAbs);
        if (result < 0.5) {
            return d < 0.0 ? -i : i;
        }
        return d < 0.0 ? -(i + 1) : i + 1;
    }

    public static int directionToInt(Direction d) {
        switch (d) {
            case DOWN: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case SOUTH: {
                return 3;
            }
            case WEST: {
                return 4;
            }
            case EAST: {
                return 5;
            }
        }
        return 2;
    }

    public static Direction intToDir(int d) {
        switch (d) {
            case 0: {
                return Direction.DOWN;
            }
            case 1: {
                return Direction.UP;
            }
            case 2: {
                return Direction.NORTH;
            }
            case 3: {
                return Direction.SOUTH;
            }
            case 4: {
                return Direction.WEST;
            }
            case 5: {
                return Direction.EAST;
            }
        }
        return Direction.NORTH;
    }

    public static Direction quadToDir(Vec3 vector3d) {
        if (vector3d.f_82481_ > vector3d.f_82479_ && vector3d.f_82481_ > -vector3d.f_82479_) {
            return Direction.SOUTH;
        }
        if (vector3d.f_82481_ < vector3d.f_82479_ && vector3d.f_82481_ < -vector3d.f_82479_) {
            return Direction.NORTH;
        }
        if (vector3d.f_82481_ > vector3d.f_82479_ && vector3d.f_82481_ < -vector3d.f_82479_) {
            return Direction.WEST;
        }
        if (vector3d.f_82481_ < vector3d.f_82479_ && vector3d.f_82481_ > -vector3d.f_82479_) {
            return Direction.EAST;
        }
        return Direction.NORTH;
    }

    public static Direction rotateAround(Direction d, Direction.Axis axis) {
        switch (axis) {
            case X: {
                if (d != Direction.WEST && d != Direction.EAST) {
                    return Utils.rotateX(d);
                }
                return d;
            }
            case Y: {
                if (d != Direction.UP && d != Direction.DOWN) {
                    return d.m_122427_();
                }
                return d;
            }
            case Z: {
                if (d != Direction.NORTH && d != Direction.SOUTH) {
                    return Utils.rotateZ(d);
                }
                return d;
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + String.valueOf(axis));
    }

    public static Direction rotateX(Direction d) {
        switch (d) {
            case NORTH: {
                return Direction.DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(d));
            }
            case SOUTH: {
                return Direction.UP;
            }
            case UP: {
                return Direction.NORTH;
            }
            case DOWN: 
        }
        return Direction.SOUTH;
    }

    public static Direction rotateZ(Direction d) {
        switch (d) {
            case EAST: {
                return Direction.DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(d));
            }
            case WEST: {
                return Direction.UP;
            }
            case UP: {
                return Direction.EAST;
            }
            case DOWN: 
        }
        return Direction.WEST;
    }

    public static float lerp(float a, float b, float f) {
        return a + f * (b - a);
    }

    public static double lerp(double a, double b, double f) {
        return a + f * (b - a);
    }

    public static void dropInventoryItems(Level level, BlockPos pos, ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)itemStackHandler.getStackInSlot(i));
        }
    }

    public static void dropInventoryItems(Level level, Vec3 vec3, ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            Containers.m_18992_((Level)level, (double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_, (ItemStack)itemStackHandler.getStackInSlot(i));
        }
    }

    public static void spawnItemStack(Level worldIn, BlockPos pos, ItemStack stack) {
        if (worldIn.f_46443_) {
            return;
        }
        float f = RANDOM.nextFloat() * 0.8f + 0.1f;
        float f1 = RANDOM.nextFloat() * 0.8f + 0.1f;
        float f2 = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (!stack.m_41619_()) {
            ItemEntity entityitem = new ItemEntity(worldIn, (double)pos.m_123341_() + (double)f, (double)pos.m_123342_() + (double)f1, (double)pos.m_123343_() + (double)f2, stack.m_41620_(RANDOM.nextInt(21) + 10));
            entityitem.m_20334_(RANDOM.nextGaussian() * (double)0.05f, RANDOM.nextGaussian() * (double)0.05f + (double)0.2f, RANDOM.nextGaussian() * (double)0.05f);
            worldIn.m_7967_((Entity)entityitem);
        }
    }

    public static double getDistanceSq(BlockPos pos, double x, double y, double z) {
        double d0 = (double)pos.m_123341_() + 0.5 - x;
        double d1 = (double)pos.m_123342_() + 0.5 - y;
        double d2 = (double)pos.m_123343_() + 0.5 - z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public static IFluidHandler wrapFluidBlock(BlockState state, Level world, BlockPos pos) {
        return new BlockWrapper(state, world, pos);
    }

    public static List<BlockPos> getBlocksIn3x3x3Centered(BlockPos pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int y = -1; y < 2; ++y) {
            for (int z = -1; z < 2; ++z) {
                for (int x = -1; x < 2; ++x) {
                    list.add(new BlockPos(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z));
                }
            }
        }
        return list;
    }

    public static List<BlockPos> getBlocksIn3x2x3Centered(BlockPos pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int y = -1; y < 1; ++y) {
            for (int z = -1; z < 2; ++z) {
                for (int x = -1; x < 2; ++x) {
                    list.add(new BlockPos(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z));
                }
            }
        }
        return list;
    }

    public static List<BlockPos> getBlocksIn3x3x2Centered(BlockPos pos, Direction facing) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        boolean isSided = facing == Direction.EAST || facing == Direction.WEST;
        boolean invert = facing == Direction.NORTH || facing == Direction.WEST;
        for (int y = -1; y < 2; ++y) {
            for (int z = 0; z < 2; ++z) {
                for (int x = -1; x < 2; ++x) {
                    int finalX = isSided ? z : x;
                    int finalZ = isSided ? x : z;
                    list.add(new BlockPos(pos.m_123341_() + (invert ? -finalX : finalX), pos.m_123342_() + y, pos.m_123343_() + (invert ? -finalZ : finalZ)));
                }
            }
        }
        return list;
    }

    public static List<BlockPos> getBlocksIn3x2x2Centered(BlockPos pos, Direction facing) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        boolean isSided = facing == Direction.EAST || facing == Direction.WEST;
        boolean invert = facing == Direction.NORTH || facing == Direction.WEST;
        for (int y = 0; y < 2; ++y) {
            for (int z = 0; z < 2; ++z) {
                for (int x = -1; x < 2; ++x) {
                    int finalX = isSided ? z : x;
                    int finalZ = isSided ? x : z;
                    list.add(new BlockPos(pos.m_123341_() + (invert ? -finalX : finalX), pos.m_123342_() + y, pos.m_123343_() + (invert ? -finalZ : finalZ)));
                }
            }
        }
        return list;
    }

    public static float getConvertedTemperature(float temp) {
        int scaleSetting = 0;
        switch (scaleSetting) {
            default: {
                return temp;
            }
            case 1: {
                return (float)((double)temp * 1.8 + 32.0);
            }
            case 2: 
        }
        return (float)((double)temp + 273.15);
    }

    public static String getTemperatureUnit() {
        String st = "";
        int scaleSetting = 0;
        switch (scaleSetting) {
            default: {
                return "??";
            }
            case 0: {
                return "C\u00ba";
            }
            case 1: {
                return "F";
            }
            case 2: 
        }
        return "K";
    }

    public static boolean isInventoryFull(Container inv) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (!inv.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static boolean moveFluidToTank(FluidTank from, IFluidHandler to) {
        to.fill(from.drain(to.fill(from.drain(200, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        return false;
    }

    public static boolean moveFluidToTank(IFluidHandler from, FluidTank to) {
        to.fill(from.drain(to.fill(from.drain(200, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        return false;
    }

    public static boolean moveItemToInventory(IItemHandler from, int slot, IItemHandler to) {
        boolean movement = false;
        for (int j = 0; j < to.getSlots(); ++j) {
            ItemStack left;
            ItemStack stack = from.getStackInSlot(slot);
            if (stack.m_41619_() || !to.isItemValid(j, stack) || ItemStack.m_41656_((ItemStack)stack, (ItemStack)(left = to.insertItem(j, stack, false)))) continue;
            int toExtract = stack.m_41613_() - left.m_41613_();
            from.extractItem(slot, toExtract, false);
            movement = true;
        }
        return movement;
    }

    public static boolean moveItemsBetweenInventories(Container from, IItemHandler to) {
        if (to == null || from == null) {
            return false;
        }
        for (int i = 0; i < from.m_6643_(); ++i) {
            if (from.m_8020_(i).m_41619_()) continue;
            ItemStack remainder = null;
            remainder = from.m_8020_(i).m_41777_();
            remainder.m_41764_(1);
            for (int j = 0; j < to.getSlots(); ++j) {
                if (!(remainder = to.insertItem(j, remainder, false)).m_41619_()) continue;
                from.m_8020_(i).m_41774_(1);
                from.m_6596_();
                return true;
            }
        }
        return false;
    }

    public static boolean moveItemsBetweenInventories(IItemHandler from, Container to) {
        if (to == null || from == null) {
            return false;
        }
        for (int i = 0; i < from.getSlots(); ++i) {
            ItemStack stack = from.extractItem(i, 1, true);
            if (stack.m_41619_()) continue;
            for (int j = 0; j < to.m_6643_(); ++j) {
                if (to.m_8020_(j).m_41619_()) {
                    to.m_6836_(j, from.extractItem(i, 1, false));
                    to.m_6596_();
                    return true;
                }
                if (!ItemStack.m_150942_((ItemStack)to.m_8020_(j), (ItemStack)stack) || !to.m_8020_(j).equals(stack) || !to.m_8020_(j).m_41753_() || to.m_8020_(j).m_41613_() >= to.m_8020_(j).m_41741_()) continue;
                from.extractItem(i, 1, false);
                to.m_8020_(j).m_41769_(1);
                to.m_6596_();
                return true;
            }
        }
        return false;
    }

    public static boolean moveItemsBetweenInventories(IItemHandler from, IItemHandler to) {
        return Utils.moveItemsBetweenInventories(from, to, true, Integer.MAX_VALUE);
    }

    public static boolean moveItemsBetweenInventories(IItemHandler from, IItemHandler to, int maxStackCount) {
        return Utils.moveItemsBetweenInventories(from, to, true, maxStackCount);
    }

    private static boolean moveItemsBetweenInventories(IItemHandler from, IItemHandler to, boolean stackPerTick, int maxStackCount) {
        boolean movement = false;
        for (int i = 0; i < from.getSlots(); ++i) {
            boolean needBreak = false;
            ItemStack stack = from.extractItem(i, maxStackCount, true);
            for (int j = 0; j < to.getSlots(); ++j) {
                ItemStack left;
                if (stack.m_41619_() || !to.isItemValid(j, stack) || ItemStack.m_41656_((ItemStack)stack, (ItemStack)(left = to.insertItem(j, stack, false)))) continue;
                int toExtract = stack.m_41613_() - left.m_41613_();
                from.extractItem(i, toExtract, false);
                movement = true;
                if (!stackPerTick) continue;
                needBreak = true;
                break;
            }
            if (stackPerTick && needBreak) break;
        }
        return movement;
    }

    public static String formatPreciseEnergyString(int energy) {
        String text = energy + " FE";
        if (energy >= 1000 && energy < 1000000) {
            text = preciseForm.format((float)energy / 1000.0f) + "K FE";
        } else if (energy >= 1000000 && energy < 1000000000) {
            text = preciseForm.format((float)energy / 1000000.0f) + "M FE";
        } else if (energy >= 1000000000) {
            text = preciseForm.format((float)energy / 1.0E9f) + "B FE";
        }
        return text;
    }

    public static float getInvNorm(IItemHandler inventory) {
        if (inventory == null) {
            return 0.0f;
        }
        float items = 0.0f;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.m_41619_()) continue;
            items += 1.0f;
        }
        return items / (float)inventory.getSlots();
    }

    public static boolean IsInventoryEmpty(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static boolean IsInventoryFull(IItemHandler handler) {
        int slotsFull = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            ++slotsFull;
        }
        return slotsFull == handler.getSlots();
    }

    public static float logisticFunction(float L, float k, float xo, float x) {
        return (float)((double)L / (1.0 + Math.exp(-k * (x - xo))));
    }

    public static Vector3d midPoint(Vector3d start, Vector3d end, double yOffset) {
        double x = (start.x + end.x) / 2.0;
        double y = (start.y + end.y) / 2.0;
        double z = (start.z + end.z) / 2.0;
        return new Vector3d(x, y + yOffset, z);
    }

    public static Vector3d midPoint(Vector3d start, Vector3d end) {
        return Utils.midPoint(start, end, 0.0);
    }

    public static Vector3d lerp(Vector3d start, Vector3d end, double amount) {
        amount = Mth.m_14008_((double)amount, (double)0.0, (double)1.0);
        double x = Utils.lerp(start.x, end.x, amount);
        double y = Utils.lerp(start.y, end.y, amount);
        double z = Utils.lerp(start.z, end.z, amount);
        return new Vector3d(x, y, z);
    }

    public static Vector3f lerp(Vector3f start, Vector3f end, float amount) {
        amount = Mth.m_14036_((float)amount, (float)0.0f, (float)1.0f);
        float x = Utils.lerp(start.x(), end.x(), amount);
        float y = Utils.lerp(start.y(), end.y(), amount);
        float z = Utils.lerp(start.z(), end.z(), amount);
        return new Vector3f(x, y, z);
    }

    public static double distance(BlockPos start, BlockPos end) {
        return Math.sqrt(start.m_123331_((Vec3i)end));
    }

    public static boolean isSamePosition(BlockPos pos1, BlockPos pos2) {
        long p2;
        long p1 = pos1.m_121878_();
        return p1 == (p2 = pos2.m_121878_());
    }
}

