/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.item;

import com.google.common.collect.MapMaker;
import java.util.Map;
import java.util.UUID;
import net.cassiokf.industrialrenewal.item.IRBaseItem;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.enums.EnumCouplingType;
import net.cassiokf.industrialrenewal.util.interfaces.ICoupleCart;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ItemCartLinker
extends IRBaseItem {
    static final UUID NULL_UUID = new UUID(0L, 0L);
    private static final Map<Player, AbstractMinecart> linkMap = new MapMaker().weakKeys().weakValues().makeMap();

    public ItemCartLinker() {
        super(new Item.Properties().m_41487_(1));
    }

    public static void onPlayerUseLinkableItemOnCart(Player player, AbstractMinecart cart) {
        AbstractMinecart last = linkMap.remove(player);
        if (last != null && last.m_6084_()) {
            if (last.m_20182_().m_82554_(cart.m_20182_()) > 3.0) {
                Utils.sendChatMessage(player, "Coupling Failed, TOO FAR");
                return;
            }
            if (ItemCartLinker.CoupleCarts(last, cart)) {
                Utils.sendChatMessage(player, "Carts Coupled");
                Utils.sendConsoleMessage("player " + player.m_5446_().getString() + " Connected " + String.valueOf(last.m_7755_()) + " to " + String.valueOf(cart.m_7755_()));
                return;
            }
            Utils.sendChatMessage(player, "Coupling Canceled");
        } else {
            linkMap.put(player, cart);
            Utils.sendChatMessage(player, "Coupling Start");
        }
    }

    public static boolean CoupleCarts(AbstractMinecart cart1, AbstractMinecart cart2) {
        if (ItemCartLinker.canCoupleCarts(cart1, cart2)) {
            ItemCartLinker.setConnection(cart1, cart2);
            ItemCartLinker.setConnection(cart2, cart1);
            return true;
        }
        return false;
    }

    private static void setConnection(AbstractMinecart from, AbstractMinecart to) {
    }

    private static boolean canCoupleCarts(AbstractMinecart cart1, AbstractMinecart cart2) {
        return cart1.m_20280_((Entity)cart2) <= (double)ItemCartLinker.getMaxCouplingDistance(cart1, cart2);
    }

    public static boolean thereIsNoConnectionLeft(AbstractMinecart cart) {
        return !ItemCartLinker.hasFreeConnectionIn(cart, EnumCouplingType.COUPLING_1) && !ItemCartLinker.hasFreeConnectionIn(cart, EnumCouplingType.COUPLING_2);
    }

    public static boolean hasFreeConnectionIn(AbstractMinecart cart, EnumCouplingType type) {
        return false;
    }

    private static float getMaxCouplingDistance(AbstractMinecart cart1, AbstractMinecart cart2) {
        float defaultDistance = 1.6f;
        float dist = 0.0f;
        dist = cart1 instanceof ICoupleCart ? (dist += ((ICoupleCart)cart1).getMaxCouplingDistance(cart2)) : (dist += defaultDistance);
        dist = cart2 instanceof ICoupleCart ? (dist += ((ICoupleCart)cart2).getMaxCouplingDistance(cart1)) : (dist += defaultDistance);
        return dist * dist;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = world.m_8055_(pos);
        return super.m_6225_(context);
    }
}

