/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity.transport;

import java.util.Map;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntityFluidPipeBase;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.util.capability.CustomFluidTank;
import net.cassiokf.industrialrenewal.util.capability.CustomPressureFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockEntityHighPressureFluidPipe
extends BlockEntityFluidPipeBase<BlockEntityHighPressureFluidPipe> {
    public static int MAX_PRESSURE_TRANSFER = 10000;
    private final CustomPressureFluidTank cTank = new CustomPressureFluidTank(){

        @Override
        public int receiveCompressedFluid(int amount, int y, IFluidHandler.FluidAction action) {
            return BlockEntityHighPressureFluidPipe.this.passCompressedFluid(amount, y, action);
        }

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return BlockEntityHighPressureFluidPipe.this.onFluidReceived(resource, action);
        }
    };

    public BlockEntityHighPressureFluidPipe(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.HIGH_PRESSURE_PIPE.get(), pos, state, MAX_PRESSURE_TRANSFER);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && this.isMaster()) {
            this.limitedOutPutMap.clear();
        }
    }

    @Override
    public CustomFluidTank getTank() {
        return this.cTank;
    }

    public int passCompressedFluid(int amount, int y, IFluidHandler.FluidAction action) {
        if (!this.isMaster() && !this.isMasterInvalid()) {
            return ((BlockEntityHighPressureFluidPipe)((Object)this.getMaster())).passCompressedFluid(amount, y, action);
        }
        if (this.inUse || amount <= 0) {
            return 0;
        }
        this.inUse = true;
        int out = 0;
        Map<BlockEntity, Direction> mapPosSet = this.getReceiversPressurizedContainer();
        int quantity = this.getRealQuantity(mapPosSet);
        if (quantity > 0) {
            out = this.moveFluid(amount, y, action, mapPosSet);
            if (action.equals((Object)IFluidHandler.FluidAction.EXECUTE)) {
                this.outPut += out;
            }
        }
        this.outPutCount = quantity;
        this.inUse = false;
        return out;
    }

    public int moveFluid(int amount, int y, IFluidHandler.FluidAction action, Map<BlockEntity, Direction> mapPosSet) {
        int out = 0;
        int validOutputs = mapPosSet.size();
        if (validOutputs == 0) {
            return 0;
        }
        int realMaxOutput = Math.min(amount / validOutputs, MAX_PRESSURE_TRANSFER);
        for (BlockEntity te : mapPosSet.keySet()) {
            CustomPressureFluidTank c;
            Direction face;
            IFluidHandler f = (IFluidHandler)te.getCapability(ForgeCapabilities.FLUID_HANDLER, face = mapPosSet.get(te).m_122424_()).orElse(null);
            if (!(f instanceof CustomPressureFluidTank) || !(c = (CustomPressureFluidTank)f).canPassCompressedFluid() || (realMaxOutput = this.getLimitedValueForOutPut(realMaxOutput, MAX_PRESSURE_TRANSFER, te, action.equals((Object)IFluidHandler.FluidAction.SIMULATE))) <= 0) continue;
            out += c.receiveCompressedFluid(realMaxOutput, y, action);
        }
        return out;
    }

    private int getRealQuantity(Map<BlockEntity, Direction> mapPosSet) {
        this.cleanReceiversPressurizedContainer();
        return mapPosSet.size();
    }

    @Override
    public void checkForOutPuts(BlockPos bPos) {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            for (Direction face : Direction.values()) {
                CustomPressureFluidTank cf;
                boolean canReceivePressurized;
                BlockPos currentPos = this.f_58858_.m_121945_(face);
                BlockEntity te = this.f_58857_.m_7702_(currentPos);
                boolean hasMachine = te != null && !(te instanceof BlockEntityFluidPipeBase);
                IFluidHandler fh = te != null ? (IFluidHandler)te.getCapability(ForgeCapabilities.FLUID_HANDLER, face.m_122424_()).orElse(null) : null;
                boolean canReceive = fh != null && fh.getTankCapacity(0) > 0;
                boolean bl = canReceivePressurized = fh instanceof CustomPressureFluidTank && (cf = (CustomPressureFluidTank)fh).canPassCompressedFluid();
                if (!hasMachine) continue;
                if (canReceive) {
                    if (!this.isMasterInvalid()) {
                        ((BlockEntityHighPressureFluidPipe)((Object)this.getMaster())).addReceiver(te, face);
                    }
                } else if (!this.isMasterInvalid()) {
                    ((BlockEntityHighPressureFluidPipe)((Object)this.getMaster())).removeReceiver(te);
                }
                if (canReceivePressurized) {
                    if (this.isMasterInvalid()) continue;
                    ((BlockEntityHighPressureFluidPipe)((Object)this.getMaster())).addReceiverPressurized(te, face);
                    continue;
                }
                if (this.isMasterInvalid()) continue;
                ((BlockEntityHighPressureFluidPipe)((Object)this.getMaster())).removeReceiverPressurized(te);
            }
            ((BlockEntityHighPressureFluidPipe)((Object)this.getMaster())).cleanReceiversContainer();
            ((BlockEntityHighPressureFluidPipe)((Object)this.getMaster())).cleanReceiversPressurizedContainer();
        }
    }

    @Override
    public boolean instanceOf(BlockEntity te) {
        return te instanceof BlockEntityHighPressureFluidPipe;
    }
}

