/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity.transport;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.block.abstracts.BlockPipeSwitchBase;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.init.ModBlocks;
import net.cassiokf.industrialrenewal.util.capability.CustomEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class BlockEntityEnergySwitch
extends BlockEntitySyncable {
    private final CustomEnergyStorage dummyStorage = new CustomEnergyStorage(0);
    private final CustomEnergyStorage energyStorage = new CustomEnergyStorage(0){

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (maxReceive <= 0 || !BlockEntityEnergySwitch.this.isOpen()) {
                return 0;
            }
            IEnergyStorage out = BlockEntityEnergySwitch.this.getOutput();
            if (out != null) {
                return out.receiveEnergy(maxReceive, simulate);
            }
            return 0;
        }

        @Override
        public boolean canReceive() {
            return BlockEntityEnergySwitch.this.isOpen();
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        @Override
        public boolean canExtract() {
            return false;
        }
    };
    private final LazyOptional<CustomEnergyStorage> energyStorageHandler = LazyOptional.of(() -> this.energyStorage);
    private final LazyOptional<CustomEnergyStorage> dummyStorageHandler = LazyOptional.of(() -> this.dummyStorage);

    public BlockEntityEnergySwitch(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.ENERGY_SWITCH_TILE.get(), pos, state);
    }

    private IEnergyStorage getOutput() {
        if (this.f_58857_ == null) {
            return null;
        }
        Direction facing = this.getFacing();
        BlockEntity outputTile = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing));
        if (outputTile != null) {
            return (IEnergyStorage)outputTile.getCapability(ForgeCapabilities.ENERGY, facing.m_122424_()).orElse(null);
        }
        return null;
    }

    private boolean isOpen() {
        return this.m_58900_().m_60713_((Block)ModBlocks.ENERGY_SWITCH.get()) ? (Boolean)this.m_58900_().m_61143_((Property)BlockPipeSwitchBase.ON_OFF) : false;
    }

    private Direction getFacing() {
        return this.m_58900_().m_60713_((Block)ModBlocks.ENERGY_SWITCH.get()) ? (Direction)this.m_58900_().m_61143_((Property)BlockPipeSwitchBase.FACING) : Direction.NORTH;
    }

    public void invalidateCaps() {
        this.energyStorageHandler.invalidate();
        this.dummyStorageHandler.invalidate();
        super.invalidateCaps();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        Direction facing = this.getFacing();
        if (side == null) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.ENERGY) {
            if (side == facing.m_122424_()) {
                return this.energyStorageHandler.cast();
            }
            if (side == facing) {
                return this.dummyStorageHandler.cast();
            }
        }
        return super.getCapability(cap, side);
    }
}

