/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity.dam;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.block.dam.BlockDamIntake;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.init.ModBlocks;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.capability.CustomFluidTank;
import net.cassiokf.industrialrenewal.util.capability.CustomPressureFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockEntityDamIntake
extends BlockEntitySyncable {
    private static final int WIDTH = 13;
    private static final int HEIGHT = 11;
    private static final int DEPTH = 10;
    private static final int MAX_WATER = 1430;
    public static int MAX_WATER_PRODUCTION = 10000;
    public final CustomPressureFluidTank tank = new CustomPressureFluidTank(0){

        @Override
        public boolean canDrain() {
            return false;
        }

        @Override
        public boolean canFill() {
            return false;
        }

        @Override
        public boolean canPassCompressedFluid() {
            return false;
        }
    };
    public final LazyOptional<CustomFluidTank> tankHandler = LazyOptional.of(() -> this.tank);
    private final List<BlockPos> connectedWalls = new CopyOnWriteArrayList<BlockPos>();
    private final List<BlockPos> failBlocks = new CopyOnWriteArrayList<BlockPos>();
    private final List<BlockPos> failWaters = new CopyOnWriteArrayList<BlockPos>();
    public int currentProduction = 0;
    public int tick = 0;
    private int waterAmount = -1;
    private BlockPos neighborPos = null;
    private int concreteAmount;
    private boolean firstTick = false;

    public BlockEntityDamIntake(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.DAM_INTAKE.get(), pos, state);
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.firstTick) {
            this.firstTick = true;
            this.firstTick();
        }
        if (!this.f_58857_.f_46443_ && this.getWaterAmount() > 0) {
            this.passFluidOut();
        }
    }

    public void firstTick() {
        this.initializeMultiblockIfNecessary(true);
    }

    private void passFluidOut() {
        IFluidHandler f;
        BlockEntity tileBehind = this.f_58857_.m_7702_(this.getOutPutPos());
        if (tileBehind != null && (f = (IFluidHandler)tileBehind.getCapability(ForgeCapabilities.FLUID_HANDLER, this.getFacing()).orElse(null)) != null) {
            if (f instanceof CustomPressureFluidTank) {
                CustomPressureFluidTank c = (CustomPressureFluidTank)f;
                c.receiveCompressedFluid(this.waterAmount, this.f_58858_.m_123342_(), IFluidHandler.FluidAction.EXECUTE);
                return;
            }
            f.fill(new FluidStack((Fluid)Fluids.f_76193_, this.waterAmount), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private BlockPos getOutPutPos() {
        if (this.neighborPos != null) {
            return this.neighborPos;
        }
        this.neighborPos = this.f_58858_.m_121945_(this.getFacing().m_122424_());
        return this.neighborPos;
    }

    public boolean onBlockActivated(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return true;
        }
        this.cleanWallCached();
        this.initializeMultiblockIfNecessary(true);
        int percentage = this.waterAmount / 100;
        boolean done = false;
        if (percentage < 100 && this.failWaters.size() > 0 && player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == Items.f_42447_ && this.tryFillDam(player)) {
            done = true;
        }
        Utils.sendChatMessage(player, "Efficiency: " + percentage + "%");
        if (done) {
            return true;
        }
        if (percentage < 100) {
            if (this.concreteAmount < 143) {
                this.sendFailBlockMessage(player);
            } else {
                this.sendFailWaterBlockMessage(player);
            }
        }
        return true;
    }

    private boolean tryFillDam(Player player) {
        BlockState state;
        BlockPos bPos = this.getNextReplaceableBlockForWater();
        if (bPos != null && (state = this.f_58857_.m_8055_(bPos)).m_247087_()) {
            this.f_58857_.m_7731_(bPos, Blocks.f_49990_.m_49966_(), 3);
            this.failWaters.remove(bPos);
            if (!player.m_7500_()) {
                player.m_21120_(InteractionHand.MAIN_HAND).m_41774_(1);
                player.m_36356_(new ItemStack((ItemLike)Items.f_42446_));
            }
            return true;
        }
        return false;
    }

    private void sendFailBlockMessage(Player player) {
        block0: {
            Utils.sendChatMessage(player, "Concrete Amount: " + this.concreteAmount + " / 143");
            Iterator<BlockPos> iterator = this.failBlocks.iterator();
            if (!iterator.hasNext()) break block0;
            BlockPos bPos = iterator.next();
            Block block = this.f_58857_.m_8055_(bPos).m_60734_();
            String msg = block.equals(ModBlocks.CONCRETE.get()) ? "Concrete at " + bPos.m_123344_() + " already used by another Intake" : block.m_7705_() + " at: " + bPos.m_123344_() + " is not a valid dam block";
            Utils.sendChatMessage(player, msg);
        }
    }

    private void sendFailWaterBlockMessage(Player player) {
        Utils.sendChatMessage(player, "Water Amount: " + this.waterAmount + " / 1000");
        for (BlockPos bPos : this.failWaters) {
            Utils.sendChatMessage(player, "Block at: " + bPos.m_123344_() + " is not a water source");
        }
    }

    private BlockPos getNextReplaceableBlockForWater() {
        for (BlockPos bPos : this.failWaters) {
            BlockState state = this.f_58857_.m_8055_(bPos);
            if (!state.m_247087_()) continue;
            return bPos;
        }
        return null;
    }

    public int getWaterAmount() {
        this.initializeMultiblockIfNecessary(false);
        return this.waterAmount;
    }

    private void initializeMultiblockIfNecessary(boolean forced) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        if (this.waterAmount < 0 || forced) {
            this.cleanWallCached();
            Direction facing = this.getFacing();
            this.searchForConcrete(facing);
            this.searchForWater(facing);
        }
    }

    private void searchForWater(Direction facing) {
        this.failWaters.clear();
        this.waterAmount = 0;
        for (BlockPos wall : this.connectedWalls) {
            int f;
            for (f = 1; this.f_58857_.m_8055_(wall.m_5484_(facing, f)).m_60734_().equals(Blocks.f_49990_) && this.f_58857_.m_8055_(wall.m_5484_(facing, f)).m_60819_().m_76170_() && f <= 10; ++f) {
            }
            if (f < 10) {
                this.failWaters.add(wall.m_5484_(this.getFacing(), f));
            }
            this.waterAmount += f - 1;
        }
        this.waterAmount = (int)(Utils.normalizeClamped(this.waterAmount, 0.0f, 1430.0f) * (float)MAX_WATER_PRODUCTION);
    }

    private void searchForConcrete(Direction facing) {
        BlockPos pos = this.f_58858_;
        this.failBlocks.clear();
        for (int x = -6; x <= 6; ++x) {
            for (int y = 0; y <= 10; ++y) {
                BlockPos cPos = facing == Direction.NORTH || facing == Direction.SOUTH ? new BlockPos(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_()) : new BlockPos(pos.m_123341_(), pos.m_123342_() + y, pos.m_123343_() + x);
                BlockState state = this.f_58857_.m_8055_(cPos);
                if (state.m_60734_().equals(ModBlocks.CONCRETE.get()) || Utils.isSamePosition(cPos, pos)) {
                    this.connectedWalls.add(cPos);
                    continue;
                }
                this.failBlocks.add(cPos);
            }
        }
        this.concreteAmount = this.connectedWalls.size();
    }

    private void cleanWallCached() {
        this.connectedWalls.clear();
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        compoundTag.m_128405_("production", this.currentProduction);
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        this.currentProduction = compoundTag.m_128451_("production");
        super.m_142466_(compoundTag);
    }

    public Direction getFacing() {
        return this.m_58900_().m_60713_((Block)ModBlocks.DAM_INTAKE.get()) ? (Direction)this.m_58900_().m_61143_((Property)BlockDamIntake.FACING) : Direction.NORTH;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (side == null) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && side == this.getFacing().m_122424_()) {
            return this.tankHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

