/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity.dam;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntity3x3x3MachineBase;
import net.cassiokf.industrialrenewal.blockentity.dam.BlockEntityDamTurbine;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.capability.CustomEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class BlockEntityDamGenerator
extends BlockEntity3x3x3MachineBase<BlockEntityDamGenerator> {
    public static int maxGeneration = 1024;
    public static int transferRate = 1024;
    private static final int energyCapacity = 10240;
    public CustomEnergyStorage energyStorage = new CustomEnergyStorage(10240).setBlockEntity(this).noReceive();
    public final LazyOptional<CustomEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);
    private int oldGeneration;
    private int generation;
    private int rotation;

    public BlockEntityDamGenerator(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.DAM_GENERATOR.get(), pos, state);
    }

    public void tick() {
        if (!this.f_58857_.f_46443_ && this.isMaster()) {
            this.chargeInternalBattery();
            this.passEnergyOut();
            if (this.generation != this.oldGeneration) {
                this.oldGeneration = this.generation;
                this.sync();
            }
            this.rotation = 0;
        }
    }

    public void chargeInternalBattery() {
        this.generation = (int)(Utils.normalizeClamped(this.rotation, 0.0f, BlockEntityDamTurbine.MAX_PROCESSING) * (float)maxGeneration);
        this.generation = this.generation > 0 ? this.energyStorage.addEnergy(this.generation, false) : 0;
    }

    public void passEnergyOut() {
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_6630_(2));
        if (te != null) {
            te.getCapability(ForgeCapabilities.ENERGY, Direction.DOWN).ifPresent(iEnergyStorage -> {
                int amount = iEnergyStorage.receiveEnergy(transferRate, true);
                iEnergyStorage.receiveEnergy(this.energyStorage.subtractEnergy(amount, false), false);
            });
        }
    }

    public void updateRotation(int newRotation) {
        if (this.rotation != newRotation) {
            this.rotation = newRotation;
        }
    }

    public String getGenerationText() {
        return Utils.formatEnergyString(this.generation) + "/t";
    }

    public float getGenerationFill() {
        return Utils.normalizeClamped(this.generation, 0.0f, maxGeneration) * 90.0f;
    }

    @Override
    public boolean instanceOf(BlockEntity tileEntity) {
        return tileEntity instanceof BlockEntityDamGenerator;
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        compoundTag.m_128405_("energy", this.energyStorage.getEnergyStored());
        compoundTag.m_128405_("rotation", this.rotation);
        compoundTag.m_128405_("generation", this.generation);
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        this.energyStorage.setEnergy(compoundTag.m_128451_("energy"));
        this.rotation = compoundTag.m_128451_("rotation");
        this.generation = compoundTag.m_128451_("generation");
        super.m_142466_(compoundTag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        BlockEntityDamGenerator masterTE = (BlockEntityDamGenerator)((Object)this.getMaster());
        if (masterTE == null || side == null) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.ENERGY && side == Direction.UP && this.f_58858_.equals((Object)masterTE.m_58899_().m_7494_())) {
            return ((BlockEntityDamGenerator)((Object)this.getMaster())).energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

