/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity.abstracts;

import java.util.ArrayList;
import java.util.List;
import net.cassiokf.industrialrenewal.block.abstracts.BlockTowerBase;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntity3x3x3MachineBase;
import net.cassiokf.industrialrenewal.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class BlockEntityTowerBase<TE extends BlockEntityTowerBase<?>>
extends BlockEntity3x3x3MachineBase<TE> {
    public ArrayList<TE> tower = null;

    public BlockEntityTowerBase(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public boolean instanceOf(BlockEntity tileEntity) {
        return tileEntity instanceof BlockEntityTowerBase;
    }

    public void setSelfBooleanProperty() {
        BlockState blockState;
        BlockEntity te;
        if (this.f_58857_ == null) {
            return;
        }
        List<BlockPos> blocks = Utils.getBlocksIn3x3x3Centered(((BlockEntityTowerBase)((Object)this.getMaster())).f_58858_);
        if (this.isAligned(true)) {
            for (BlockPos blockPos : blocks) {
                te = this.f_58857_.m_7702_(blockPos);
                blockState = this.f_58857_.m_8055_(blockPos);
                if (!this.instanceOf(te)) continue;
                this.f_58857_.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)BlockTowerBase.TOP, (Comparable)Boolean.valueOf(false)));
            }
        }
        if (this.isAligned(false)) {
            for (BlockPos blockPos : blocks) {
                te = this.f_58857_.m_7702_(blockPos);
                blockState = this.f_58857_.m_8055_(blockPos);
                if (!this.instanceOf(te)) continue;
                this.f_58857_.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)BlockTowerBase.BASE, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void setSelfBooleanProperty(BooleanProperty property, boolean bool) {
        if (this.f_58857_ == null) {
            return;
        }
        List<BlockPos> blocks = Utils.getBlocksIn3x3x3Centered(((BlockEntityTowerBase)((Object)this.getMaster())).f_58858_);
        for (BlockPos blockPos : blocks) {
            BlockEntity te = this.f_58857_.m_7702_(blockPos);
            BlockState blockState = this.f_58857_.m_8055_(blockPos);
            if (!(te instanceof BlockEntityTowerBase)) continue;
            this.f_58857_.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)property, (Comparable)Boolean.valueOf(bool)));
        }
    }

    public boolean topAligned() {
        BlockPos relativePos;
        BlockEntity relativeMaster;
        if (this.f_58857_ == null) {
            return false;
        }
        BlockEntityTowerBase master = (BlockEntityTowerBase)((Object)this.getMaster());
        return master.instanceOf(relativeMaster = this.f_58857_.m_7702_(relativePos = master.m_58899_().m_6630_(3))) && ((BlockEntityTowerBase)relativeMaster).isMaster() && ((BlockEntityTowerBase)relativeMaster).getMasterFacing() == master.getMasterFacing();
    }

    public boolean botAligned() {
        BlockPos relativePos;
        BlockEntity relativeMaster;
        if (this.f_58857_ == null) {
            return false;
        }
        BlockEntityTowerBase master = (BlockEntityTowerBase)((Object)this.getMaster());
        return master.instanceOf(relativeMaster = this.f_58857_.m_7702_(relativePos = master.m_58899_().m_6625_(3))) && ((BlockEntityTowerBase)relativeMaster).isMaster() && ((BlockEntityTowerBase)relativeMaster).getMasterFacing() == master.getMasterFacing();
    }

    public boolean isAligned(boolean above) {
        return above ? this.topAligned() : this.botAligned();
    }

    public void setOtherBooleanProperty(BooleanProperty property, boolean bool, boolean above) {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.isAligned(above)) {
            BlockEntityTowerBase master = (BlockEntityTowerBase)((Object)this.getMaster());
            BlockPos relativePos = above ? master.m_58899_().m_6630_(3) : master.m_58899_().m_6625_(3);
            BlockEntity relativeMaster = this.f_58857_.m_7702_(relativePos);
            ((BlockEntityTowerBase)relativeMaster).setSelfBooleanProperty(property, bool);
        }
    }

    public TE getBase() {
        if (this.f_58857_ == null) {
            return null;
        }
        BlockEntityTowerBase currentTower = (BlockEntityTowerBase)this.f_58857_.m_7702_(this.f_58858_);
        BlockPos currentPos = this.f_58858_;
        while (this.isAligned(false)) {
            currentTower = (BlockEntityTowerBase)this.f_58857_.m_7702_(currentPos = currentPos.m_6625_(3));
            if (!currentTower.isBase()) continue;
            return (TE)((Object)currentTower);
        }
        return (TE)((Object)currentTower);
    }

    public TE getTop() {
        if (this.tower != null && !this.tower.isEmpty()) {
            return (TE)((Object)((BlockEntityTowerBase)((Object)this.tower.get(this.tower.size() - 1))));
        }
        return null;
    }

    public TE getAbove() {
        if (this.f_58857_ == null) {
            return null;
        }
        BlockEntityTowerBase above = null;
        if (this.topAligned()) {
            above = (BlockEntityTowerBase)this.f_58857_.m_7702_(this.f_58858_.m_6630_(3));
        }
        return (TE)((Object)above);
    }

    public boolean isBase() {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.getMaster() == null) {
            return false;
        }
        return (Boolean)this.f_58857_.m_8055_(((BlockEntityTowerBase)((Object)this.getMaster())).f_58858_).m_61143_((Property)BlockTowerBase.BASE);
    }

    public boolean isTop() {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.getMaster() == null) {
            return false;
        }
        return (Boolean)this.f_58857_.m_8055_(((BlockEntityTowerBase)((Object)this.getMaster())).f_58858_).m_61143_((Property)BlockTowerBase.TOP);
    }

    public void loadTower() {
        this.tower = new ArrayList();
        for (BlockEntityTowerBase<TE> chunk = this; chunk != null; chunk = chunk.getAbove()) {
            if (this.tower.contains(chunk)) continue;
            this.tower.add((TE)((Object)chunk));
        }
    }

    public void addToTower(TE tile, ArrayList<TE> list) {
        if (this.tower == null) {
            this.tower = new ArrayList();
        }
        if (!this.tower.contains(tile)) {
            this.tower.add(tile);
        }
        if (list != null) {
            this.tower.addAll(list);
        }
    }

    public void removeTower(TE tile) {
        if (this.tower != null && this.tower.contains(tile)) {
            int index = this.tower.indexOf(tile);
            this.tower = new ArrayList<TE>(this.tower.subList(0, index));
        }
    }

    public String toString() {
        return "TETB " + String.valueOf(this.f_58858_);
    }
}

