/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity.abstracts;

import java.util.List;
import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.block.transport.BlockConveyor;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.capability.CustomItemStackHandler;
import net.cassiokf.industrialrenewal.util.enums.EnumConveyorType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class BlockEntityConveyorBase
extends BlockEntitySyncable
implements ICapabilityProvider {
    public double stack3Pos;
    public double stack2Pos;
    public double stack1Pos;
    public double stack3YPos;
    public double stack2YPos;
    public double stack1YPos;
    private int tick;
    private int tick2;
    private boolean getInThisTick;
    public LazyOptional<IItemHandler> inventory = LazyOptional.of(this::createHandler);
    private final LazyOptional<IItemHandler> hopperInv = LazyOptional.of(this::createHopperHandler);

    public BlockEntityConveyorBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void dropInventoryItems(Level worldIn, BlockPos pos, IItemHandler inventory) {
        if (inventory == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.m_41619_()) continue;
            Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)itemstack);
        }
    }

    private IItemHandler createHandler() {
        return new CustomItemStackHandler(3){

            public int getSlots() {
                return 1;
            }

            @Override
            protected void onContentsChanged(int slot) {
                BlockEntityConveyorBase.this.sync();
                if (slot == 0) {
                    BlockEntityConveyorBase.this.getInThisTick = true;
                }
            }
        };
    }

    private IItemHandler createHopperHandler() {
        return new CustomItemStackHandler(1){

            @Override
            protected void onContentsChanged(int slot) {
                BlockEntityConveyorBase.this.sync();
            }
        };
    }

    public void tickConveyor(int speed) {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            this.doAnimation();
        }
        if (this.tick == 1) {
            this.getInThisTick = false;
        }
        if (this.tick % speed == 0) {
            this.tick = 0;
            if (!this.f_58857_.f_46443_) {
                this.moveItem();
            }
        }
        ++this.tick;
    }

    public void tickHopper(int count) {
        if (!this.f_58857_.f_46443_) {
            if (this.tick2 % 8 == 0) {
                this.tick2 = 0;
                if (!this.getInvAbove(count)) {
                    this.getEntityItemAbove();
                }
                this.hopperToConveyor();
            }
            ++this.tick2;
        }
    }

    public void tickInserter() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.insertItem();
        }
    }

    private void doAnimation() {
        float yPos;
        ItemStack stack1 = this.getStackInSlot(0);
        ItemStack stack2 = this.getStackInSlot(1);
        ItemStack stack3 = this.getStackInSlot(2);
        int mode = this.getMode();
        float speed = 0.0825f;
        if (!stack3.m_41619_()) {
            this.stack3Pos += (double)speed;
            this.stack3Pos = Mth.m_14008_((double)this.stack3Pos, (double)0.66f, (double)1.0);
            float f = mode == 0 ? 0.47f : (yPos = mode == 1 ? 1.3f : 0.65f);
            this.stack3YPos = mode == 0 ? (double)yPos : Utils.lerp(this.stack3YPos, (double)yPos, (double)speed);
        } else {
            this.stack3Pos = 0.66f;
            double d = this.stack3YPos = mode == 0 ? (double)0.47f : (double)0.97f;
        }
        if (!stack2.m_41619_()) {
            this.stack2Pos += (double)speed;
            this.stack2Pos = Mth.m_14008_((double)this.stack2Pos, (double)0.33f, (double)0.66f);
            float f = yPos = mode == 0 ? 0.47f : 0.97f;
            this.stack2YPos = mode == 0 ? (double)yPos : Utils.lerp(this.stack2YPos, (double)yPos, (double)speed);
        } else {
            this.stack2Pos = 0.33f;
            if (mode == 1) {
                this.stack2YPos = 0.65f;
            }
            if (mode == 2) {
                this.stack2YPos = 1.3f;
            }
        }
        if (!stack1.m_41619_()) {
            this.stack1Pos += (double)speed;
            this.stack1Pos = Mth.m_14008_((double)this.stack1Pos, (double)0.0, (double)0.33f);
            float f = mode == 0 ? 0.47f : (yPos = mode == 1 ? 0.65f : 1.3f);
            this.stack1YPos = mode == 0 ? (double)yPos : Utils.lerp(this.stack1YPos, (double)yPos, (double)speed);
        } else {
            this.stack1Pos = 0.0;
            if (mode == 1) {
                this.stack1YPos = 0.3f;
            }
            if (mode == 2) {
                this.stack1YPos = 1.65f;
            }
        }
    }

    private void moveItem() {
        ItemStack backPositionItem;
        if (this.f_58857_ == null) {
            return;
        }
        ItemStack frontPositionItem = ((IItemHandler)this.inventory.orElse(null)).getStackInSlot(2);
        BlockState ownState = this.f_58857_.m_8055_(this.f_58858_);
        if (!(ownState.m_60734_() instanceof BlockConveyor)) {
            return;
        }
        Direction facing = (Direction)ownState.m_61143_((Property)BlockConveyor.FACING);
        if (!frontPositionItem.m_41619_()) {
            BlockPos frontPos = this.f_58858_.m_121945_(facing);
            int mode = (Integer)ownState.m_61143_((Property)BlockConveyor.MODE);
            BlockPos targetConveyorPos = this.frontConveyor(facing, mode);
            if (targetConveyorPos != null) {
                BlockEntityConveyorBase te = null;
                if (this.f_58857_.m_7702_(targetConveyorPos) instanceof BlockEntityConveyorBase) {
                    te = (BlockEntityConveyorBase)this.f_58857_.m_7702_(targetConveyorPos);
                }
                if (te != null) {
                    if (te.getBlockFacing() == this.getBlockFacing() && te.transferItem(frontPositionItem, false)) {
                        this.inventory.ifPresent(e -> ((CustomItemStackHandler)((Object)e)).setStackInSlot(2, ItemStack.f_41583_));
                        frontPositionItem = ItemStack.f_41583_;
                    } else if (te.getBlockFacing() != this.getBlockFacing().m_122424_() && te.getStackInSlot(1).m_41619_() && te.transferItem(frontPositionItem, 1, false)) {
                        this.inventory.ifPresent(e -> ((CustomItemStackHandler)((Object)e)).setStackInSlot(2, ItemStack.f_41583_));
                        frontPositionItem = ItemStack.f_41583_;
                    }
                }
            } else if (this.f_58857_.m_8055_(frontPos).m_60795_() && this.dropFrontItem(facing, frontPositionItem, frontPos)) {
                frontPositionItem = ItemStack.f_41583_;
            }
        }
        ItemStack MiddlePositionItem = ((IItemHandler)this.inventory.orElse(null)).getStackInSlot(1);
        if (frontPositionItem.m_41619_() && !MiddlePositionItem.m_41619_()) {
            this.moveItemInternaly(1, 2);
            MiddlePositionItem = ItemStack.f_41583_;
        }
        if (!(backPositionItem = ((IItemHandler)this.inventory.orElse(null)).getStackInSlot(0)).m_41619_() && MiddlePositionItem.m_41619_() && !this.getInThisTick) {
            this.moveItemInternaly(0, 1);
        }
        this.getInThisTick = false;
    }

    private void moveItemInternaly(int from, int to) {
        this.inventory.ifPresent(e -> ((CustomItemStackHandler)((Object)e)).setStackInSlot(to, ((IItemHandler)this.inventory.orElse(null)).getStackInSlot(from)));
        this.inventory.ifPresent(e -> ((CustomItemStackHandler)((Object)e)).setStackInSlot(from, ItemStack.f_41583_));
    }

    private BlockPos frontConveyor(Direction facing, int mode) {
        if (this.f_58857_ == null) {
            return null;
        }
        BlockPos frontPos = this.f_58858_.m_121945_(facing);
        if (mode == 1 || !(this.f_58857_.m_8055_(frontPos).m_60734_() instanceof BlockConveyor)) {
            frontPos = mode == 1 ? this.f_58858_.m_121945_(facing).m_7494_() : this.f_58858_.m_121945_(facing).m_7495_();
        } else {
            return frontPos;
        }
        BlockState frontState = this.f_58857_.m_8055_(frontPos);
        return frontState.m_60734_() instanceof BlockConveyor && frontState.m_61143_((Property)BlockConveyor.FACING) == this.getBlockFacing() ? frontPos : null;
    }

    public boolean transferItem(ItemStack stack, boolean simulate) {
        return this.transferItem(stack, 0, simulate);
    }

    public boolean transferItem(ItemStack stack, int slot, boolean simulate) {
        if (((IItemHandler)this.inventory.orElse(null)).getStackInSlot(0).m_41619_() && !stack.m_41619_()) {
            if (!simulate) {
                this.inventory.ifPresent(e -> ((CustomItemStackHandler)((Object)e)).setStackInSlot(slot, stack));
            }
            this.getInThisTick = true;
            this.sync();
            return true;
        }
        return false;
    }

    public boolean dropFrontItem(Direction facing, ItemStack frontPositionItem, BlockPos frontPos) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.m_58900_().m_61143_(BlockConveyor.TYPE) == EnumConveyorType.INSERTER) {
            return false;
        }
        double multiplierX = BlockConveyor.getMotionX(facing);
        double multiplierZ = BlockConveyor.getMotionZ(facing);
        ItemEntity entityitem = new ItemEntity(this.f_58857_, (double)frontPos.m_123341_() + 0.5, (double)frontPos.m_123342_() + 0.5, (double)frontPos.m_123343_() + 0.5, frontPositionItem);
        entityitem.m_20334_(multiplierX * 0.2, 0.0, multiplierZ * 0.2);
        this.f_58857_.m_7967_((Entity)entityitem);
        this.inventory.ifPresent(e -> ((CustomItemStackHandler)((Object)e)).setStackInSlot(2, ItemStack.f_41583_));
        return true;
    }

    public void dropInventory() {
        BlockEntityConveyorBase.dropInventoryItems(this.f_58857_, this.f_58858_, (IItemHandler)this.inventory.orElse(null));
    }

    public void m_7651_() {
        this.dropInventory();
        super.m_7651_();
    }

    public Direction getBlockFacing() {
        BlockState state = this.m_58900_();
        if (state.m_60734_() instanceof BlockConveyor) {
            return (Direction)state.m_61143_((Property)BlockConveyor.FACING);
        }
        return Direction.NORTH;
    }

    public int getMode() {
        BlockState state = this.m_58900_();
        return state.m_60734_() instanceof BlockConveyor ? (Integer)state.m_61143_((Property)BlockConveyor.MODE) : 0;
    }

    public ItemStack getStackInSlot(int slot) {
        return ((IItemHandler)this.inventory.orElse(null)).getStackInSlot(slot).m_41777_();
    }

    public float getMinYOffset(int slot, int mode) {
        switch (slot) {
            default: {
                return mode == 0 ? 0.6f : 1.1f;
            }
            case 1: {
                if (mode == 1) {
                    return 0.78f;
                }
                if (mode == 2) {
                    return 1.43f;
                }
                return 0.61f;
            }
            case 0: 
        }
        if (mode == 1) {
            return 0.43f;
        }
        if (mode == 2) {
            return 1.78f;
        }
        return 0.6f;
    }

    public float getMaxYOffset(int mode) {
        if (mode == 0) {
            return 0.0f;
        }
        if (mode == 1) {
            return 0.46f;
        }
        return -0.46f;
    }

    private boolean getInvAbove(int count) {
        BlockEntity te;
        if (this.f_58857_ == null) {
            return false;
        }
        IItemHandler hopper = (IItemHandler)this.hopperInv.orElse(null);
        if (this.hopperInv.isPresent() && hopper.getStackInSlot(0).m_41619_() && (te = this.f_58857_.m_7702_(this.f_58858_.m_7494_())) != null) {
            if (te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).isPresent()) {
                IItemHandler itemHandler = (IItemHandler)te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).orElse(null);
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    IItemHandler itemHandler1;
                    ItemStack left;
                    ItemStack stack = itemHandler.extractItem(i, count, true);
                    if (!this.hopperInv.isPresent() || ItemStack.m_41656_((ItemStack)stack, (ItemStack)(left = (itemHandler1 = (IItemHandler)this.hopperInv.orElse(null)).insertItem(0, stack, false)))) continue;
                    int toExtract = stack.m_41613_() - left.m_41613_();
                    itemHandler.extractItem(i, toExtract, false);
                    this.sync();
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private void hopperToConveyor() {
        IItemHandler iItemHandler = (IItemHandler)this.hopperInv.orElse(null);
        IItemHandler iItemHandler1 = (IItemHandler)this.inventory.orElse(null);
        if (this.hopperInv.isPresent() && this.inventory.isPresent() && !iItemHandler.getStackInSlot(0).m_41619_()) {
            ItemStack stack = iItemHandler.getStackInSlot(0).m_41777_();
            ItemStack stack1 = iItemHandler1.insertItem(1, stack, false);
            iItemHandler.getStackInSlot(0).m_41774_(stack.m_41613_() - stack1.m_41613_());
        }
    }

    private void getEntityItemAbove() {
        BlockPos posAbove;
        List list;
        if (this.f_58857_ == null) {
            return;
        }
        IItemHandler itemHandler = (IItemHandler)this.hopperInv.orElse(null);
        if (this.hopperInv.isPresent() && itemHandler.getStackInSlot(0).m_41619_() && !(list = this.f_58857_.m_6443_(ItemEntity.class, new AABB((double)(posAbove = this.f_58858_.m_7494_()).m_123341_(), (double)posAbove.m_123342_(), (double)posAbove.m_123343_(), (double)posAbove.m_123341_() + 2.0, (double)posAbove.m_123342_() + 1.0, (double)posAbove.m_123343_() + 1.0), EntitySelector.f_20402_)).isEmpty() && list.get(0) != null) {
            ItemEntity entityItem = (ItemEntity)list.get(0);
            ItemStack stack = entityItem.m_32055_().m_41777_();
            ItemStack stack1 = itemHandler.insertItem(0, stack, false);
            if (stack1.m_41619_()) {
                entityItem.m_146870_();
            } else {
                entityItem.m_32045_(stack1);
            }
        }
    }

    private void insertItem() {
        IItemHandler itemHandler;
        Direction facing;
        BlockEntity te;
        if (this.f_58857_ == null) {
            return;
        }
        if (!((IItemHandler)this.inventory.orElse(null)).getStackInSlot(2).m_41619_() && (te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing = this.getBlockFacing()))) != null && (itemHandler = (IItemHandler)te.getCapability(ForgeCapabilities.ITEM_HANDLER, facing.m_122424_()).orElse(null)) != null) {
            for (int j = 0; j < itemHandler.getSlots(); ++j) {
                ItemStack left;
                ItemStack stack = ((IItemHandler)this.inventory.orElse(null)).extractItem(2, 64, true);
                if (stack.m_41619_() || !itemHandler.isItemValid(j, stack) || ItemStack.m_41656_((ItemStack)stack, (ItemStack)(left = itemHandler.insertItem(j, stack, false)))) continue;
                int toExtract = stack.m_41613_() - left.m_41613_();
                ((IItemHandler)this.inventory.orElse(null)).extractItem(2, toExtract, false);
            }
        }
    }

    public void dropContents() {
        if (this.f_58857_ == null) {
            return;
        }
        this.inventory.ifPresent(inv -> {
            for (int i = 0; i < inv.getSlots(); ++i) {
                Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)inv.getStackInSlot(i));
            }
        });
        this.hopperInv.ifPresent(inv -> {
            for (int i = 0; i < inv.getSlots(); ++i) {
                Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)inv.getStackInSlot(i));
            }
        });
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (facing == null) {
            return super.getCapability(capability, facing);
        }
        if (capability.equals((Object)ForgeCapabilities.ITEM_HANDLER) && facing != Direction.DOWN) {
            return this.hopperInv.cast();
        }
        if (facing == this.getBlockFacing().m_122424_() && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventory.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        this.inventory.ifPresent(h -> {
            CompoundTag tag = (CompoundTag)((INBTSerializable)h).serializeNBT();
            compoundTag.m_128365_("inv", (Tag)tag);
        });
        this.hopperInv.ifPresent(h -> {
            CompoundTag tag = (CompoundTag)((INBTSerializable)h).serializeNBT();
            compoundTag.m_128365_("inv2", (Tag)tag);
        });
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        CompoundTag invTag = compoundTag.m_128469_("inv");
        this.inventory.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)invTag));
        CompoundTag invTag2 = compoundTag.m_128469_("inv2");
        this.hopperInv.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)invTag2));
        super.m_142466_(compoundTag);
    }
}

