/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity.abstracts;

import java.util.List;
import net.cassiokf.industrialrenewal.block.abstracts.Block3x3x3Base;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.cassiokf.industrialrenewal.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class BlockEntity3x3x3MachineBase<TE extends BlockEntity3x3x3MachineBase<?>>
extends BlockEntitySyncable
implements ICapabilityProvider {
    protected boolean master;
    protected boolean breaking;
    protected TE masterTE;
    protected boolean masterChecked = false;
    protected boolean faceChecked = false;
    protected int faceIndex;

    public BlockEntity3x3x3MachineBase(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void onLoad() {
    }

    public TE getMaster() {
        if (this.f_58857_ == null) {
            return null;
        }
        if (this.masterTE == null || this.masterTE.m_58901_()) {
            List<BlockPos> list = Utils.getBlocksIn3x3x3Centered(this.f_58858_);
            for (BlockPos currentPos : list) {
                BlockEntity te = this.f_58857_.m_7702_(currentPos);
                if (!(te instanceof BlockEntity3x3x3MachineBase) || !((BlockEntity3x3x3MachineBase)te).isMaster() || !this.instanceOf(te)) continue;
                this.masterTE = (BlockEntity3x3x3MachineBase)te;
                return this.masterTE;
            }
            return null;
        }
        return this.masterTE;
    }

    public List<BlockPos> getListOfBlockPositions(BlockPos centerPosition) {
        return Utils.getBlocksIn3x3x3Centered(centerPosition);
    }

    public abstract boolean instanceOf(BlockEntity var1);

    public void breakMultiBlocks(BlockState state) {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.isMaster()) {
            if (this.getMaster() != null) {
                ((BlockEntity3x3x3MachineBase)((Object)this.getMaster())).breakMultiBlocks(state);
            }
            return;
        }
        if (!this.breaking) {
            this.breaking = true;
            this.onMasterBreak();
            List<BlockPos> list = this.getListOfBlockPositions(this.f_58858_);
            for (BlockPos currentPos : list) {
                Block block = this.f_58857_.m_8055_(currentPos).m_60734_();
                if (!(block instanceof Block3x3x3Base)) continue;
                this.f_58857_.m_7471_(currentPos, false);
            }
        }
    }

    public void onMasterBreak() {
    }

    public Direction getMasterFacing() {
        if (this.f_58857_ == null) {
            return Direction.NORTH;
        }
        if (this.faceChecked) {
            return Direction.m_122376_((int)this.faceIndex);
        }
        Direction facing = (Direction)this.f_58857_.m_8055_(((BlockEntity3x3x3MachineBase)((Object)this.getMaster())).f_58858_).m_61143_((Property)Block3x3x3Base.FACING);
        this.faceChecked = true;
        this.faceIndex = facing.m_122411_();
        return facing;
    }

    public boolean isMaster() {
        if (this.masterChecked) {
            return this.master;
        }
        BlockState state = this.m_58900_();
        if (!(state.m_60734_() instanceof Block3x3x3Base)) {
            return false;
        }
        this.master = (Boolean)state.m_61143_((Property)Block3x3x3Base.MASTER);
        this.masterChecked = true;
        return this.master;
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        compoundTag.m_128379_("master", this.isMaster());
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        this.master = compoundTag.m_128471_("master");
        super.m_142466_(compoundTag);
    }
}

