/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.block.BlockWindTurbinePillar;
import net.cassiokf.industrialrenewal.blockentity.BlockEntityWindTurbineHead;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntityMultiBlocksTube;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.obj.CapResult;
import net.cassiokf.industrialrenewal.util.PipeUtils;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.capability.CustomEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class BlockEntityWindTurbinePillar
extends BlockEntityMultiBlocksTube<BlockEntityWindTurbinePillar>
implements ICapabilityProvider {
    private static final Direction[] FACES_TO_CHECK = new Direction[]{Direction.UP, Direction.DOWN};
    private static final LazyOptional<IEnergyStorage> dummyEnergy = LazyOptional.of(BlockEntityWindTurbinePillar::createEnergyDummy);
    private int potentialEnergy;
    private final CustomEnergyStorage energyStorage = new CustomEnergyStorage(1024, 1024, 1024){

        @Override
        public void onEnergyChange() {
            BlockEntityWindTurbinePillar.this.m_6596_();
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            return BlockEntityWindTurbinePillar.this.onEnergyReceived(maxReceive, simulate);
        }
    };
    private int oldPotential = -1;
    private int averageEnergy;
    private final LazyOptional<IEnergyStorage> energyStorageHandler = LazyOptional.of(() -> this.energyStorage);
    private int oldEnergy;
    private float amount;
    private int tick;
    private BlockPos turbinePos;
    private boolean isBase;

    public BlockEntityWindTurbinePillar(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.TURBINE_PILLAR_TILE.get(), pos, state);
    }

    private static IEnergyStorage createEnergyDummy() {
        return new CustomEnergyStorage(0, 0, 0).noReceive().noExtraction();
    }

    public int onEnergyReceived(int maxReceive, boolean simulate) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_() || maxReceive <= 0) {
            return 0;
        }
        if (!this.isMaster()) {
            ((BlockEntityWindTurbinePillar)((Object)this.getMaster())).onEnergyReceived(maxReceive, simulate);
        }
        if (this.inUse) {
            return 0;
        }
        this.inUse = true;
        if (!simulate) {
            this.potentialEnergy = maxReceive;
        }
        CapResult result = PipeUtils.moveEnergy(this, maxReceive, this.energyStorage.getMaxEnergyStored(), simulate);
        if (!simulate) {
            this.outPut += result.getOutPut();
        }
        this.outPutCount = result.getValidReceivers();
        this.inUse = false;
        return result.getOutPut();
    }

    @Override
    public void beforeInitialize() {
        this.getIsBase();
        this.sync();
    }

    @Override
    public void doTick() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        if (this.isMaster() && this.isBase) {
            if (this.tick % 10 == 0) {
                this.tick = 0;
                this.averageEnergy = this.outPut / 10;
                this.outPut = 0;
                if (this.averageEnergy != this.oldEnergy || this.potentialEnergy != this.oldPotential) {
                    this.oldPotential = this.potentialEnergy;
                    this.oldEnergy = this.averageEnergy;
                    this.sync();
                }
            }
            ++this.tick;
        }
    }

    @Override
    public Direction[] getFacesToCheck() {
        return FACES_TO_CHECK;
    }

    @Override
    public boolean instanceOf(BlockEntity te) {
        return te instanceof BlockEntityWindTurbinePillar;
    }

    @Override
    public void checkForOutPuts(BlockPos bPos) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.isBase = this.getIsBase();
        if (this.isBase) {
            this.forceNewTurbinePos();
            for (Direction face : Direction.Plane.HORIZONTAL) {
                BlockPos currentPos = this.f_58858_.m_121945_(face);
                BlockState state = this.f_58857_.m_8055_(currentPos);
                BlockEntity te = this.f_58857_.m_7702_(currentPos);
                boolean hasMachine = !(state.m_60734_() instanceof BlockWindTurbinePillar) && te != null && te.getCapability(ForgeCapabilities.ENERGY, face.m_122424_()).isPresent();
                if (!hasMachine || !((IEnergyStorage)te.getCapability(ForgeCapabilities.ENERGY, face.m_122424_()).orElse(null)).canReceive()) continue;
                if (!this.isMasterInvalid()) {
                    ((BlockEntityWindTurbinePillar)((Object)this.getMaster())).addReceiver(te, face);
                    continue;
                }
                if (te == null || this.isMasterInvalid()) continue;
                ((BlockEntityWindTurbinePillar)((Object)this.getMaster())).removeReceiver(te);
            }
        }
        this.sync();
    }

    @Override
    public void onFirstLoad() {
        if (this.getIsBase() && this.getMaster() != this) {
            this.setMaster(this);
        }
    }

    private BlockPos getTurbinePos() {
        if (this.turbinePos != null) {
            return this.turbinePos;
        }
        return this.forceNewTurbinePos();
    }

    private BlockPos forceNewTurbinePos() {
        if (this.f_58857_ == null) {
            return this.turbinePos;
        }
        int n = 1;
        while (this.f_58857_.m_7702_(this.f_58858_.m_6630_(n)) instanceof BlockEntityWindTurbinePillar) {
            ++n;
        }
        this.turbinePos = this.f_58857_.m_7702_(this.f_58858_.m_6630_(n)) instanceof BlockEntityWindTurbineHead ? this.f_58858_.m_6630_(n) : null;
        return this.turbinePos;
    }

    public Direction getBlockFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockWindTurbinePillar.FACING);
    }

    public float getGenerationforGauge() {
        try {
            float currentAmount = Utils.normalizeClamped(((BlockEntityWindTurbinePillar)((Object)this.getMaster())).averageEnergy, 0.0f, 128.0f);
            this.amount = Utils.lerp(this.amount, currentAmount, 0.1f);
            return Math.min(this.amount, 1.0f) * 90.0f;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public float getPotentialValue() {
        try {
            float currentAmount = Utils.normalizeClamped(((BlockEntityWindTurbinePillar)((Object)this.getMaster())).potentialEnergy, 0.0f, 128.0f);
            return currentAmount * 90.0f;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public int getEnergyGenerated() {
        if (this.getMaster() == null) {
            return 0;
        }
        return ((BlockEntityWindTurbinePillar)((Object)this.getMaster())).outPut;
    }

    public String getText() {
        if (this.getMaster() == null || ((BlockEntityWindTurbinePillar)((Object)this.getMaster())).getTurbinePos() == null) {
            return "No Turbine";
        }
        return Utils.formatEnergyString(this.getEnergyGenerated());
    }

    public boolean isBase() {
        return this.isBase;
    }

    public boolean getIsBase() {
        if (this.f_58857_ == null) {
            return false;
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_.m_7495_());
        this.isBase = !(state.m_60734_() instanceof BlockWindTurbinePillar);
        return this.isBase;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (facing == null) {
            return super.getCapability(capability, facing);
        }
        if (capability == ForgeCapabilities.ENERGY && facing == Direction.UP) {
            return ((BlockEntityWindTurbinePillar)((Object)this.getMaster())).energyStorageHandler.cast();
        }
        if (capability == ForgeCapabilities.ENERGY && this.isBase()) {
            return dummyEnergy.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        if (this.f_58857_ == null) {
            return;
        }
        this.averageEnergy = compound.m_128451_("energy_average");
        this.potentialEnergy = compound.m_128451_("potential");
        super.m_142466_(compound);
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        compound.m_128405_("energy_average", this.averageEnergy);
        compound.m_128405_("potential", this.potentialEnergy);
        super.m_183515_(compound);
    }
}

