/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.util.capability.CustomEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public class BlockEntityTrash
extends BlockEntitySyncable {
    public static final FluidTank tank = new FluidTank(64000){

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return resource != null ? resource.getAmount() : 0;
        }
    };
    public static final ItemStackHandler inventory = new ItemStackHandler(10){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return ItemStack.f_41583_;
        }
    };
    public static final CustomEnergyStorage energyContainer = new CustomEnergyStorage(1000000, 1000000, 1000000){

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            return maxReceive;
        }
    };

    public BlockEntityTrash(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.TRASH_TILE.get(), pos, state);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        LazyOptional.of(() -> tank).invalidate();
        LazyOptional.of(() -> energyContainer).invalidate();
        LazyOptional.of(() -> inventory).invalidate();
    }

    public void m_7651_() {
        super.m_7651_();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> tank).cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return LazyOptional.of(() -> energyContainer).cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> inventory).cast();
        }
        return super.getCapability(cap, side);
    }
}

