/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import javax.annotation.Nonnull;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntity3x3x2MachineBase;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.capability.CustomItemStackHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityStorageChest
extends BlockEntity3x3x2MachineBase<BlockEntityStorageChest>
implements MenuProvider {
    public int maxPage = 4;
    public int slotsPerPage = 66;
    public String search = "";
    public boolean searchActive = true;
    public int maxNumSlots = this.slotsPerPage * this.maxPage;
    public final CustomItemStackHandler inventory = new CustomItemStackHandler(this.maxNumSlots){

        @Override
        protected void onContentsChanged(int slot) {
            BlockEntityStorageChest.this.sync();
        }
    };
    public LazyOptional<CustomItemStackHandler> inventoryHandler = LazyOptional.of(() -> this.inventory);

    public BlockEntityStorageChest(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.STORAGE_CHEST_TILE.get(), pos, state);
    }

    @Override
    public void onMasterBreak() {
        super.onMasterBreak();
        this.dropResources();
    }

    @Override
    public void dropResources() {
        Utils.dropInventoryItems(this.f_58857_, this.f_58858_, (ItemStackHandler)this.inventory);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        BlockEntityStorageChest masterTE = (BlockEntityStorageChest)this.getMaster();
        if (masterTE == null) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return masterTE.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean instanceOf(BlockEntity tileEntity) {
        return tileEntity instanceof BlockEntityStorageChest;
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        compoundTag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        this.inventory.deserializeNBT(compoundTag.m_128469_("inv"));
        super.m_142466_(compoundTag);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237113_((String)"Storage Rack");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return null;
    }
}

