/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntity3x3x3MachineBase;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.init.ModTags;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.capability.CustomEnergyStorage;
import net.cassiokf.industrialrenewal.util.capability.CustomFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class BlockEntitySteamTurbine
extends BlockEntity3x3x3MachineBase<BlockEntitySteamTurbine> {
    private static final int maxRotation = 16000;
    private static final int energyPerTick = 512;
    private static final int steamPerTick = 250;
    private final CustomEnergyStorage energyContainer = new CustomEnergyStorage(100000, 10240, 10240).setBlockEntity(this).noExtraction().noReceive();
    private final LazyOptional<IEnergyStorage> energyStorageHandler = LazyOptional.of(() -> this.energyContainer);
    private final CustomFluidTank waterTank = new CustomFluidTank(32000).setBlockEntity(this).noFill();
    private final FluidStack waterStack = new FluidStack((Fluid)Fluids.f_76193_, 1000);
    private final CustomFluidTank steamTank = new CustomFluidTank(500){

        public boolean isFluidValid(FluidStack stack) {
            return stack != null && stack.getFluid().m_76145_().m_205070_(ModTags.Fluids.STEAM_TAG);
        }
    }.setBlockEntity(this).noDrain();
    private int rotation;
    private int oldRotation;
    private float steamReceivedNorm = 0.0f;

    public BlockEntitySteamTurbine(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.STEAM_TURBINE_TILE.get(), pos, state);
    }

    public void tick() {
        if (this.isMaster() && !this.f_58857_.m_5776_()) {
            this.steamToRotation();
            this.generateEnergyBasedOnRotation();
            this.extractEnergy();
            this.extractWater();
            if (this.oldRotation != this.rotation) {
                this.oldRotation = this.rotation;
                this.sync();
            }
        }
    }

    public void steamToRotation() {
        int steamAmount = this.rotation > 15990 ? 250 : 250;
        FluidStack fluidStack = this.steamTank.drainInternal(steamAmount, IFluidHandler.FluidAction.EXECUTE);
        if (fluidStack == null) {
            return;
        }
        this.steamReceivedNorm = Utils.normalizeClamped(fluidStack.getAmount(), 0.0f, 250.0f);
        int torqueSum = (int)(this.steamReceivedNorm * 10.0f);
        this.waterStack.setAmount(Utils.roundtoInteger((float)fluidStack.getAmount() / 5.0f * 0.98f));
        this.waterTank.fillInternal(this.waterStack, IFluidHandler.FluidAction.EXECUTE);
        this.rotation += torqueSum;
    }

    private void generateEnergyBasedOnRotation() {
        if (this.rotation >= 6000) {
            int energy = this.getEnergyProduction();
            this.energyContainer.addEnergy(energy, false);
            this.load(energy);
        }
        this.rotationDecay();
        this.rotation = Mth.m_14045_((int)this.rotation, (int)0, (int)16000);
    }

    private void extractEnergy() {
        IEnergyStorage upTank;
        Direction facing = this.getMasterFacing();
        BlockEntity eTE = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing.m_122424_()).m_7495_().m_5484_(facing.m_122428_(), 2));
        if (eTE != null && this.energyContainer.getEnergyStored() > 0 && (upTank = (IEnergyStorage)eTE.getCapability(ForgeCapabilities.ENERGY, facing.m_122427_()).orElse(null)) != null) {
            this.energyContainer.subtractEnergy(upTank.receiveEnergy(this.energyContainer.subtractEnergy(10240, true), false), false);
        }
    }

    private void extractWater() {
        IFluidHandler wTank;
        Direction facing = this.getMasterFacing();
        BlockEntity wTE = this.f_58857_.m_7702_(this.f_58858_.m_5484_(facing, 2).m_7495_());
        if (wTE != null && this.waterTank.getFluidAmount() > 0 && (wTank = (IFluidHandler)wTE.getCapability(ForgeCapabilities.FLUID_HANDLER, facing.m_122424_()).orElse(null)) != null) {
            this.waterTank.drain(wTank.fill(this.waterTank.drain(2000, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public void onMasterBreak() {
    }

    @Override
    public boolean instanceOf(BlockEntity tileEntity) {
        return tileEntity instanceof BlockEntitySteamTurbine;
    }

    private int getEnergyProduction() {
        float factor;
        int energy = Math.round(512.0f * this.getRotation());
        int remainingEnergy = this.energyContainer.getMaxEnergyStored() - this.energyContainer.getEnergyStored();
        if (remainingEnergy < (energy = Utils.roundtoInteger((float)energy * (factor = this.waterTank.getFluidAmount() == 0 ? 1.0f : Math.max(0.5f, Math.min(1.0f, (float)this.waterTank.getCapacity() / (float)this.waterTank.getFluidAmount() - 0.5f)))))) {
            energy = remainingEnergy;
        }
        energy = Mth.m_14045_((int)energy, (int)0, (int)512);
        return energy;
    }

    private void load(int load) {
        float loadFactor = Utils.normalizeClamped(load, 0.0f, 512.0f);
        int torque = loadFactor > 0.0f ? (int)(1.0f + loadFactor * 6.0f) : 0;
        this.rotation -= torque;
    }

    private void rotationDecay() {
        int decay = this.rotation < 6000 ? 3 : (int)(1.0f + this.getRotation() * 2.0f);
        this.rotation -= decay;
    }

    public String getWaterText() {
        return "Water";
    }

    public String getSteamText() {
        return "Steam";
    }

    public String getGenerationText() {
        int energy = this.rotation >= 6000 && this.energyContainer.getEnergyStored() < this.energyContainer.getMaxEnergyStored() ? this.getEnergyProduction() : 0;
        return Utils.formatEnergyString(energy) + "/t";
    }

    public String getEnergyText() {
        int energy = this.energyContainer.getEnergyStored();
        return Utils.formatEnergyString(energy);
    }

    public String getRotationText() {
        return this.rotation / 10 + " rpm";
    }

    public float getEnergyFill() {
        return Utils.normalizeClamped(this.energyContainer.getEnergyStored(), 0.0f, this.energyContainer.getMaxEnergyStored());
    }

    private float getRotation() {
        return Utils.normalizeClamped(this.rotation, 0.0f, 16000.0f);
    }

    public float getGenerationFill() {
        float currentAmount = this.rotation >= 6000 && this.energyContainer.getEnergyStored() < this.energyContainer.getMaxEnergyStored() ? this.getEnergyProduction() : 0;
        return Utils.normalizeClamped(currentAmount, 0.0f, 512.0f) * 90.0f;
    }

    public float getWaterFill() {
        return Utils.normalizeClamped(this.waterTank.getFluidAmount(), 0.0f, this.waterTank.getCapacity()) * 180.0f;
    }

    public float getSteamFill() {
        return this.steamReceivedNorm * 180.0f;
    }

    public float getRotationFill() {
        return this.getRotation() * 140.0f;
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        CompoundTag waterTag = new CompoundTag();
        this.waterTank.writeToNBT(waterTag);
        compoundTag.m_128365_("water", (Tag)waterTag);
        compoundTag.m_128405_("energy", this.energyContainer.getEnergyStored());
        compoundTag.m_128405_("heat", this.rotation);
        compoundTag.m_128350_("steamOnTick", this.steamReceivedNorm);
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        CompoundTag waterTag = compound.m_128469_("water");
        this.waterTank.readFromNBT(waterTag);
        this.energyContainer.setEnergy(compound.m_128451_("energy"));
        this.rotation = compound.m_128451_("heat");
        this.steamReceivedNorm = compound.m_128457_("steamOnTick");
        super.m_142466_(compound);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        BlockEntitySteamTurbine masterTE = (BlockEntitySteamTurbine)((Object)this.getMaster());
        if (masterTE == null) {
            return super.getCapability(capability, facing);
        }
        Direction face = this.getMasterFacing();
        BlockPos masterPos = masterTE.m_58899_();
        if (facing == null) {
            return super.getCapability(capability, facing);
        }
        if (facing == Direction.UP && this.f_58858_.equals((Object)masterPos.m_7494_()) && capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> masterTE.steamTank).cast();
        }
        if (facing == face && this.f_58858_.equals((Object)masterPos.m_7495_().m_121945_(face)) && capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> masterTE.waterTank).cast();
        }
        if (facing == face.m_122428_() && this.f_58858_.equals((Object)masterPos.m_7495_().m_121945_(face.m_122424_()).m_121945_(face.m_122428_())) && capability == ForgeCapabilities.ENERGY) {
            return masterTE.energyStorageHandler.cast();
        }
        return super.getCapability(capability, facing);
    }
}

