/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.block.BlockSteamBoiler;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntity3x3x3MachineBase;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.init.ModItems;
import net.cassiokf.industrialrenewal.obj.SteamBoiler;
import net.cassiokf.industrialrenewal.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class BlockEntitySteamBoiler
extends BlockEntity3x3x3MachineBase<BlockEntitySteamBoiler> {
    private static final int solidPerTick = 2;
    private static final int fluidPerTick = 1;
    public final SteamBoiler boiler = new SteamBoiler(this, SteamBoiler.BoilerType.Solid, 2);
    private int type;

    public BlockEntitySteamBoiler(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.STEAM_BOILER_TILE.get(), pos, state);
    }

    public void tick() {
        if (this.isMaster() && !this.f_58857_.m_5776_()) {
            if (this.type > 0) {
                this.boiler.onTick();
            } else {
                this.boiler.outPutSteam();
                this.boiler.coolDown();
            }
        }
    }

    @Override
    public boolean instanceOf(BlockEntity tileEntity) {
        return tileEntity instanceof BlockEntitySteamBoiler;
    }

    public int getIntType() {
        if (!this.isMaster()) {
            return ((BlockEntitySteamBoiler)((Object)this.getMaster())).type;
        }
        return this.type;
    }

    public void setType(int type) {
        if (!this.isMaster()) {
            ((BlockEntitySteamBoiler)((Object)this.getMaster())).setType(type);
            return;
        }
        this.boiler.dropItemsOnGround(this.f_58858_);
        this.type = type;
        if (type > 0) {
            this.boiler.setType(type == 1 ? SteamBoiler.BoilerType.Solid : SteamBoiler.BoilerType.Liquid, type == 1 ? 2 : 1);
        } else {
            this.boiler.resetFuelTime();
        }
        BlockState state = (BlockState)this.m_58900_().m_61124_((Property)BlockSteamBoiler.TYPE, (Comparable)Integer.valueOf(type));
        this.f_58857_.m_46597_(this.f_58858_, state);
        this.sync();
    }

    public String getFuelText() {
        if (this.getIntType() == 0) {
            return "No Firebox";
        }
        return this.boiler.getFuelText();
    }

    @Override
    public void onMasterBreak() {
        this.boiler.dropItemsOnGround(this.f_58858_);
        Utils.spawnItemStack(this.f_58857_, this.f_58858_, this.getFireBoxStack());
    }

    public ItemStack getFireBoxStack() {
        switch (this.type) {
            default: {
                return ItemStack.f_41583_;
            }
            case 1: {
                return new ItemStack((ItemLike)ModItems.FIREBOX_SOLID.get());
            }
            case 2: 
        }
        return new ItemStack((ItemLike)ModItems.FIREBOX_FLUID.get());
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        this.boiler.saveBoiler(compoundTag);
        compoundTag.m_128405_("type", this.type);
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        this.boiler.loadBoiler(compoundTag);
        this.type = compoundTag.m_128451_("type");
        super.m_142466_(compoundTag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        BlockEntitySteamBoiler masterTE = (BlockEntitySteamBoiler)((Object)this.getMaster());
        if (masterTE == null) {
            return super.getCapability(capability, facing);
        }
        Direction face = masterTE.getMasterFacing();
        SteamBoiler b = masterTE.boiler;
        if (facing == null) {
            return super.getCapability(capability, facing);
        }
        if (facing == Direction.UP && this.f_58858_.equals((Object)masterTE.m_58899_().m_7494_()) && capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(b::getSteamTank).cast();
        }
        if (facing == face && this.f_58858_.equals((Object)masterTE.m_58899_().m_7495_().m_121945_(face)) && capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(b::getWaterTank).cast();
        }
        if (masterTE.getIntType() == 1 && facing == face.m_122428_() && this.f_58858_.equals((Object)masterTE.m_58899_().m_7495_().m_121945_(face.m_122424_()).m_121945_(face.m_122428_())) && capability == ForgeCapabilities.ITEM_HANDLER) {
            return b.getSolidFuelInvHandler().cast();
        }
        if (masterTE.getIntType() == 2 && facing == face.m_122428_() && this.f_58858_.equals((Object)masterTE.m_58899_().m_7495_().m_121945_(face.m_122424_()).m_121945_(face.m_122428_())) && capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(b::getFuelTank).cast();
        }
        return super.getCapability(capability, facing);
    }

    public String getSteamText() {
        return "Steam";
    }

    public SteamBoiler getBoiler() {
        return this.boiler;
    }

    public ItemStack getDrop() {
        return switch (this.type) {
            case 1 -> new ItemStack((ItemLike)ModItems.FIREBOX_SOLID.get(), 1);
            case 2 -> new ItemStack((ItemLike)ModItems.FIREBOX_FLUID.get(), 1);
            default -> null;
        };
    }
}

