/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntitySolarPanel
extends BlockEntity {
    private final IEnergyStorage energyStorage = new EnergyStorage(0);
    private final boolean DECORATIVE = false;
    private int tick = 0;
    private int energyCanGenerate;
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);

    public BlockEntitySolarPanel(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.SOLAR_PANEL.get(), pos, state);
    }

    public static int getGeneration(Level world, BlockPos pos) {
        int i = world.m_45517_(LightLayer.SKY, pos);
        float f = world.m_46490_(1.0f);
        if (i > 0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            i = (int)Math.round((double)i * Math.cos(f));
        }
        i = Mth.m_14045_((int)i, (int)0, (int)15);
        float normalize = (float)i / 15.0f;
        if (world.m_46471_()) {
            normalize /= 2.0f;
        }
        return Math.round(normalize * 15.0f);
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.tick >= 20) {
            this.tick = 0;
            this.getEnergyFromSun();
        }
        ++this.tick;
        this.moveEnergyOut(this.energyCanGenerate, false);
    }

    private void moveEnergyOut(int energy, boolean simulate) {
        if (this.f_58857_ == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
            if (te == null) continue;
            te.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(iEnergyStorage -> {
                if (iEnergyStorage.canReceive() && iEnergyStorage.getEnergyStored() < iEnergyStorage.getMaxEnergyStored()) {
                    iEnergyStorage.receiveEnergy(energy, simulate);
                }
            });
        }
    }

    public void getEnergyFromSun() {
        if (this.f_58857_ == null) {
            return;
        }
        this.energyCanGenerate = BlockEntitySolarPanel.getGeneration(this.f_58857_, this.f_58858_);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyHandler.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side == null) {
            return super.getCapability(cap, side);
        }
        return cap == ForgeCapabilities.ENERGY && side == Direction.DOWN ? this.energyHandler.cast() : super.getCapability(cap, side);
    }
}

