/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntity3x3x3MachineBase;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.init.ModItems;
import net.cassiokf.industrialrenewal.item.ItemDrill;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.capability.CustomEnergyStorage;
import net.cassiokf.industrialrenewal.util.capability.CustomFluidTank;
import net.cassiokf.industrialrenewal.util.capability.CustomItemStackHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.util.Strings;

public class BlockEntityMiner
extends BlockEntity3x3x3MachineBase<BlockEntityMiner> {
    private static final int fluidTankCapacity = 32000;
    private static final int fluidEnergyCapacity = 100000;
    private static final int fluidEnergyReceive = 10240;
    private static final int CHUNK_RADIUS = 3;
    private static final int maxHeat = 18000;
    private static final int waterPerTick = 10;
    private final LazyOptional<IItemHandler> drillInv = LazyOptional.of(this::createHandler);
    private static final int energyPerTick = 768;
    private static final int deepEnergyPerTick = 1024;
    private static final int cooldown = 120;
    private static final int damageAmount = 1;
    private final CustomFluidTank waterTank = new CustomFluidTank(32000){

        public boolean isFluidValid(FluidStack stack) {
            return stack != null && stack.getFluid().equals(Fluids.f_76193_);
        }
    }.setBlockEntity(this);
    private final LazyOptional<IItemHandler> internalInv = LazyOptional.of(this::createInternalHandler);
    private final CustomEnergyStorage energyStorage = new CustomEnergyStorage(100000, 10240, 768).setBlockEntity(this).setBlockEntity(this);
    private final LazyOptional<CustomEnergyStorage> energyStorageHandler = LazyOptional.of(() -> this.energyStorage);
    private final Stack<OreMining> ores = new Stack();
    private final NonNullList<ItemStack> tempStack = NonNullList.m_122779_();
    private final ItemStack vein = ItemStack.f_41583_;
    public boolean firstLoad = false;
    private int drillHeat;
    private int oldDrillHeat;
    private int currentTick = 0;
    private boolean depleted = false;
    private boolean isDeepMine = false;
    private boolean running;
    private boolean oldRunning;
    private int size;
    private float rotation;
    private float ySlide = 0.0f;
    private boolean revert;
    private int particleTick;

    public BlockEntityMiner(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.MINER_TILE.get(), pos, state);
    }

    private CustomItemStackHandler createHandler() {
        return new CustomItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.m_41720_() instanceof ItemDrill;
            }

            @Override
            protected void onContentsChanged(int slot) {
                BlockEntityMiner.this.checkDeepMine();
            }
        };
    }

    private CustomItemStackHandler createInternalHandler() {
        return new CustomItemStackHandler(1).setBlockEntity(this);
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.m_58898_() && this.isMaster()) {
            if (!this.f_58857_.f_46443_) {
                this.outputOrSpawn();
                boolean canCheck = this.canCheckOre();
                if (canCheck && this.getOreSize() == 0) {
                    this.getOres();
                }
                if (canCheck && this.canRun()) {
                    if (this.getOreSize() > 0) {
                        this.running = true;
                    }
                    if (this.running) {
                        this.consumeEnergy();
                        if (this.drillHeat < (this.waterTank.getFluidAmount() >= 10 ? 9400 : 17300)) {
                            this.drillHeat += 20;
                        }
                        this.mineOre();
                        this.size = this.getOreSize();
                    } else {
                        this.size = 0;
                        this.drillHeat -= 30;
                        this.currentTick = 0;
                    }
                } else {
                    this.size = this.getOreSize();
                    this.drillHeat -= 30;
                    this.running = false;
                    this.currentTick = 0;
                }
                this.drillHeat = Mth.m_14045_((int)this.drillHeat, (int)3200, (int)18000);
                if (this.running != this.oldRunning || this.drillHeat != this.oldDrillHeat) {
                    this.oldRunning = this.running;
                    this.oldDrillHeat = this.drillHeat;
                    this.sync();
                }
            }
            this.doAnimation();
        }
    }

    private int getOreSize() {
        return this.isDeepMine() ? this.vein.m_41613_() : this.ores.size();
    }

    private boolean isDeepMine() {
        return this.isDeepMine;
    }

    public void checkDeepMine() {
        this.isDeepMine = ((IItemHandler)this.drillInv.orElse(null)).getStackInSlot(0).m_41720_() == ModItems.DRILL_DEEP.get();
        this.depleted = false;
        this.sync();
    }

    private int getFortune() {
        IItemHandler iItemHandler = (IItemHandler)this.drillInv.orElse(null);
        if (iItemHandler == null) {
            return 0;
        }
        return iItemHandler.getStackInSlot(0).m_41720_().equals(ModItems.DRILL_DIAMOND.get()) ? 2 : 1;
    }

    private int getMaxCooldown() {
        int t = this.waterTank.getFluidAmount() >= 10 ? 120 : 240;
        return this.isDeepMine() ? t * 2 : t;
    }

    private void mineOre() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.currentTick >= this.getMaxCooldown()) {
            ItemStack s;
            this.currentTick = 0;
            if (this.isDeepMine()) {
                s = this.vein.m_41777_();
                s.m_41764_(1);
                this.tempStack.add((Object)s);
                this.vein.m_41774_(1);
            } else {
                if (this.ores.isEmpty()) {
                    return;
                }
                OreMining ore = this.ores.pop();
                if (this.f_58857_.m_8055_(ore.pos).m_60734_() != ore.state.m_60734_()) {
                    return;
                }
                this.currentTick = 0;
                Block block = ore.state.m_60734_();
                List drops = Block.m_49874_((BlockState)ore.state, (ServerLevel)this.f_58857_.m_7654_().m_129880_(this.f_58857_.m_46472_()), (BlockPos)ore.pos, (BlockEntity)this, null, (ItemStack)this.getDrill());
                this.tempStack.addAll((Collection)drops);
                this.f_58857_.m_7731_(ore.pos, Blocks.f_50652_.m_49966_(), 3);
            }
            s = (ItemStack)this.tempStack.get(0);
            if (!s.m_41619_()) {
                this.internalInv.ifPresent(inv -> inv.insertItem(0, s, false));
                this.tempStack.remove((Object)s);
            }
            this.damageDrill();
        } else {
            ++this.currentTick;
        }
    }

    private void damageDrill() {
        int damage = this.drillHeat <= 1 ? 1 : 4;
        IItemHandler itemHandler = (IItemHandler)this.drillInv.orElse(null);
        if (itemHandler == null) {
            return;
        }
        ItemStack stack = itemHandler.getStackInSlot(0);
        if (stack.m_220157_(damage, this.f_58857_.f_46441_, null)) {
            stack.m_41774_(stack.m_41613_());
        }
    }

    private void consumeEnergy() {
        this.energyStorageHandler.ifPresent(iEnergyStorage -> iEnergyStorage.extractEnergy(this.isDeepMine() ? 1024 : 768, false));
        this.waterTank.drain(10, IFluidHandler.FluidAction.EXECUTE);
    }

    private boolean canCheckOre() {
        return !this.depleted && ((CustomEnergyStorage)((Object)this.energyStorageHandler.orElse(null))).getEnergyStored() >= (this.isDeepMine() ? 1024 : 768) && !((IItemHandler)this.drillInv.orElse(null)).getStackInSlot(0).m_41619_();
    }

    private void outputOrSpawn() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.tempStack.isEmpty()) {
            ItemStack s = (ItemStack)this.tempStack.get(0);
            if (!s.m_41619_()) {
                this.internalInv.ifPresent(inv -> inv.insertItem(0, s, false));
                this.tempStack.remove((Object)s);
            }
            return;
        }
        IItemHandler itemHandler = (IItemHandler)this.internalInv.orElse(null);
        if (this.internalInv.isPresent() && itemHandler.getStackInSlot(0).m_41619_()) {
            return;
        }
        BlockPos outPos = this.f_58858_.m_5484_(this.getMasterFacing(), 2).m_7495_();
        BlockEntity te = this.f_58857_.m_7702_(outPos);
        if (te != null && te.getCapability(ForgeCapabilities.ITEM_HANDLER, this.getMasterFacing().m_122424_()).isPresent()) {
            IItemHandler handler = (IItemHandler)te.getCapability(ForgeCapabilities.ITEM_HANDLER, this.getMasterFacing().m_122424_()).orElse(null);
            Utils.moveItemToInventory((IItemHandler)this.internalInv.orElse(null), 0, handler);
        } else {
            BlockState state = this.f_58857_.m_8055_(outPos);
            if (state.m_60795_()) {
                Utils.spawnItemStack(this.f_58857_, outPos, ((IItemHandler)this.internalInv.orElse(null)).getStackInSlot(0));
            }
        }
    }

    private void getOres() {
        int maxDepth;
        if (this.f_58857_ == null) {
            return;
        }
        this.tempStack.clear();
        int n = maxDepth = this.isDeepMine ? 1 : -63;
        if (this.isDeepMine()) {
            this.depleted = this.size == 0;
            this.sync();
            return;
        }
        ChunkAccess chunk = this.f_58857_.m_46865_(this.f_58858_);
        for (int q = -2; q < 3; ++q) {
            for (int r = -2; r < 3; ++r) {
                int a = (chunk.m_7697_().f_45578_ + q) * 16;
                int b = (chunk.m_7697_().f_45579_ + r) * 16;
                for (double y = (double)maxDepth; y <= (double)(this.f_58858_.m_123342_() - 2); y += 1.0) {
                    for (double x = 0.0; x <= 15.0; x += 1.0) {
                        for (double z = 0.0; z <= 15.0; z += 1.0) {
                            BlockPos actualPosition = new BlockPos((int)((double)a + x), (int)y, (int)((double)b + z));
                            BlockState state = this.f_58857_.m_8055_(actualPosition);
                            if (!state.m_204336_(Tags.Blocks.ORES)) continue;
                            this.ores.add(new OreMining(state, actualPosition));
                        }
                    }
                }
            }
        }
        this.size = this.ores.size();
        this.depleted = this.size == 0;
        this.sync();
    }

    private void doAnimation() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            if (this.running) {
                if (this.waterTank.getFluidAmount() > 0 && this.particleTick >= 10) {
                    this.particleTick = 0;
                    this.spawnFluidParticle((float)this.f_58858_.m_123341_() + 0.5f, (float)this.f_58858_.m_123342_() - 1.0f, (float)this.f_58858_.m_123343_() + 0.5f, Blocks.f_50069_);
                    this.spawnFluidParticle((float)this.f_58858_.m_123341_() + 0.5f, (float)this.f_58858_.m_123342_() - 1.0f, (float)this.f_58858_.m_123343_() + 0.5f, this.waterTank.getFluid().getFluid().m_76145_().m_76188_().m_60734_());
                }
                ++this.particleTick;
            }
        } else if (this.running) {
            this.rotation += 20.0f;
            if (this.rotation >= 360.0f) {
                this.rotation = 0.0f;
            }
            this.ySlide = Utils.lerp(this.ySlide, this.revert ? 0.0f : -1.0f, 0.01f);
            if ((double)this.ySlide >= -0.01 || (double)this.ySlide <= -0.9) {
                this.revert = !this.revert;
            }
        } else {
            this.rotation = 0.0f;
            this.ySlide = Utils.lerp(this.ySlide, -1.0f, 0.05f);
        }
    }

    @Override
    public boolean instanceOf(BlockEntity tileEntity) {
        return tileEntity instanceof BlockEntityMiner;
    }

    private void spawnFluidParticle(double x, double y, double z, Block block) {
        float f = Mth.m_14167_((float)1.0f);
        double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
        int i = (int)(150.0 * d0);
    }

    private boolean canRun() {
        if (this.f_58857_ == null) {
            return false;
        }
        Direction facing = this.getMasterFacing();
        BlockPos posPort = this.f_58858_.m_121945_(facing.m_122428_()).m_121945_(facing.m_122424_()).m_7495_();
        return !this.depleted && this.f_58857_.m_276987_(posPort, facing.m_122424_()) && ((CustomEnergyStorage)((Object)this.energyStorageHandler.orElse(null))).getEnergyStored() >= 768 && !((IItemHandler)this.drillInv.orElse(null)).getStackInSlot(0).m_41619_();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void dropAllItems() {
        Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)((IItemHandler)this.drillInv.orElse(null)).getStackInSlot(0));
    }

    public String getWaterText(int line) {
        if (line == 1) {
            return "Coolant: ";
        }
        return Blocks.f_49990_.m_49954_().getString();
    }

    public String getEnergyText(int line) {
        if (line == 1) {
            return "Energy: ";
        }
        IEnergyStorage iEnergyStorage = (IEnergyStorage)this.energyStorageHandler.orElse(null);
        if (iEnergyStorage != null) {
            return iEnergyStorage.getEnergyStored() + " FE";
        }
        return "NULL FE";
    }

    public String getHeatText() {
        String name = "Drill Heat: ";
        return name + (int)Utils.getConvertedTemperature((float)this.drillHeat / 100.0f) + Utils.getTemperatureUnit();
    }

    public float getWaterFill() {
        float currentAmount = (float)this.waterTank.getFluidAmount() / 1000.0f;
        float totalCapacity = (float)this.waterTank.getCapacity() / 1000.0f;
        return (currentAmount /= totalCapacity) * 180.0f;
    }

    public float getEnergyFill() {
        IEnergyStorage iEnergyStorage = (IEnergyStorage)this.energyStorageHandler.orElse(null);
        if (iEnergyStorage == null) {
            return 0.0f;
        }
        float currentAmount = (float)iEnergyStorage.getEnergyStored() / 1000.0f;
        float totalCapacity = (float)iEnergyStorage.getMaxEnergyStored() / 1000.0f;
        return currentAmount /= totalCapacity;
    }

    public float getHeatFill() {
        float currentAmount = this.drillHeat;
        float totalCapacity = 18000.0f;
        return (currentAmount /= totalCapacity) * 180.0f;
    }

    public String[] getScreenTexts() {
        if (this.energyStorage.getEnergyStored() <= 0) {
            return Strings.EMPTY_ARRAY;
        }
        ArrayList<Object> texts = new ArrayList<Object>();
        texts.add("Mining Drill Status: " + (String)(this.running ? "Running" : String.valueOf(ChatFormatting.RED) + " Stopped"));
        texts.add("Mining Drill Mode: " + String.valueOf(ChatFormatting.BLUE) + (this.isDeepMine ? "Deep Mine" : "Surface Mine"));
        texts.add("Vein Size: " + String.valueOf(this.depleted ? "Depleted" : Integer.valueOf(this.size)));
        texts.add("Consumption: " + (this.isDeepMine() ? 1024 : 768) + " FE/t");
        texts.add(this.getHeatText());
        int maxD = this.getDrill().m_41776_();
        texts.add("Drill condition: " + (maxD - this.getDrill().m_41773_()) + "/" + maxD);
        String[] itemsArray = new String[texts.size()];
        itemsArray = texts.toArray(itemsArray);
        return itemsArray;
    }

    public boolean hasDrill() {
        IItemHandler iItemHandler = (IItemHandler)this.drillInv.orElse(null);
        return iItemHandler != null && !iItemHandler.getStackInSlot(0).m_41619_();
    }

    public ItemStack getDrill() {
        IItemHandler iItemHandler = (IItemHandler)this.drillInv.orElse(null);
        if (iItemHandler != null) {
            return ((IItemHandler)this.drillInv.orElse(null)).getStackInSlot(0);
        }
        return null;
    }

    public float getRotation() {
        return -this.rotation;
    }

    public float getSlide() {
        return this.ySlide;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        BlockEntityMiner masterTE = (BlockEntityMiner)((Object)this.getMaster());
        if (masterTE == null) {
            return super.getCapability(capability, facing);
        }
        Direction face = masterTE.getMasterFacing();
        if (facing == null) {
            return super.getCapability(capability, facing);
        }
        if (facing == face && this.f_58858_.equals((Object)masterTE.m_58899_().m_7495_().m_121945_(face).m_121945_(face.m_122427_())) && capability == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> masterTE.waterTank).cast();
        }
        if (facing == Direction.UP && this.f_58858_.equals((Object)masterTE.m_58899_().m_121945_(face.m_122424_()).m_7494_()) && capability == ForgeCapabilities.ENERGY) {
            return masterTE.energyStorageHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public IItemHandler getDrillHandler() {
        if (this.getMaster() != null && ((BlockEntityMiner)((Object)this.getMaster())).drillInv.isPresent()) {
            return (IItemHandler)((BlockEntityMiner)((Object)this.getMaster())).drillInv.orElse(null);
        }
        return null;
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        CompoundTag waterTag = new CompoundTag();
        this.waterTank.writeToNBT(waterTag);
        compoundTag.m_128365_("water", (Tag)waterTag);
        this.drillInv.ifPresent(h -> {
            CompoundTag tag = (CompoundTag)((INBTSerializable)h).serializeNBT();
            compoundTag.m_128365_("inv", (Tag)tag);
        });
        compoundTag.m_128405_("energy", this.energyStorage.getEnergyStored());
        compoundTag.m_128405_("heat", this.drillHeat);
        compoundTag.m_128405_("size", this.size);
        compoundTag.m_128379_("running", this.running);
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        this.waterTank.readFromNBT(compoundTag.m_128469_("water"));
        this.drillInv.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((Tag)compoundTag.m_128469_("inv")));
        this.energyStorage.setEnergy(compoundTag.m_128451_("energy"));
        this.drillHeat = compoundTag.m_128451_("heat");
        this.size = compoundTag.m_128451_("size");
        this.running = compoundTag.m_128471_("running");
        super.m_142466_(compoundTag);
    }

    public class OreMining {
        public final BlockState state;
        public final BlockPos pos;

        OreMining(BlockState state, BlockPos pos) {
            this.state = state;
            this.pos = pos;
        }
    }
}

