/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntityTowerBase;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.init.ModItems;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.capability.CustomEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class BlockEntityIndustrialBatteryBank
extends BlockEntityTowerBase<BlockEntityIndustrialBatteryBank> {
    public static final int CAPACITY_PER_BATTERY = 6480000;
    private static final int maxTransfer = 10240;
    private static final int maxBatteries = 24;
    private final CustomEnergyStorage customDummyStorage = new CustomEnergyStorage(0, 0, 0);
    private final LazyOptional<IEnergyStorage> dummyStorage = LazyOptional.of(() -> this.customDummyStorage);
    private final CustomEnergyStorage customEnergyStorage = new CustomEnergyStorage(0, 10240, 10240){

        @Override
        public void onEnergyChange() {
            BlockEntityIndustrialBatteryBank.this.sync();
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (maxReceive <= 0) {
                return 0;
            }
            return ((BlockEntityIndustrialBatteryBank)((Object)BlockEntityIndustrialBatteryBank.this.getBase())).onEnergyIn(maxReceive, simulate);
        }

        @Override
        public boolean canExtract() {
            return false;
        }
    };
    public int input;
    private final LazyOptional<IEnergyStorage> energyStorage = LazyOptional.of(() -> this.customEnergyStorage);
    public boolean firstLoad = false;
    private int avrIn;
    private int oldIn;
    private int outPut;
    private int avrOut;
    private int oldOutPut;
    private int batteries = 0;
    private int tick;

    public BlockEntityIndustrialBatteryBank(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.INDUSTRIAL_BATTERY_TILE.get(), pos, state);
    }

    @Override
    public boolean instanceOf(BlockEntity tileEntity) {
        return tileEntity instanceof BlockEntityIndustrialBatteryBank;
    }

    public int onEnergyIn(int received, boolean simulate) {
        int in;
        if (this.f_58857_ == null) {
            return 0;
        }
        received = Math.min(received, 10240);
        if (this.batteries > 0) {
            in = this.customEnergyStorage.addEnergy(received, simulate);
        } else {
            in = this.outPutEnergy(null, received, simulate);
            if (!simulate && !this.f_58857_.f_46443_) {
                this.outPut += in;
            }
        }
        if (!simulate && !this.f_58857_.f_46443_) {
            this.input += in;
        }
        return in;
    }

    private int outPutEnergy(CustomEnergyStorage container, int maxReceive, boolean simulate) {
        IEnergyStorage energyStorage;
        if (this.f_58857_ == null) {
            return 0;
        }
        BlockPos masterPos = ((BlockEntityIndustrialBatteryBank)this.masterTE).m_58899_();
        Direction face = this.getMasterFacing();
        BlockPos outPos = masterPos.m_121945_(face.m_122427_()).m_6630_(2 + (this.tower != null ? this.tower.size() - 1 : 0) * 3);
        BlockEntity te = this.f_58857_.m_7702_(outPos);
        int out = 0;
        if (te != null && (energyStorage = (IEnergyStorage)te.getCapability(ForgeCapabilities.ENERGY, Direction.DOWN).orElse(null)) != null) {
            out = container == null ? energyStorage.receiveEnergy(maxReceive, simulate) : container.subtractEnergy(energyStorage.receiveEnergy(container.subtractEnergy(maxReceive, true), simulate), simulate);
        }
        return out;
    }

    public boolean placeBattery(Player player, ItemStack batteryStack) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (!this.f_58857_.f_46443_) {
            if (this.batteries >= 24) {
                return false;
            }
            ++this.batteries;
            if (!player.m_7500_()) {
                batteryStack.m_41774_(1);
            }
            this.customEnergyStorage.setMaxCapacity(this.batteries * 6480000);
            this.sync();
            ((BlockEntityIndustrialBatteryBank)((Object)this.getBase())).recalculateTowerCapacity();
        }
        return true;
    }

    public boolean removeBattery(Player player) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (!this.f_58857_.f_46443_) {
            if (this.batteries <= 0) {
                return false;
            }
            --this.batteries;
            if (!player.m_7500_()) {
                player.m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.BATTERY_LITHIUM.get()));
            }
            this.customEnergyStorage.setMaxCapacity(this.batteries * 6480000);
            this.sync();
            ((BlockEntityIndustrialBatteryBank)((Object)this.getBase())).recalculateTowerCapacity();
        }
        return true;
    }

    private void recalculateTowerCapacity() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            int sum = this.getSumMaxEnergy();
            this.customEnergyStorage.setMaxCapacity(sum);
            this.sync();
        }
    }

    public void setFirstLoad() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_ && this.isMaster()) {
            if (this.isBase()) {
                if (this.tower == null || this.tower.isEmpty()) {
                    this.loadTower();
                }
            } else {
                this.tower = ((BlockEntityIndustrialBatteryBank)((Object)this.getBase())).tower;
            }
        }
    }

    @Override
    public void loadTower() {
        this.tower = new ArrayList();
        for (BlockEntityIndustrialBatteryBank chunk = this; chunk != null; chunk = (BlockEntityIndustrialBatteryBank)((Object)chunk.getAbove())) {
            if (this.tower.contains((Object)chunk)) continue;
            this.tower.add(chunk);
        }
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.isMaster() && this.isBase()) {
            if (!this.firstLoad) {
                this.firstLoad = true;
                this.setFirstLoad();
            }
            if (this.batteries > 0 && this.customEnergyStorage.getEnergyStored() > 0) {
                this.outPut += this.outPutEnergy(this.customEnergyStorage, 10240, false);
            }
            if (this.tick >= 10) {
                this.tick = 0;
                this.avrIn = this.input / 10;
                this.avrOut = this.outPut / 10;
                this.input = 0;
                this.outPut = 0;
                if (this.avrOut != this.oldOutPut || this.avrIn != this.oldIn) {
                    this.oldOutPut = this.avrOut;
                    this.oldIn = this.avrIn;
                    this.sync();
                }
            }
            ++this.tick;
        }
    }

    public int getSumMaxEnergy() {
        if (this.tower == null || this.tower.isEmpty()) {
            return 0;
        }
        return this.tower.stream().mapToInt(BlockEntityIndustrialBatteryBank::getRealCapacity).sum();
    }

    public int getRealCapacity() {
        return 6480000 * this.batteries;
    }

    public int getBatteries() {
        return this.batteries;
    }

    public String getEnergyText() {
        return Utils.formatEnergyString(this.customEnergyStorage.getEnergyStored()).replace(" FE", "") + " / " + Utils.formatEnergyString(this.customEnergyStorage.getMaxEnergyStored());
    }

    public float getBatteryFill() {
        return Utils.normalizeClamped(this.customEnergyStorage.getEnergyStored(), 0.0f, this.customEnergyStorage.getMaxEnergyStored());
    }

    public float getOutPutAngle() {
        return Utils.normalizeClamped(this.avrOut, 0.0f, 10240.0f) * 90.0f;
    }

    public String getOutPutText() {
        return Utils.formatPreciseEnergyString(this.avrOut) + "/t";
    }

    public float getInPutAngle() {
        return Utils.normalizeClamped(this.avrIn, 0.0f, 10240.0f) * 90.0f;
    }

    public String getInPutText() {
        return Utils.formatPreciseEnergyString(this.avrIn) + "/t";
    }

    public String getInPutIndicatorText() {
        return "Input";
    }

    public String getOutPutIndicatorText() {
        return "Output";
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        BlockEntityIndustrialBatteryBank masterTE = (BlockEntityIndustrialBatteryBank)((Object)this.getMaster());
        if (masterTE == null) {
            return super.getCapability(cap, side);
        }
        if (side == null) {
            return super.getCapability(cap, side);
        }
        Direction face = this.getMasterFacing();
        BlockPos masterPos = masterTE.m_58899_();
        if (cap == ForgeCapabilities.ENERGY && this.f_58858_.equals((Object)masterPos.m_121945_(face.m_122428_()).m_7494_()) && side == Direction.UP) {
            return ((BlockEntityIndustrialBatteryBank)((Object)this.getMaster())).energyStorage.cast();
        }
        if (cap == ForgeCapabilities.ENERGY && this.f_58858_.equals((Object)masterPos.m_121945_(face.m_122427_()).m_7494_()) && side == Direction.UP) {
            return ((BlockEntityIndustrialBatteryBank)((Object)this.getMaster())).dummyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        compoundTag.m_128405_("energy", this.customEnergyStorage.getEnergyStored());
        compoundTag.m_128405_("capacity", this.customEnergyStorage.getMaxEnergyStored());
        compoundTag.m_128405_("out", this.avrOut);
        compoundTag.m_128405_("in", this.avrIn);
        compoundTag.m_128405_("battery", this.batteries);
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        this.avrOut = compoundTag.m_128451_("out");
        this.avrIn = compoundTag.m_128451_("in");
        this.batteries = compoundTag.m_128451_("battery");
        this.customEnergyStorage.setMaxCapacity(compoundTag.m_128451_("capacity"));
        this.customEnergyStorage.setEnergy(compoundTag.m_128451_("energy"));
        super.m_142466_(compoundTag);
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

