/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import net.cassiokf.industrialrenewal.block.BlockEnergyLevel;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;

public class BlockEntityEnergyLevel
extends BlockEntitySyncable {
    private Direction indicatorHorizontalFacing;
    private Direction baseFacing;
    private IEnergyStorage energyStorage;

    public BlockEntityEnergyLevel(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.ENERGY_LEVEL.get(), pos, state);
    }

    public String GetText() {
        if (this.getEnergyStorage() != null) {
            int energy = this.energyStorage.getEnergyStored();
            String text = "" + energy;
            if (energy >= 1000 && energy < 1000000) {
                text = energy / 1000 + "K";
            }
            if (energy >= 1000000) {
                text = energy / 1000000 + "M";
            }
            int energy2 = this.energyStorage.getMaxEnergyStored();
            String textM = energy2 + " FE";
            if (energy >= 1000 && energy2 < 1000000) {
                textM = energy2 / 1000 + "K FE";
            }
            if (energy2 >= 1000000) {
                textM = energy2 / 1000000 + "M FE";
            }
            return text + " / " + textM;
        }
        return "No Battery";
    }

    public Direction getGaugeFacing() {
        if (this.indicatorHorizontalFacing != null) {
            return this.indicatorHorizontalFacing;
        }
        return this.forceIndicatorCheck();
    }

    public Direction forceIndicatorCheck() {
        this.indicatorHorizontalFacing = (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockEnergyLevel.GAUGE);
        return this.indicatorHorizontalFacing;
    }

    public Direction getBaseFacing() {
        if (this.baseFacing != null) {
            return this.baseFacing;
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_60734_() instanceof BlockEnergyLevel) {
            this.baseFacing = (Direction)state.m_61143_((Property)BlockEnergyLevel.FACING);
        }
        return this.baseFacing;
    }

    public void setBaseFacing(Direction baseFacing) {
        this.baseFacing = baseFacing;
    }

    public float getTankFill() {
        if (this.getEnergyStorage() != null) {
            float currentAmount = this.energyStorage.getEnergyStored();
            float totalCapacity = this.energyStorage.getMaxEnergyStored();
            return currentAmount /= totalCapacity;
        }
        return 0.0f;
    }

    private IEnergyStorage getEnergyStorage() {
        if (this.energyStorage != null) {
            return this.energyStorage;
        }
        return this.forceCheck();
    }

    public IEnergyStorage forceCheck() {
        IEnergyStorage handler;
        if (this.f_58857_ == null) {
            return null;
        }
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(this.getBaseFacing()));
        if (te != null && (handler = (IEnergyStorage)te.getCapability(ForgeCapabilities.ENERGY, this.baseFacing.m_122424_()).orElse(null)) != null) {
            this.energyStorage = handler;
            return this.energyStorage;
        }
        this.energyStorage = null;
        this.sync();
        return null;
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        compoundTag.m_128379_("energy", this.energyStorage != null);
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        if (!compoundTag.m_128471_("energy")) {
            this.energyStorage = null;
        }
        super.m_142466_(compoundTag);
    }
}

