/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import java.util.HashSet;
import java.util.Set;
import net.cassiokf.industrialrenewal.block.abstracts.BlockAbstractHorizontalFacing;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.util.Utils;
import net.cassiokf.industrialrenewal.util.capability.CustomEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityBatteryBank
extends BlockEntitySyncable {
    public static final int CONFIG_CAPACITY = 1000000;
    public static final int MAX_TRANSFER = 1000;
    private final Set<Direction> outPutFacings = new HashSet<Direction>();
    private final CustomEnergyStorage energyStorage = new CustomEnergyStorage(1000000, 1000, 1000).setBlockEntity(this);
    private final CustomEnergyStorage dummyStorage = new CustomEnergyStorage(0).noExtraction().noReceive();
    private final LazyOptional<CustomEnergyStorage> energyStorageHandler = LazyOptional.of(() -> this.energyStorage);
    private final LazyOptional<CustomEnergyStorage> dummyHandler = LazyOptional.of(() -> this.dummyStorage);
    private Direction blockFacing;

    public BlockEntityBatteryBank(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.BATTERY_BANK.get(), pos, state);
    }

    public void tick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        for (Direction face : this.outPutFacings) {
            BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(face));
            if (te == null) continue;
            this.energyStorageHandler.ifPresent(thisStorage -> te.getCapability(ForgeCapabilities.ENERGY, face.m_122424_()).ifPresent(eStorage -> {
                if (eStorage.canReceive()) {
                    int energyExtracted = thisStorage.extractEnergy(1000, true);
                    int energyReceived = eStorage.receiveEnergy(energyExtracted, false);
                    thisStorage.extractEnergy(energyReceived, false);
                }
            }));
        }
    }

    public boolean toggleFacing(Direction facing) {
        if (this.outPutFacings.contains(facing)) {
            this.outPutFacings.remove(facing);
            this.sync();
            this.requestModelDataUpdate();
            return false;
        }
        this.outPutFacings.add(facing);
        this.sync();
        this.requestModelDataUpdate();
        return true;
    }

    public boolean isFacingOutput(@Nullable Direction facing) {
        return this.outPutFacings.contains(facing) || facing == null;
    }

    public Direction getBlockFacing() {
        if (this.blockFacing != null) {
            return this.blockFacing;
        }
        return this.forceFaceCheck();
    }

    public Direction forceFaceCheck() {
        this.blockFacing = (Direction)this.m_58900_().m_61143_((Property)BlockAbstractHorizontalFacing.FACING);
        return this.blockFacing;
    }

    public String getText() {
        IEnergyStorage energyStorage1 = (IEnergyStorage)this.energyStorageHandler.orElse(null);
        if (energyStorage1 == null) {
            return "NULL";
        }
        int energy = energyStorage1.getEnergyStored();
        return Utils.formatEnergyString(energy);
    }

    public float getTankFill() {
        IEnergyStorage iEnergyStorage = (IEnergyStorage)this.energyStorageHandler.orElse(null);
        if (iEnergyStorage == null) {
            return 0.0f;
        }
        float currentAmount = (float)iEnergyStorage.getEnergyStored() / 1000.0f;
        float totalCapacity = (float)iEnergyStorage.getMaxEnergyStored() / 1000.0f;
        return currentAmount /= totalCapacity;
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        compoundTag.m_128405_("energy", this.energyStorage.getEnergyStored());
        int[] enabledFacingIndices = this.outPutFacings.stream().mapToInt(Direction::m_122411_).toArray();
        compoundTag.m_128385_("OutputFacings", enabledFacingIndices);
        compoundTag.m_128405_("face", this.getBlockFacing().m_122416_());
        super.m_183515_(compoundTag);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        int[] enabledFacingIndices;
        this.energyStorage.setEnergy(compoundTag.m_128451_("energy"));
        this.outPutFacings.clear();
        for (int fd : enabledFacingIndices = compoundTag.m_128465_("OutputFacings")) {
            this.outPutFacings.add(Direction.m_122376_((int)fd));
        }
        this.blockFacing = Direction.m_122407_((int)compoundTag.m_128451_("face"));
        super.m_142466_(compoundTag);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyStorageHandler.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side == null) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.ENERGY && this.isFacingOutput(side)) {
            return this.dummyHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY && side != this.getBlockFacing().m_122424_()) {
            return this.energyStorageHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

