/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.blockentity;

import javax.annotation.Nonnull;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntitySyncable;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.util.capability.CustomFluidTank;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityBarrel
extends BlockEntitySyncable {
    private final int MAX_CAPACITY = 64000;
    public final CustomFluidTank tank = new CustomFluidTank(64000).setBlockEntity(this);
    protected LazyOptional<CustomFluidTank> handler = LazyOptional.of(() -> this.tank);

    public BlockEntityBarrel(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.BARREL_TILE.get(), pos, state);
    }

    public String getFluid() {
        return this.tank.getFluid().getTranslationKey();
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public int getMAX_CAPACITY() {
        return 64000;
    }

    public String getChatQuantity() {
        if (this.tank.getFluidAmount() > 0) {
            return String.format("%s: %d/%d mB", I18n.m_118938_((String)this.tank.getFluid().getTranslationKey(), (Object[])new Object[0]), this.tank.getFluidAmount(), 64000);
        }
        return "Empty";
    }

    public void m_7651_() {
        super.m_7651_();
    }

    @Override
    public void m_183515_(CompoundTag compoundNBT) {
        CompoundTag nbt = new CompoundTag();
        this.tank.writeToNBT(nbt);
        compoundNBT.m_128365_("fluid", (Tag)nbt);
        super.m_183515_(compoundNBT);
    }

    @Override
    public void m_142466_(CompoundTag compoundNBT) {
        CompoundTag nbt = compoundNBT.m_128469_("fluid");
        this.tank.readFromNBT(nbt);
        super.m_142466_(compoundNBT);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.handler.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }
}

