/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.block.transport;

import java.util.List;
import net.cassiokf.industrialrenewal.block.BlockEnergyLevel;
import net.cassiokf.industrialrenewal.block.abstracts.BlockPipeBase;
import net.cassiokf.industrialrenewal.block.transport.BlockEnergyCableMeter;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntityEnergyCable;
import net.cassiokf.industrialrenewal.blockentity.transport.BlockEntityEnergyCableHV;
import net.cassiokf.industrialrenewal.blockentity.transport.BlockEntityEnergyCableLV;
import net.cassiokf.industrialrenewal.blockentity.transport.BlockEntityEnergyCableMV;
import net.cassiokf.industrialrenewal.init.ModBlockEntity;
import net.cassiokf.industrialrenewal.init.ModBlocks;
import net.cassiokf.industrialrenewal.item.ItemScrewdriver;
import net.cassiokf.industrialrenewal.util.enums.EnumCableIn;
import net.cassiokf.industrialrenewal.util.enums.EnumEnergyCableType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.Nullable;

public class BlockEnergyCable
extends BlockPipeBase<BlockEntityEnergyCable>
implements EntityBlock {
    public EnumEnergyCableType type;

    public BlockEnergyCable(EnumEnergyCableType type) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(1.0f), 4.0f, 4.0f);
        this.type = type;
    }

    public static EnumCableIn convertFromType(EnumEnergyCableType type) {
        return switch (type) {
            case EnumEnergyCableType.MV -> EnumCableIn.MV;
            case EnumEnergyCableType.HV -> EnumCableIn.HV;
            default -> EnumCableIn.LV;
        };
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hitResult) {
        if (player.m_21120_(handIn).m_41720_() == ((BlockEnergyLevel)((Object)ModBlocks.ENERGY_LEVEL.get())).m_5456_()) {
            if (!worldIn.f_46443_) {
                BlockEnergyCableMeter block = switch (this.type) {
                    case EnumEnergyCableType.MV -> (BlockEnergyCableMeter)((Object)ModBlocks.ENERGYCABLE_MV_METER.get());
                    case EnumEnergyCableType.HV -> (BlockEnergyCableMeter)((Object)ModBlocks.ENERGYCABLE_HV_METER.get());
                    default -> (BlockEnergyCableMeter)((Object)ModBlocks.ENERGYCABLE_LV_METER.get());
                };
                worldIn.m_46597_(pos, (BlockState)block.getState(worldIn, pos, block.m_49966_()).m_61124_((Property)BlockEnergyCableMeter.FACING, (Comparable)player.m_6350_()));
                ItemScrewdriver.playSound(worldIn, pos);
                if (!player.m_7500_()) {
                    player.m_21120_(handIn).m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hitResult);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        int amount = switch (this.type) {
            case EnumEnergyCableType.MV -> BlockEntityEnergyCableMV.MAX_ENERGY;
            case EnumEnergyCableType.HV -> BlockEntityEnergyCableHV.MAX_ENERGY;
            default -> BlockEntityEnergyCableLV.MAX_ENERGY;
        };
        tooltip.add((Component)Component.m_237113_((String)(amount + " FE/t")));
        super.m_5871_(stack, world, tooltip, flag);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getState(context.m_43725_(), context.m_8083_(), this.m_49966_());
    }

    @Override
    public boolean canConnectToPipe(BlockGetter world, BlockPos pos, Direction facing) {
        Block block = world.m_8055_(pos.m_121945_(facing)).m_60734_();
        return block instanceof BlockEnergyCable && this.type.equals((Object)((BlockEnergyCable)block).type);
    }

    @Override
    public boolean canConnectToCapability(BlockGetter world, BlockPos pos, Direction facing) {
        BlockEntity te = world.m_7702_(pos.m_121945_(facing));
        Block block = world.m_8055_(pos.m_121945_(facing)).m_60734_();
        return te != null && !(block instanceof BlockEnergyCable) && te.getCapability(ForgeCapabilities.ENERGY, facing.m_122424_()).isPresent();
    }

    public BlockState getState(Level world, BlockPos pos, BlockState oldState) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)oldState.m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.canConnectToPipe((BlockGetter)world, pos, Direction.UP)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(this.canConnectToPipe((BlockGetter)world, pos, Direction.DOWN)))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectToPipe((BlockGetter)world, pos, Direction.NORTH)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectToPipe((BlockGetter)world, pos, Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectToPipe((BlockGetter)world, pos, Direction.EAST)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectToPipe((BlockGetter)world, pos, Direction.WEST)))).m_61124_((Property)CUP, (Comparable)Boolean.valueOf(this.canConnectToCapability((BlockGetter)world, pos, Direction.UP)))).m_61124_((Property)CDOWN, (Comparable)Boolean.valueOf(this.canConnectToCapability((BlockGetter)world, pos, Direction.DOWN)))).m_61124_((Property)CNORTH, (Comparable)Boolean.valueOf(this.canConnectToCapability((BlockGetter)world, pos, Direction.NORTH)))).m_61124_((Property)CSOUTH, (Comparable)Boolean.valueOf(this.canConnectToCapability((BlockGetter)world, pos, Direction.SOUTH)))).m_61124_((Property)CEAST, (Comparable)Boolean.valueOf(this.canConnectToCapability((BlockGetter)world, pos, Direction.EAST)))).m_61124_((Property)CWEST, (Comparable)Boolean.valueOf(this.canConnectToCapability((BlockGetter)world, pos, Direction.WEST)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case EnumEnergyCableType.LV -> (BlockEntityEnergyCableLV)((BlockEntityType)ModBlockEntity.ENERGYCABLE_LV_TILE.get()).m_155264_(pos, state);
            case EnumEnergyCableType.MV -> (BlockEntityEnergyCableMV)((BlockEntityType)ModBlockEntity.ENERGYCABLE_MV_TILE.get()).m_155264_(pos, state);
            case EnumEnergyCableType.HV -> (BlockEntityEnergyCableHV)((BlockEntityType)ModBlockEntity.ENERGYCABLE_HV_TILE.get()).m_155264_(pos, state);
        };
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return level.f_46443_ ? null : ($0, $1, $2, blockEntity) -> ((BlockEntityEnergyCable)blockEntity).tick();
    }
}

