/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.block.decor;

import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.block.abstracts.BlockAbstractSixWayConnections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockScaffold
extends BlockAbstractSixWayConnections {
    protected static final VoxelShape CBASE_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public BlockScaffold() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(0.8f), 16.0f, 16.0f);
    }

    public static void applyLadderLogic(Entity entityIn) {
        if (entityIn instanceof LivingEntity && !((LivingEntity)entityIn).m_6147_()) {
            Vec3 motion = entityIn.m_20184_();
            float maxMotion = 0.15f;
            motion = new Vec3(Mth.m_14008_((double)motion.f_82479_, (double)(-maxMotion), (double)maxMotion), Mth.m_14008_((double)motion.f_82480_, (double)(-maxMotion), (double)maxMotion), Mth.m_14008_((double)motion.f_82481_, (double)(-maxMotion), (double)maxMotion));
            entityIn.f_19789_ = 0.0f;
            if (motion.f_82480_ < 0.0 && entityIn instanceof Player && entityIn.m_6047_()) {
                motion = new Vec3(motion.f_82479_, 0.0, motion.f_82481_);
            } else if (entityIn.f_19862_) {
                motion = new Vec3(motion.f_82479_, 0.2, motion.f_82481_);
            }
            entityIn.m_20256_(motion);
        }
    }

    public boolean m_6864_(BlockState p_196253_1_, BlockPlaceContext context) {
        if (!context.m_43723_().m_6047_()) {
            return context.m_43722_().m_41720_() == this.m_5456_();
        }
        return super.m_6864_(p_196253_1_, context);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level worldIn = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState downState = worldIn.m_8055_(pos.m_7495_());
        return super.m_5573_(context);
    }

    protected boolean isValidConnection(BlockState neighborState, BlockGetter world, BlockPos ownPos, Direction neighborDirection) {
        Block nb = neighborState.m_60734_();
        Block nbd = world.m_8055_(ownPos.m_121945_(neighborDirection).m_7495_()).m_60734_();
        BlockState upState = world.m_8055_(ownPos.m_7494_());
        if (neighborDirection == Direction.DOWN) {
            return neighborState.m_60783_(world, ownPos.m_7495_(), Direction.UP);
        }
        if (neighborDirection != Direction.UP) {
            return !(upState.m_60734_() instanceof BlockScaffold) && !upState.m_60783_(world, ownPos.m_7494_(), Direction.DOWN) && !(nb instanceof BlockScaffold) && !(nbd instanceof BlockScaffold);
        }
        return !neighborState.m_60783_(world, ownPos.m_7494_(), Direction.DOWN) && !(nb instanceof BlockScaffold);
    }

    @Override
    public boolean canConnectTo(Level worldIn, BlockPos currentPos, Direction neighborDirection) {
        BlockPos neighborPos = currentPos.m_121945_(neighborDirection);
        BlockState neighborState = worldIn.m_8055_(neighborPos);
        return this.isValidConnection(neighborState, (BlockGetter)worldIn, currentPos, neighborDirection);
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        super.m_7892_(state, worldIn, pos, entityIn);
        if (entityIn instanceof LivingEntity && this.isLadder(state, (LevelReader)worldIn, pos, (LivingEntity)entityIn)) {
            BlockScaffold.applyLadderLogic(entityIn);
        }
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return CBASE_AABB;
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return CBASE_AABB;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighbor, boolean flag) {
        for (Direction face : Direction.values()) {
            state = (BlockState)state.m_61124_((Property)this.getPropertyBasedOnDirection(face), (Comparable)Boolean.valueOf(this.canConnectTo(world, pos, face)));
        }
        world.m_7731_(pos, state, 2);
        super.m_6861_(state, world, pos, block, neighbor, flag);
    }
}

