/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.block.decor;

import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.block.abstracts.BlockAbstractSixWayConnections;
import net.cassiokf.industrialrenewal.block.decor.BlockCatwalkGate;
import net.cassiokf.industrialrenewal.block.decor.BlockCatwalkStair;
import net.cassiokf.industrialrenewal.block.decor.BlockColumn;
import net.cassiokf.industrialrenewal.block.decor.BlockPillar;
import net.cassiokf.industrialrenewal.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockPlatform
extends BlockAbstractSixWayConnections {
    protected static final VoxelShape BASE_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)16.0, (double)0.0, (double)16.0, (double)32.0, (double)0.5);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)16.0, (double)15.5, (double)16.0, (double)32.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)16.0, (double)0.0, (double)0.03125, (double)32.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)15.5, (double)16.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);

    public BlockPlatform() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60955_().m_60978_(1.0f), 16.0f, 16.0f);
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext context) {
        if (!context.m_43723_().m_6047_()) {
            return context.m_43722_().m_41720_() == this.m_5456_();
        }
        return super.m_6864_(blockState, context);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        for (Direction direction : Direction.values()) {
            state = (BlockState)state.m_61124_((Property)this.getPropertyBasedOnDirection(direction), (Comparable)Boolean.valueOf(this.canConnectTo(context.m_43725_(), context.m_8083_(), direction)));
        }
        return state;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Item playerItem;
        if (!worldIn.f_46443_ && handIn == InteractionHand.MAIN_HAND && (playerItem = player.m_21205_().m_41720_()).equals(ModItems.SCREW_DRIVER.get())) {
            Vec3 hitQuad = hit.m_82450_().m_82546_(Vec3.m_82512_((Vec3i)pos));
            state = hit.m_82434_() == Direction.UP ? (BlockState)state.m_61122_((Property)this.quadToDir(hitQuad)) : (BlockState)state.m_61122_((Property)this.getBooleanProperty(hit.m_82434_()));
            worldIn.m_7731_(pos, state, 2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BooleanProperty getBooleanProperty(Direction face) {
        switch (face) {
            default: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case UP: {
                return UP;
            }
            case DOWN: 
        }
        return DOWN;
    }

    public BooleanProperty quadToDir(Vec3 vector3d) {
        if (vector3d.f_82481_ > vector3d.f_82479_ && vector3d.f_82481_ > -vector3d.f_82479_) {
            return SOUTH;
        }
        if (vector3d.f_82481_ < vector3d.f_82479_ && vector3d.f_82481_ < -vector3d.f_82479_) {
            return NORTH;
        }
        if (vector3d.f_82481_ > vector3d.f_82479_ && vector3d.f_82481_ < -vector3d.f_82479_) {
            return WEST;
        }
        if (vector3d.f_82481_ < vector3d.f_82479_ && vector3d.f_82481_ > -vector3d.f_82479_) {
            return EAST;
        }
        return NORTH;
    }

    @Override
    public boolean canConnectTo(Level worldIn, BlockPos currentPos, Direction neighborDirection) {
        BlockPos neighborPos = currentPos.m_121945_(neighborDirection);
        BlockState neighborState = worldIn.m_8055_(neighborPos);
        Block nb = neighborState.m_60734_();
        BlockState ub = worldIn.m_8055_(currentPos.m_7494_());
        BlockState nub = worldIn.m_8055_(neighborPos.m_7494_());
        if (neighborDirection != Direction.UP && neighborDirection != Direction.DOWN) {
            return nb instanceof BlockPlatform || neighborState.m_60783_((BlockGetter)worldIn, neighborPos, neighborDirection.m_122424_()) || nb instanceof BaseRailBlock || nb instanceof BlockCatwalkStair && neighborState.m_61143_((Property)BlockCatwalkStair.FACING) == neighborDirection.m_122424_() || ub.m_60734_() instanceof BlockCatwalkGate && neighborDirection == worldIn.m_8055_(currentPos.m_7494_()).m_61143_((Property)BlockCatwalkGate.FACING) || nub.m_60734_() instanceof BlockCatwalkStair && worldIn.m_8055_(neighborPos.m_7494_()).m_61143_((Property)BlockCatwalkStair.FACING) == neighborDirection;
        }
        if (neighborDirection == Direction.DOWN) {
            return Block.m_49936_((BlockGetter)worldIn, (BlockPos)neighborPos) || nb instanceof BlockPlatform || nb instanceof BlockPillar || nb instanceof BlockColumn;
        }
        return neighborState.m_60783_((BlockGetter)worldIn, neighborPos, neighborDirection.m_122424_()) || nb instanceof BlockPlatform || nb instanceof BlockPillar;
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter world, BlockPos pos, Entity collidingEntity) {
        return true;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VoxelShape finalShape = BASE_AABB;
        if (!this.isConnected(state, UP)) {
            if (!this.isConnected(state, NORTH)) {
                finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)NORTH_AABB);
            }
            if (!this.isConnected(state, SOUTH)) {
                finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)SOUTH_AABB);
            }
            if (!this.isConnected(state, WEST)) {
                finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)WEST_AABB);
            }
            if (!this.isConnected(state, EAST)) {
                finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)EAST_AABB);
            }
        }
        return finalShape;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighbor, boolean flag) {
        for (Direction face : Direction.values()) {
            state = (BlockState)state.m_61124_((Property)this.getPropertyBasedOnDirection(face), (Comparable)Boolean.valueOf(this.canConnectTo(world, pos, face)));
        }
        world.m_7731_(pos, state, 2);
        super.m_6861_(state, world, pos, block, neighbor, flag);
    }
}

