/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.block.decor;

import net.cassiokf.industrialrenewal.block.abstracts.BlockAbstractSixWayConnections;
import net.cassiokf.industrialrenewal.block.decor.BlockCatwalkHatch;
import net.cassiokf.industrialrenewal.block.decor.BlockCatwalkLadder;
import net.cassiokf.industrialrenewal.block.decor.BlockLight;
import net.cassiokf.industrialrenewal.init.ModBlocks;
import net.cassiokf.industrialrenewal.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockIndustrialFloor
extends BlockAbstractSixWayConnections {
    public static final BooleanProperty LIGHT = BooleanProperty.m_61465_((String)"light");
    protected static final VoxelShape NONE_AABB = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    protected static final VoxelShape C_UP_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape C_DOWN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape C_NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape C_SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape C_WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    protected static final VoxelShape C_EAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BlockIndustrialFloor() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(1.0f), 16.0f, 16.0f);
    }

    private static boolean isValidConnection(BlockState neighborState, BlockGetter world, BlockPos ownPos, Direction neighborDirection) {
        Block nb = neighborState.m_60734_();
        return nb instanceof BlockIndustrialFloor || nb instanceof DoorBlock && ((Direction)neighborState.m_61143_((Property)DoorBlock.f_52726_)).equals((Object)neighborDirection) || neighborDirection.equals((Object)Direction.DOWN) && nb instanceof BlockCatwalkLadder || neighborDirection.equals((Object)Direction.UP) && nb instanceof BlockCatwalkHatch || neighborDirection != Direction.UP && neighborDirection != Direction.DOWN && nb instanceof BlockCatwalkLadder && (Boolean)neighborState.m_61143_((Property)BlockCatwalkLadder.ACTIVE) == false;
    }

    @Override
    protected BlockState getInitDefaultState() {
        return (BlockState)super.getInitDefaultState().m_61124_((Property)LIGHT, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIGHT});
    }

    @Override
    public boolean canConnectTo(Level worldIn, BlockPos currentPos, Direction neighborDirection) {
        BlockPos neighborPos = currentPos.m_121945_(neighborDirection);
        BlockState neighborState = worldIn.m_8055_(neighborPos);
        return !BlockIndustrialFloor.isValidConnection(neighborState, (BlockGetter)worldIn, currentPos, neighborDirection);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.f_46443_) {
            for (Direction direction : Direction.values()) {
                if (this.canConnectTo(worldIn, pos, direction)) {
                    worldIn.m_7731_(pos, (BlockState)worldIn.m_8055_(pos).m_61124_((Property)this.getPropertyBasedOnDirection(direction), (Comparable)Boolean.valueOf(true)), 3);
                    continue;
                }
                worldIn.m_7731_(pos, (BlockState)worldIn.m_8055_(pos).m_61124_((Property)this.getPropertyBasedOnDirection(direction), (Comparable)Boolean.valueOf(false)), 3);
            }
        }
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack playerStack = player.m_21120_(handIn);
        if (!worldIn.f_46443_) {
            Item playerItem;
            if (!((Boolean)state.m_61143_((Property)LIGHT)).booleanValue()) {
                if (Block.m_49814_((Item)playerStack.m_41720_()) instanceof BlockLight) {
                    worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)LIGHT, (Comparable)Boolean.valueOf(true)), 3);
                    if (!player.m_7500_()) {
                        playerStack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            if (handIn == InteractionHand.MAIN_HAND && (playerItem = player.m_21205_().m_41720_()).equals(ModItems.SCREW_DRIVER.get())) {
                worldIn.m_7731_(pos, (BlockState)Block.m_49814_((Item)playerStack.m_41720_()).m_49966_().m_61124_((Property)LIGHT, (Comparable)Boolean.valueOf(false)), 3);
                Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)((BlockLight)((Object)ModBlocks.LIGHT.get())).m_5456_(), 1));
                worldIn.m_7731_(pos, state, 2);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        if (this.isConnected(state, LIGHT)) {
            return 15;
        }
        return 0;
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VoxelShape SHAPE = NULL_SHAPE;
        for (Direction face : Direction.values()) {
            BooleanProperty prop = this.getPropertyBasedOnDirection(face);
            if (!((Boolean)state.m_61143_((Property)prop)).booleanValue()) continue;
            SHAPE = switch (face) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.UP -> Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)C_UP_AABB);
                case Direction.DOWN -> Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)C_DOWN_AABB);
                case Direction.NORTH -> Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)C_NORTH_AABB);
                case Direction.SOUTH -> Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)C_SOUTH_AABB);
                case Direction.EAST -> Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)C_EAST_AABB);
                case Direction.WEST -> Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)C_WEST_AABB);
            };
        }
        return SHAPE;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean flag) {
        if (!state.m_60713_(oldState.m_60734_()) && ((Boolean)state.m_61143_((Property)LIGHT)).booleanValue()) {
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)((BlockLight)((Object)ModBlocks.LIGHT.get())).m_5456_(), 1));
        }
        super.m_6810_(state, world, pos, oldState, flag);
    }
}

