/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.block.decor;

import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.block.abstracts.BlockAbstractNotFullCube;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockElectricGate
extends BlockAbstractNotFullCube {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final BooleanProperty INVERTED = BooleanProperty.m_61465_((String)"inverted");
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty LEFT = BooleanProperty.m_61465_((String)"left");
    public static final BooleanProperty RIGHT = BooleanProperty.m_61465_((String)"right");
    protected static final VoxelShape RNORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape RWEST_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    protected static final VoxelShape CNORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)24.0, (double)10.0);
    protected static final VoxelShape CWEST_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)24.0, (double)16.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)-14.0, (double)0.0, (double)6.0, (double)2.0, (double)24.0, (double)10.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)14.0, (double)0.0, (double)6.0, (double)30.0, (double)24.0, (double)10.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)14.0, (double)10.0, (double)24.0, (double)30.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)-14.0, (double)10.0, (double)24.0, (double)2.0);
    protected static final VoxelShape INORTH_AABB = Block.m_49796_((double)14.0, (double)0.0, (double)6.0, (double)30.0, (double)24.0, (double)10.0);
    protected static final VoxelShape ISOUTH_AABB = Block.m_49796_((double)-14.0, (double)0.0, (double)6.0, (double)2.0, (double)24.0, (double)10.0);
    protected static final VoxelShape IWEST_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)-14.0, (double)10.0, (double)24.0, (double)2.0);
    protected static final VoxelShape IEAST_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)14.0, (double)10.0, (double)24.0, (double)30.0);

    public BlockElectricGate() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(1.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, ACTIVE, UP, LEFT, RIGHT, INVERTED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.getFullState(this.m_49966_(), context.m_43725_(), context.m_8083_());
        return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        boolean active = (Boolean)state.m_61143_((Property)ACTIVE) == false;
        this.OpenUpAndDown(worldIn, state, pos, active);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos rightPos = pos.m_121945_(facing.m_122427_());
        BlockPos leftPos = pos.m_121945_(facing.m_122428_());
        BlockState rightState = worldIn.m_8055_(rightPos);
        BlockState leftState = worldIn.m_8055_(leftPos);
        boolean inverted = (Boolean)state.m_61143_((Property)INVERTED);
        if (!inverted && rightState.m_60734_() instanceof BlockElectricGate && ((Boolean)rightState.m_61143_((Property)INVERTED)).booleanValue()) {
            ((BlockElectricGate)rightState.m_60734_()).OpenUpAndDown(worldIn, rightState, rightPos, active);
        } else if (inverted && leftState.m_60734_() instanceof BlockElectricGate && !((Boolean)leftState.m_61143_((Property)INVERTED)).booleanValue()) {
            ((BlockElectricGate)leftState.m_60734_()).OpenUpAndDown(worldIn, leftState, leftPos, active);
        }
        return InteractionResult.SUCCESS;
    }

    public void OpenUpAndDown(Level world, BlockState state, BlockPos pos, boolean active) {
        BlockState upstate = world.m_8055_(pos.m_7494_());
        BlockState dnstate = world.m_8055_(pos.m_7495_());
        Block upb = upstate.m_60734_();
        Block dnb = dnstate.m_60734_();
        state = (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(active));
        world.m_46597_(pos, state);
        if (upb instanceof BlockElectricGate) {
            this.OpenUp(world, pos, active);
        }
        if (dnb instanceof BlockElectricGate) {
            this.OpenDown(world, pos, active);
        }
    }

    public void OpenUp(Level world, BlockPos pos, boolean active) {
        int n = 1;
        while (world.m_8055_(pos.m_6630_(n)).m_60734_() instanceof BlockElectricGate) {
            BlockState thisState = (BlockState)world.m_8055_(pos.m_6630_(n)).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(active));
            world.m_46597_(pos.m_6630_(n), thisState);
            ++n;
        }
    }

    public void OpenDown(Level world, BlockPos pos, boolean active) {
        int n = 1;
        while (world.m_8055_(pos.m_6625_(n)).m_60734_() instanceof BlockElectricGate) {
            BlockState thisState = (BlockState)world.m_8055_(pos.m_6625_(n)).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(active));
            world.m_46597_(pos.m_6625_(n), thisState);
            ++n;
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.getFullState(stateIn, (Level)worldIn, currentPos);
    }

    private BlockState getFullState(BlockState stateIn, Level worldIn, BlockPos currentPos) {
        Direction face = (Direction)stateIn.m_61143_((Property)FACING);
        BlockState rightState = worldIn.m_8055_(currentPos.m_121945_(face.m_122427_()));
        BlockState leftState = worldIn.m_8055_(currentPos.m_121945_(face.m_122428_()));
        boolean leftIsGate = leftState.m_60734_() instanceof BlockElectricGate;
        boolean rightIsGate = rightState.m_60734_() instanceof BlockElectricGate;
        boolean inverted = leftIsGate && !rightIsGate;
        Block dnb = worldIn.m_8055_(currentPos.m_7495_()).m_60734_();
        Block upb = worldIn.m_8055_(currentPos.m_7494_()).m_60734_();
        boolean isTop = dnb instanceof BlockElectricGate && !(upb instanceof BlockElectricGate);
        stateIn = (BlockState)((BlockState)((BlockState)((BlockState)stateIn.m_61124_((Property)UP, (Comparable)Boolean.valueOf(isTop))).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(inverted))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(!inverted))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(!rightIsGate));
        return stateIn;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state, false);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state, true);
    }

    private VoxelShape getVoxelShape(BlockState state, boolean collision) {
        Direction face = (Direction)state.m_61143_((Property)FACING);
        if (!collision) {
            if (face == Direction.NORTH || face == Direction.SOUTH) {
                return RNORTH_AABB;
            }
            return RWEST_AABB;
        }
        boolean active = (Boolean)state.m_61143_((Property)ACTIVE);
        boolean inverted = (Boolean)state.m_61143_((Property)INVERTED);
        VoxelShape FINAL_SHAPE = NULL_SHAPE;
        if (active) {
            if (face == Direction.NORTH) {
                FINAL_SHAPE = inverted ? Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)INORTH_AABB) : Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)NORTH_AABB);
            } else if (face == Direction.SOUTH) {
                FINAL_SHAPE = inverted ? Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)ISOUTH_AABB) : Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)SOUTH_AABB);
            } else if (face == Direction.WEST) {
                FINAL_SHAPE = inverted ? Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)IWEST_AABB) : Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)WEST_AABB);
            } else if (face == Direction.EAST) {
                FINAL_SHAPE = inverted ? Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)IEAST_AABB) : Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)EAST_AABB);
            }
        } else if (face == Direction.NORTH || face == Direction.SOUTH) {
            FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)CNORTH_AABB);
        } else if (face == Direction.WEST || face == Direction.EAST) {
            FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)CWEST_AABB);
        }
        return FINAL_SHAPE;
    }
}

