/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.block.decor;

import java.util.Objects;
import net.cassiokf.industrialrenewal.block.BlockHVIsolator;
import net.cassiokf.industrialrenewal.block.abstracts.BlockAbstractSixWayConnections;
import net.cassiokf.industrialrenewal.block.decor.BlockBrace;
import net.cassiokf.industrialrenewal.block.decor.BlockCatwalkLadder;
import net.cassiokf.industrialrenewal.block.decor.BlockLight;
import net.cassiokf.industrialrenewal.block.decor.BlockPillar;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockColumn
extends BlockAbstractSixWayConnections {
    public BlockColumn() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(1.0f), 8.0f, 12.0f);
    }

    protected boolean isValidConnection(BlockState neighborState, BlockState ownState, Level world, BlockPos ownPos, Direction neighborDirection, BlockPos neighborPos) {
        Block nb = neighborState.m_60734_();
        if (nb instanceof BlockColumn || nb instanceof BlockPillar || nb instanceof BlockHVIsolator && neighborState.m_61143_((Property)BlockHVIsolator.FACING) == neighborDirection.m_122424_()) {
            return true;
        }
        if (Block.m_49936_((BlockGetter)world, (BlockPos)neighborPos) && neighborDirection != Direction.UP && neighborDirection != Direction.DOWN) {
            Block oppositBlock = world.m_8055_(ownPos.m_121945_(neighborDirection.m_122424_())).m_60734_();
            return oppositBlock instanceof BlockColumn || oppositBlock instanceof BlockPillar;
        }
        if (neighborDirection != Direction.UP && neighborDirection != Direction.DOWN) {
            if (nb instanceof BlockBrace) {
                return Objects.equals(((BlockBrace.EnumOrientation)((Object)neighborState.m_61143_(BlockBrace.FACING))).getName(), neighborDirection.m_122424_().m_122433_()) || Objects.equals(((BlockBrace.EnumOrientation)((Object)neighborState.m_61143_(BlockBrace.FACING))).getName(), "down_" + neighborDirection.m_122433_());
            }
            return nb instanceof BlockColumn || nb instanceof BlockPillar || nb instanceof BlockLight && neighborState.m_61143_((Property)BlockLight.FACING) == neighborDirection.m_122424_();
        }
        if (nb instanceof BlockColumn) {
            return true;
        }
        if (nb instanceof BlockBrace) {
            return Direction.Plane.HORIZONTAL.test(((BlockBrace.EnumOrientation)((Object)neighborState.m_61143_(BlockBrace.FACING))).getFacing());
        }
        return !(nb instanceof BlockCatwalkLadder) && !neighborState.m_60795_();
    }

    @Override
    public boolean canConnectTo(Level worldIn, BlockPos currentPos, Direction neighborDirection) {
        BlockPos neighborPos = currentPos.m_121945_(neighborDirection);
        BlockState neighborState = worldIn.m_8055_(neighborPos);
        BlockState ownState = worldIn.m_8055_(currentPos);
        boolean result = this.isValidConnection(neighborState, ownState, worldIn, currentPos, neighborDirection, neighborPos);
        return result;
    }

    public final boolean isConnected(BlockState state, Direction facing) {
        switch (facing) {
            case DOWN: {
                return (Boolean)state.m_61143_((Property)DOWN);
            }
            case UP: {
                return (Boolean)state.m_61143_((Property)UP);
            }
            default: {
                return (Boolean)state.m_61143_((Property)NORTH);
            }
            case SOUTH: {
                return (Boolean)state.m_61143_((Property)SOUTH);
            }
            case WEST: {
                return (Boolean)state.m_61143_((Property)WEST);
            }
            case EAST: 
        }
        return (Boolean)state.m_61143_((Property)EAST);
    }

    @Override
    public VoxelShape getVoxelShape(BlockState state, boolean collision) {
        float NORTHZ1 = this.isConnected(state, Direction.NORTH) ? 0.0f : 4.0f;
        float SOUTHZ2 = this.isConnected(state, Direction.SOUTH) ? 16.0f : 12.0f;
        float WESTX1 = this.isConnected(state, Direction.WEST) ? 0.0f : 4.0f;
        float EASTX2 = this.isConnected(state, Direction.EAST) ? 16.0f : 12.0f;
        float DOWNY1 = this.isConnected(state, Direction.DOWN) ? 0.0f : 5.0f;
        return Block.m_49796_((double)WESTX1, (double)DOWNY1, (double)NORTHZ1, (double)EASTX2, (double)16.0, (double)SOUTHZ2);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighbor, boolean flag) {
        if (!world.f_46443_) {
            for (Direction face : Direction.values()) {
                state = (BlockState)state.m_61124_((Property)this.getPropertyBasedOnDirection(face), (Comparable)Boolean.valueOf(this.canConnectTo(world, pos, face)));
            }
            world.m_46597_(pos, state);
        }
        super.m_6861_(state, world, pos, block, neighbor, flag);
    }
}

