/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.block.decor;

import javax.annotation.Nullable;
import net.cassiokf.industrialrenewal.block.abstracts.BlockAbstractHorizontalFacingWithActivating;
import net.cassiokf.industrialrenewal.block.decor.BlockCatwalkHatch;
import net.cassiokf.industrialrenewal.block.decor.BlockCatwalkStair;
import net.cassiokf.industrialrenewal.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockCatwalkLadder
extends BlockAbstractHorizontalFacingWithActivating {
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    protected static final VoxelShape DOWN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0);
    protected static final VoxelShape LADDER_EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape LADDER_WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape LADDER_SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape LADDER_NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BlockCatwalkLadder(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(1.0f));
    }

    public BlockCatwalkLadder() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60978_(1.0f));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
    }

    public boolean m_6864_(BlockState p_196253_1_, BlockPlaceContext context) {
        if (!context.m_43723_().m_6047_()) {
            return context.m_43722_().m_41720_() == this.m_5456_();
        }
        return super.m_6864_(p_196253_1_, context);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hitResult) {
        Item playerItem;
        if (!worldIn.f_46443_ && handIn == InteractionHand.MAIN_HAND && (playerItem = player.m_21205_().m_41720_()).equals(ModItems.SCREW_DRIVER.get())) {
            return super.m_6227_(state, worldIn, pos, player, handIn, hitResult);
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{DOWN});
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return true;
    }

    private boolean downConnection(Level world, BlockPos pos) {
        Block downB = world.m_8055_(pos.m_7495_()).m_60734_();
        return !(downB instanceof LadderBlock) && !(downB instanceof BlockCatwalkLadder) && !(downB instanceof BlockCatwalkHatch) && !(downB instanceof BlockCatwalkStair) && !(downB instanceof StairBlock) && !(downB instanceof TrapDoorBlock);
    }

    protected boolean openCageIf(Level worldIn, BlockPos ownPos) {
        BlockPos downpos = ownPos.m_7495_();
        BlockPos twoDownPos = downpos.m_7495_();
        BlockState downState = worldIn.m_8055_(downpos);
        BlockState twoDownState = worldIn.m_8055_(twoDownPos);
        return !downState.m_60783_((BlockGetter)worldIn, downpos, Direction.UP) && (!(downState.m_60734_() instanceof BlockCatwalkLadder) || (Boolean)downState.m_61143_((Property)ACTIVE) != false || !twoDownState.m_60783_((BlockGetter)worldIn, twoDownPos, Direction.UP));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(this.openCageIf(context.m_43725_(), context.m_8083_())))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(this.downConnection(context.m_43725_(), context.m_8083_())));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighbor, boolean flag) {
        state = (BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(this.openCageIf(world, pos)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(this.downConnection(world, pos)));
        world.m_46597_(pos, state);
        super.m_6861_(state, world, pos, block, neighbor, flag);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state);
    }

    private VoxelShape getVoxelShape(BlockState state) {
        Direction face = (Direction)state.m_61143_((Property)FACING);
        boolean active = (Boolean)state.m_61143_((Property)ACTIVE);
        boolean down = (Boolean)state.m_61143_((Property)DOWN);
        VoxelShape FINAL_SHAPE = NULL_SHAPE;
        if (face == Direction.NORTH) {
            FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)LADDER_SOUTH_AABB);
            if (active) {
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)SOUTH_AABB);
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)EAST_AABB);
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)WEST_AABB);
            }
        } else if (face == Direction.SOUTH) {
            FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)LADDER_NORTH_AABB);
            if (active) {
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)NORTH_AABB);
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)EAST_AABB);
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)WEST_AABB);
            }
        } else if (face == Direction.WEST) {
            FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)LADDER_EAST_AABB);
            if (active) {
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)NORTH_AABB);
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)SOUTH_AABB);
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)EAST_AABB);
            }
        } else {
            FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)LADDER_WEST_AABB);
            if (active) {
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)NORTH_AABB);
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)SOUTH_AABB);
                FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)WEST_AABB);
            }
        }
        if (down) {
            FINAL_SHAPE = Shapes.m_83110_((VoxelShape)FINAL_SHAPE, (VoxelShape)DOWN_AABB);
        }
        return FINAL_SHAPE;
    }
}

