/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.block.abstracts;

import net.cassiokf.industrialrenewal.block.abstracts.BlockAbstractFourConnections;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class BlockAbstractSixWayConnections
extends BlockAbstractFourConnections {
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    private static double UP2 = 16.0;
    private static double DOWN1 = 0.0;

    public BlockAbstractSixWayConnections(BlockBehaviour.Properties properties, float nodeWidth, float nodeHeight, float collisionY) {
        super(properties, nodeWidth, nodeHeight, collisionY);
    }

    public BlockAbstractSixWayConnections(BlockBehaviour.Properties properties, float nodeWidth, float nodeHeight) {
        super(properties, nodeWidth, nodeHeight, 16.0f);
    }

    @Override
    protected BlockState getInitDefaultState() {
        BlockState defaultState = super.getInitDefaultState();
        for (Direction dir : Direction.values()) {
            defaultState = (BlockState)defaultState.m_61124_((Property)this.getPropertyBasedOnDirection(dir), (Comparable)Boolean.valueOf(false));
        }
        return defaultState;
    }

    @Override
    public VoxelShape getVoxelShape(BlockState state, boolean collision) {
        NORTHZ1 = this.isConnected(state, NORTH) ? 0.0 : (double)(8.0f - this.nodeWidth / 2.0f);
        SOUTHZ2 = this.isConnected(state, SOUTH) ? 16.0 : (double)(this.nodeWidth / 2.0f + 8.0f);
        WESTX1 = this.isConnected(state, WEST) ? 0.0 : (double)(8.0f - this.nodeWidth / 2.0f);
        EASTX2 = this.isConnected(state, EAST) ? 16.0 : (double)(this.nodeWidth / 2.0f + 8.0f);
        UP2 = this.isConnected(state, UP) ? 16.0 : (double)(8.0f + this.nodeHeight / 2.0f);
        DOWN1 = this.isConnected(state, DOWN) ? 0.0 : (double)(8.0f - this.nodeHeight / 2.0f);
        return Block.m_49796_((double)WESTX1, (double)DOWN1, (double)NORTHZ1, (double)EASTX2, (double)(collision && this.fenceCollision() ? 24.0 : UP2), (double)SOUTHZ2);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.getInitDefaultState();
        for (Direction face : Direction.values()) {
            state = (BlockState)state.m_61124_((Property)this.getPropertyBasedOnDirection(face), (Comparable)Boolean.valueOf(this.canConnectTo(context.m_43725_(), context.m_8083_(), face)));
        }
        return state;
    }

    @Override
    public BooleanProperty getPropertyBasedOnDirection(Direction direction) {
        switch (direction) {
            default: {
                return DOWN;
            }
            case UP: {
                return UP;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
            case EAST: 
        }
        return EAST;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{UP, DOWN});
    }
}

