/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.block.abstracts;

import net.cassiokf.industrialrenewal.block.abstracts.BlockAbstractNotFullCube;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class BlockAbstractFourConnections
extends BlockAbstractNotFullCube {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static double NORTHZ1 = 4.0;
    public static double SOUTHZ2 = 12.0;
    public static double WESTX1 = 4.0;
    public static double EASTX2 = 12.0;
    public float nodeWidth;
    public float nodeHeight;
    public float collisionY;

    public BlockAbstractFourConnections(BlockBehaviour.Properties properties, float nodeWidth, float nodeHeight, float collisionY) {
        super(properties.m_60955_());
        this.nodeWidth = nodeWidth;
        this.nodeHeight = nodeHeight;
        this.collisionY = collisionY;
    }

    public BlockAbstractFourConnections(BlockBehaviour.Properties props) {
        super(props.m_60955_());
        this.nodeWidth = 16.0f;
        this.nodeHeight = 16.0f;
        this.collisionY = 16.0f;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return this.getVoxelShape(state, false);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter p_60573_, BlockPos p_60574_, CollisionContext p_60575_) {
        return this.getVoxelShape(state, true);
    }

    public VoxelShape getVoxelShape(BlockState state, boolean collision) {
        NORTHZ1 = this.isConnected(state, NORTH) ? 0.0 : (double)(8.0f - this.nodeWidth / 2.0f);
        SOUTHZ2 = this.isConnected(state, SOUTH) ? 16.0 : (double)(this.nodeWidth / 2.0f + 8.0f);
        WESTX1 = this.isConnected(state, WEST) ? 0.0 : (double)(8.0f - this.nodeWidth / 2.0f);
        EASTX2 = this.isConnected(state, EAST) ? 16.0 : (double)(this.nodeWidth / 2.0f + 8.0f);
        return Block.m_49796_((double)WESTX1, (double)(8.0f - this.nodeHeight / 2.0f), (double)NORTHZ1, (double)EASTX2, (double)(collision && this.fenceCollision() ? 24.0 : (double)(8.0f + this.nodeHeight / 2.0f)), (double)SOUTHZ2);
    }

    public boolean fenceCollision() {
        return false;
    }

    public final boolean isConnected(BlockState state, BooleanProperty property) {
        return (Boolean)state.m_61143_((Property)property);
    }

    public BooleanProperty getPropertyBasedOnDirection(Direction direction) {
        switch (direction) {
            default: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
            case EAST: 
        }
        return EAST;
    }

    public abstract boolean canConnectTo(Level var1, BlockPos var2, Direction var3);

    @Override
    protected BlockState getInitDefaultState() {
        return (BlockState)((BlockState)((BlockState)((BlockState)super.getInitDefaultState().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.getInitDefaultState();
        for (Direction face : Direction.Plane.HORIZONTAL) {
            state = (BlockState)state.m_61124_((Property)this.getPropertyBasedOnDirection(face), (Comparable)Boolean.valueOf(this.canConnectTo(context.m_43725_(), context.m_8083_(), face)));
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST});
    }
}

