/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.block.abstracts;

import java.util.List;
import net.cassiokf.industrialrenewal.block.abstracts.Block3x3x3Base;
import net.cassiokf.industrialrenewal.blockentity.abstracts.BlockEntity3x3x2MachineBase;
import net.cassiokf.industrialrenewal.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class Block3x3x2Base<TE extends BlockEntity3x3x2MachineBase>
extends Block3x3x3Base<TE> {
    public Block3x3x2Base(BlockBehaviour.Properties properties) {
        super(properties.m_60913_(10.0f, 10.0f));
    }

    @Override
    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        if (!world.f_46443_) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            boolean isSided = facing == Direction.EAST || facing == Direction.WEST;
            boolean invert = facing == Direction.NORTH || facing == Direction.WEST;
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
            if (this.isValidPosition(world, pos, facing)) {
                world.m_46597_(pos.m_7494_(), (BlockState)state.m_61124_((Property)MASTER, (Comparable)Boolean.valueOf(true)));
                for (int y = 0; y < 3; ++y) {
                    for (int z = 0; z < 2; ++z) {
                        for (int x = -1; x < 2; ++x) {
                            int finalX = isSided ? z : x;
                            int finalZ = isSided ? x : z;
                            BlockPos currentPos = new BlockPos(pos.m_123341_() + (invert ? -finalX : finalX), pos.m_123342_() + y, pos.m_123343_() + (invert ? -finalZ : finalZ));
                            if (x != 0 || y != 1 || z != 0) {
                                world.m_46597_(currentPos, (BlockState)state.m_61124_((Property)MASTER, (Comparable)Boolean.valueOf(false)));
                            }
                            BlockEntity3x3x2MachineBase te = (BlockEntity3x3x2MachineBase)world.m_7702_(currentPos);
                            te.masterPos = new BlockPos(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void m_6786_(LevelAccessor world, BlockPos pos, BlockState state) {
        if (!world.m_5776_()) {
            if (((Boolean)state.m_61143_((Property)MASTER)).booleanValue()) {
                List<BlockPos> blocks = Utils.getBlocksIn3x3x2Centered(pos, (Direction)state.m_61143_((Property)FACING));
                for (BlockPos blockPos : blocks) {
                    world.m_7471_(blockPos, false);
                }
            }
            Block3x3x2Base.m_49840_((Level)((Level)world), (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.m_5456_()));
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean flag) {
        BlockEntity blockentity;
        if (!state.m_60713_(oldState.m_60734_()) && (blockentity = world.m_7702_(pos)) instanceof BlockEntity3x3x2MachineBase) {
            BlockEntity3x3x2MachineBase te = (BlockEntity3x3x2MachineBase)blockentity;
            te.breakMultiBlocks(state);
        }
        super.m_6810_(state, world, pos, oldState, flag);
    }

    @Override
    public boolean isValidPosition(Level worldIn, BlockPos pos, Direction facing) {
        boolean isSided = facing == Direction.EAST || facing == Direction.WEST;
        boolean invert = facing == Direction.NORTH || facing == Direction.WEST;
        for (int y = 0; y < 3; ++y) {
            for (int z = 0; z < 2; ++z) {
                for (int x = -1; x < 2; ++x) {
                    int finalX = isSided ? z : x;
                    int finalZ = isSided ? x : z;
                    BlockPos currentPos = new BlockPos(pos.m_123341_() + (invert ? -finalX : finalX), pos.m_123342_() + y, pos.m_123343_() + (invert ? -finalZ : finalZ));
                    BlockState currentState = worldIn.m_8055_(currentPos);
                    if (currentState.m_247087_()) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

