/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.ber;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.cassiokf.industrialrenewal.ber.BERBase;
import net.cassiokf.industrialrenewal.blockentity.BlockEntityHVIsolator;
import net.cassiokf.industrialrenewal.util.IRRenderType;
import net.cassiokf.industrialrenewal.util.RenderUtil;
import net.cassiokf.industrialrenewal.util.Utils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class BERWire
extends BERBase<BlockEntityHVIsolator> {
    private static final Color c = new Color(56, 56, 56, 255);
    private static final Color c2 = new Color(43, 43, 43, 255);

    public BERWire(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(BlockEntityHVIsolator blockEntity, float partialTick, PoseStack stack, MultiBufferSource buffer, int combinedOverlay, int packedLight) {
        BlockPos source = blockEntity.m_58899_();
        for (BlockPos node : blockEntity.neighbors) {
            this.renderWire(stack, buffer, source, node, blockEntity);
        }
        super.m_6922_(blockEntity, partialTick, stack, buffer, combinedOverlay, packedLight);
    }

    public void renderWire(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, BlockPos startPos, BlockPos endPos, BlockEntity be) {
        float xOffset = 0.5f;
        float zOffset = 0.5f;
        float yOffset = 0.5f;
        Vector3d source = new Vector3d((double)((float)startPos.m_123341_() + xOffset), (double)((float)startPos.m_123342_() + zOffset), (double)((float)startPos.m_123343_() + yOffset));
        Vector3d destination = new Vector3d((double)((float)endPos.m_123341_() + xOffset), (double)((float)endPos.m_123342_() + zOffset), (double)((float)endPos.m_123343_() + yOffset));
        Vector3d midPoint = Utils.midPoint(source, destination, 0.0);
        midPoint = new Vector3d(midPoint.x, Math.min(Math.min(midPoint.y, source.y), destination.y - 0.25), midPoint.z);
        float f = Utils.normalizeClamped(c2.getRed(), 0.0f, 255.0f);
        float f1 = Utils.normalizeClamped(c2.getGreen(), 0.0f, 255.0f);
        float f2 = Utils.normalizeClamped(c2.getBlue(), 0.0f, 255.0f);
        float finalDeltaX = source.y == destination.y ? (float)(midPoint.x - source.x) : (float)(destination.x - source.x);
        float finalDeltaY = source.y == destination.y ? (float)(midPoint.y - source.y) : (float)(destination.y - source.y);
        float finalDeltaZ = source.y == destination.y ? (float)(midPoint.z - source.z) : (float)(destination.z - source.z);
        Vector3f finalStartPos = new Vector3f(xOffset, yOffset, zOffset);
        Vector3f finalEndPos = new Vector3f(finalDeltaX, finalDeltaY, finalDeltaZ);
        finalEndPos.add((Vector3fc)finalStartPos);
        float lerpY = 0.0f;
        if (source.y >= destination.y) {
            int numSegments = 12;
            matrixStack.m_85836_();
            PoseStack.Pose p = matrixStack.m_85850_();
            Level level = be.m_58904_();
            long gameTime = level.m_46467_();
            double v = (double)gameTime * 0.04;
            VertexConsumer builder = renderTypeBuffer.m_6299_(IRRenderType.WIRE_RENDER_TYPE);
            Vector3f startVec = new Vector3f(xOffset, yOffset, zOffset);
            for (int i = 0; i < numSegments; ++i) {
                Vector3f endVec = Utils.lerp(finalStartPos, finalEndPos, (float)(i + 1) / (float)numSegments);
                lerpY = Utils.lerp(lerpY, finalDeltaY, source.y == destination.y ? 0.25f : 0.33f);
                RenderUtil.drawLaser(builder, p.m_252922_(), new Vector3f(endVec.x(), lerpY + yOffset, endVec.z()), startVec, f, f1, f2, 1.0f, 0.025f, v, v + (double)endVec.y() * 1.5, be);
                startVec = new Vector3f(endVec.x(), lerpY + yOffset, endVec.z());
            }
            matrixStack.m_85849_();
        }
    }
}

