/*
 * Decompiled with CFR 0.152.
 */
package net.cassiokf.industrialrenewal.ber;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import net.cassiokf.industrialrenewal.init.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public abstract class BERBase<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    public static final ItemStack cutter = new ItemStack((ItemLike)ModItems.cutter.get());
    public static final ItemStack energyBarLevel = new ItemStack((ItemLike)ModItems.barLevel.get());
    public static final ItemStack pointerLong = new ItemStack((ItemLike)ModItems.pointerLong.get());
    public static final ItemStack pointer = new ItemStack((ItemLike)ModItems.pointer.get());
    public static final ItemStack limiter = new ItemStack((ItemLike)ModItems.limiter.get());
    public static final ItemStack indicator_on = new ItemStack((ItemLike)ModItems.indicator_on.get());
    public static final ItemStack indicator_off = new ItemStack((ItemLike)ModItems.indicator_off.get());
    public static final ItemStack switch_on = new ItemStack((ItemLike)ModItems.switch_on.get());
    public static final ItemStack switch_off = new ItemStack((ItemLike)ModItems.switch_off.get());
    public static final ItemStack push_button = new ItemStack((ItemLike)ModItems.push_button.get());
    public static final ItemStack label_5 = new ItemStack((ItemLike)ModItems.label_5.get());
    public double xPos = 0.0;
    public double zPos = 0.0;

    public BERBase(BlockEntityRendererProvider.Context context) {
    }

    public static void renderScreenTexts(PoseStack matrixStack, MultiBufferSource buffer, Direction facing, double x, double y, double z, String[] text, float spacing, float scale) {
        double lY = y;
        for (String line : text) {
            BERBase.renderText(matrixStack, buffer, facing, x, lY, z, String.valueOf(ChatFormatting.GREEN) + line, scale, false);
            lY -= (double)spacing;
        }
    }

    public static ItemStack getIndicator(boolean value) {
        return value ? indicator_on : indicator_off;
    }

    public static ItemStack getSwitch(boolean value) {
        return value ? switch_on : switch_off;
    }

    public static void renderText(PoseStack poseStack, MultiBufferSource buffer, Direction facing, double x, double y, double z, String st, float scale) {
        BERBase.renderText(poseStack, buffer, facing, x, y, z, st, scale, true);
    }

    private static void renderText(PoseStack poseStack, MultiBufferSource buffer, Direction facing, double x, double y, double z, String st, float scale, boolean centerText) {
        poseStack.m_85836_();
        poseStack.m_85837_(x, y, z);
        BERBase.rotateAccordingly(facing, poseStack);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        poseStack.m_85841_(scale, scale, scale);
        Font font = Minecraft.m_91087_().f_91062_;
        float xh = centerText ? -((float)font.m_92895_(st)) / 2.0f : 0.0f;
        font.m_271703_(st, xh, 0.0f, Color.WHITE.getRGB(), false, poseStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, 255);
        poseStack.m_85849_();
    }

    public static void renderBarLevel(Level level, PoseStack matrixStack, int combinedOverlayIn, MultiBufferSource buffetIn, Direction facing, double x, double y, double z, float fill, float scale) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(x, y, z);
        BERBase.rotateAccordingly(facing, matrixStack);
        matrixStack.m_85841_(scale, fill * scale, 0.05f);
        Minecraft.m_91087_().m_91291_().m_269128_(energyBarLevel, ItemDisplayContext.FIXED, 0xF000F0, combinedOverlayIn, matrixStack, buffetIn, level, 0);
        matrixStack.m_85849_();
    }

    public static void renderPointer(PoseStack matrixStack, int combinedLightIn, int combinedOverlayIn, MultiBufferSource buffetIn, Level level, Direction facing, double x, double y, double z, float angle, ItemStack pointer, float scale) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(x, y, z);
        BERBase.rotateAccordingly(facing, matrixStack);
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(-angle));
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        renderer.m_269128_(pointer, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, buffetIn, level, 0);
        matrixStack.m_85849_();
    }

    public static void render3dItem(PoseStack matrixStack, int combinedLightIn, int combinedOverlayIn, MultiBufferSource buffetIn, Direction facing, Level world, double x, double y, double z, ItemStack stack, float scale, boolean disableLight) {
        BERBase.render3dItem(matrixStack, combinedLightIn, combinedOverlayIn, buffetIn, facing, world, x, y, z, stack, scale, disableLight, false, 0.0f, 0.0f, 0.0f, 0.0f, false, false);
    }

    public static void render3dItem(PoseStack matrixStack, int combinedLightIn, int combinedOverlayIn, MultiBufferSource buffetIn, Direction facing, Level world, double x, double y, double z, ItemStack stack, float scale, boolean disableLight, float rotation, float rX, float rY, float rZ) {
        BERBase.render3dItem(matrixStack, combinedLightIn, combinedOverlayIn, buffetIn, facing, world, x, y, z, stack, scale, disableLight, true, rotation, rX, rY, rZ, false, false);
    }

    public static void render3dItem(PoseStack matrixStack, int combinedLightIn, int combinedOverlayIn, MultiBufferSource buffetIn, Direction facing, Level world, double x, double y, double z, ItemStack stack, float scale, boolean disableLight, boolean applyRotation, float rotation, float rX, float rY, float rZ, boolean rotateHorizontal, boolean rotateVertical) {
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(x, y, z);
        matrixStack.m_85841_(scale, scale, scale);
        BERBase.rotateAccordingly(facing, matrixStack);
        if (rotateHorizontal) {
            matrixStack.m_252781_(new Quaternionf((Quaternionfc)Axis.f_252529_.m_252977_(90.0f)));
        }
        if (rotateVertical) {
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        }
        if (applyRotation) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(rotation * rX));
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(rotation * rY));
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(rotation * rZ));
        }
        BakedModel model = renderer.m_174264_(stack, world, null, 0);
        model = ForgeHooksClient.handleCameraTransforms((PoseStack)matrixStack, (BakedModel)model, (ItemDisplayContext)ItemDisplayContext.NONE, (boolean)false);
        if (applyRotation) {
            renderer.m_115143_(stack, ItemDisplayContext.GROUND, true, matrixStack, buffetIn, combinedLightIn, OverlayTexture.f_118083_, model);
        } else {
            renderer.m_269128_(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStack, buffetIn, world, 1);
        }
        matrixStack.m_85849_();
    }

    public static float smoothAnimation(float rotation, float oldRotation, float partialTick, boolean invert) {
        float r = oldRotation + (rotation - oldRotation) * partialTick;
        return invert ? -r : r;
    }

    public static void rotateAccordingly(Direction facing, PoseStack poseStack) {
        switch (facing) {
            default: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case NORTH: {
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            }
        }
    }

    public static int lighting(BlockEntity blockEntity) {
        Level level = blockEntity.m_58904_();
        BlockPos pos = blockEntity.m_58899_();
        assert (level != null);
        int bLight = level.m_45517_(LightLayer.BLOCK, pos);
        int sLight = level.m_45517_(LightLayer.SKY, pos);
        return LightTexture.m_109885_((int)bLight, (int)sLight);
    }

    public void m_6922_(T blockEntity, float partialTick, PoseStack stack, MultiBufferSource buffer, int combinedOverlay, int packedLight) {
    }

    public void doTheMath(Direction facing, double x, double z, double offset, double sidePlus) {
        switch (facing) {
            case SOUTH: {
                this.xPos = x + (0.5 - sidePlus);
                this.zPos = z + (1.0 - offset);
                break;
            }
            case NORTH: {
                this.xPos = x + (0.5 + sidePlus);
                this.zPos = z + offset;
                break;
            }
            case EAST: {
                this.xPos = x + (1.0 - offset);
                this.zPos = z + (0.5 + sidePlus);
                break;
            }
            case WEST: {
                this.xPos = x + offset;
                this.zPos = z + (0.5 - sidePlus);
            }
        }
    }
}

