/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network.s2c;

import immersive_paintings.network.SegmentedPaintingMessage;
import immersive_paintings.resources.ByteImage;
import immersive_paintings.resources.Cache;
import immersive_paintings.resources.ClientPaintingManager;
import immersive_paintings.resources.Painting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ImageResponse
extends SegmentedPaintingMessage {
    private final String identifier;
    private final Painting.Type type;

    public ImageResponse(ResourceLocation identifier, Painting.Type type, byte[] data, int segment, int totalSegments) {
        super(data, segment, totalSegments);
        this.identifier = identifier.toString();
        this.type = type;
    }

    public ImageResponse(FriendlyByteBuf b) {
        super(b);
        this.identifier = b.m_130277_();
        this.type = (Painting.Type)b.m_130066_(Painting.Type.class);
    }

    @Override
    protected String getIdentifier(Player e) {
        return this.identifier + this.type.name();
    }

    @Override
    protected void process(Player e, ByteImage image) {
        Painting painting = ClientPaintingManager.getPaintings().get(new ResourceLocation(this.identifier));
        Painting.Texture texture = painting.getTexture(this.type);
        texture.image = image;
        ClientPaintingManager.registerImage(texture);
        Cache.set(texture);
    }

    @Override
    public void encode(FriendlyByteBuf b) {
        super.encode(b);
        b.m_130070_(this.identifier);
        b.m_130068_((Enum)this.type);
    }
}

