/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.util;

import com.yellowbrossproductions.illageandspillage.Config;
import com.yellowbrossproductions.illageandspillage.access.LivingEntityAccess;
import com.yellowbrossproductions.illageandspillage.entities.EngineerMachine;
import com.yellowbrossproductions.illageandspillage.entities.EyesoreEntity;
import com.yellowbrossproductions.illageandspillage.entities.FactoryMinion;
import com.yellowbrossproductions.illageandspillage.entities.FunnyboneEntity;
import com.yellowbrossproductions.illageandspillage.entities.IllagerAttack;
import com.yellowbrossproductions.illageandspillage.entities.ImpEntity;
import com.yellowbrossproductions.illageandspillage.entities.RagnoEntity;
import com.yellowbrossproductions.illageandspillage.entities.TrickOrTreatEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.AxeEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.BoneEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.packet.MobFollowingSoundPacket;
import com.yellowbrossproductions.illageandspillage.packet.PacketHandler;
import com.yellowbrossproductions.illageandspillage.packet.ParticlePacket;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class EntityUtil {
    public static boolean displayBossBar(Raider boss) {
        if ((Integer)Config.CommonConfig.bossbar_type.get() == 1) {
            return !boss.m_37886_();
        }
        return (Integer)Config.CommonConfig.bossbar_type.get() == 2;
    }

    public static boolean isEntityCrazyRagno(Entity entity) {
        return entity instanceof RagnoEntity && ((RagnoEntity)entity).isCrazy();
    }

    public static boolean canHurtThisMob(Entity target, Mob attacker) {
        if ((attacker.m_5647_() != null || target.m_5647_() != null) && (EntityUtil.isEntityCrazyRagno(target) || !(target instanceof IllagerAttack) || target instanceof FunnyboneEntity || target instanceof EyesoreEntity || target instanceof TrickOrTreatEntity || target instanceof EngineerMachine || target instanceof FactoryMinion) && !(target instanceof AxeEntity) && !(target instanceof BoneEntity)) {
            return attacker.m_5647_() != target.m_5647_();
        }
        if ((!(target instanceof Raider) || EntityUtil.isEntityCrazyRagno((Entity)attacker)) && (EntityUtil.isEntityCrazyRagno(target) || !(target instanceof IllagerAttack) || target instanceof FunnyboneEntity || target instanceof EyesoreEntity || target instanceof TrickOrTreatEntity || target instanceof EngineerMachine || target instanceof FactoryMinion) && !(target instanceof AxeEntity) && !(target instanceof BoneEntity)) {
            return attacker != target;
        }
        return attacker.m_5448_() == target;
    }

    public static boolean isMobNotOnOtherTeam(Entity target, Mob attacker) {
        if (attacker.m_5647_() == null && target.m_5647_() == null) {
            return true;
        }
        return attacker.m_5647_() == target.m_5647_();
    }

    public static boolean isMobOnOtherTeam2(Entity target, Mob attacker) {
        if (attacker.m_5647_() == null && target.m_5647_() == null) {
            return true;
        }
        return attacker.m_5647_() != target.m_5647_();
    }

    public static void createLineImpsAttack(BlockPos pos, @NotNull LivingEntity attacker, double x, double y, double z, Level level) {
        List list = level.m_6443_(ImpEntity.class, attacker.m_20191_().m_82400_(100.0), predicate -> predicate.getOwner() == attacker);
        if (list.size() < 48) {
            double d0 = Math.min((double)pos.m_123342_(), y);
            double d1 = Math.max((double)pos.m_123342_(), y) + 1.0;
            float f = (float)Mth.m_14136_((double)((double)pos.m_123343_() - z), (double)((double)pos.m_123341_() - x));
            for (int l = 0; l < 16; ++l) {
                double d2 = 1.25 * (double)(l + 1);
                EntityUtil.createSpellEntity(x + (double)Mth.m_14089_((float)f) * d2, z + (double)Mth.m_14031_((float)f) * d2, d0, d1, l, attacker, level);
            }
        }
    }

    private static void createSpellEntity(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, int time, LivingEntity attacker, Level level) {
        BlockPos blockpos = BlockPos.m_274561_((double)p_190876_1_, (double)p_190876_7_, (double)p_190876_3_);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = level.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)level, blockpos1, Direction.UP)) continue;
            if (!level.m_46859_(blockpos) && !(voxelshape = (blockstate1 = level.m_8055_(blockpos)).m_60812_((BlockGetter)level, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)p_190876_5_) - 1);
        if (flag) {
            ImpEntity imp = (ImpEntity)((EntityType)ModEntityTypes.Imp.get()).m_20615_(level);
            assert (imp != null);
            imp.m_6034_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + d0, (double)blockpos.m_123343_() + 0.5);
            imp.setOwner(attacker);
            imp.setWaitTime(time);
            imp.m_6842_(true);
            imp.setPlayerOwned(true);
            if (attacker.m_5647_() != null) {
                level.m_6188_().m_6546_(imp.m_20149_(), level.m_6188_().m_83489_(attacker.m_5647_().m_5758_()));
            }
            level.m_7967_((Entity)imp);
        }
    }

    public static void disableShield(LivingEntity livingEntity, int ticks) {
        if (livingEntity instanceof Player && livingEntity.m_21254_()) {
            ((Player)livingEntity).m_36335_().m_41524_(livingEntity.m_21211_().m_41720_(), ticks);
            livingEntity.m_5810_();
            livingEntity.m_9236_().m_7605_((Entity)livingEntity, (byte)30);
        }
    }

    public static void mobFollowingSound(Level level, Entity entity, SoundEvent sound, float volume, float pitch, boolean loop) {
        if (!level.f_46443_) {
            PacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new MobFollowingSoundPacket(entity.m_19879_(), sound, volume, pitch, loop));
        }
    }

    public static void makeCircleParticles(Level level, LivingEntity spawner, ParticleOptions particleType, int amount, double y, float velocity) {
        if (!level.f_46443_) {
            for (ServerPlayer serverPlayer : ((ServerLevel)level).m_6907_()) {
                if (!(serverPlayer.m_20280_((Entity)spawner) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < amount; ++i) {
                    float TAU = (float)Math.PI * 2;
                    float yaw = (float)i * (TAU / (float)amount);
                    float vy = spawner.m_217043_().m_188501_() * 0.1f - 0.05f;
                    float vx = velocity * Mth.m_14089_((float)yaw);
                    float vz = velocity * Mth.m_14031_((float)yaw);
                    packet.queueParticle(particleType, false, new Vec3(spawner.m_20185_(), spawner.m_20186_() + y, spawner.m_20189_()), new Vec3((double)vx, (double)vy, (double)vz));
                }
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)packet);
            }
        }
    }

    public static void makeWebParticles(Level level, Entity caught) {
        ItemParticleOption particle = new ItemParticleOption(ParticleTypes.f_123752_, Items.f_41863_.m_7968_());
        if (!level.f_46443_) {
            Iterator var4 = ((ServerLevel)level).m_6907_().iterator();
            while (true) {
                if (!var4.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var4.next();
                if (!(serverPlayer.m_20280_(caught) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 2; ++i) {
                    double d0 = (-0.5 + serverPlayer.m_217043_().m_188583_()) / 10.0;
                    double d1 = (-0.5 + serverPlayer.m_217043_().m_188583_()) / 10.0;
                    double d2 = (-0.5 + serverPlayer.m_217043_().m_188583_()) / 10.0;
                    packet.queueParticle((ParticleOptions)particle, false, new Vec3(caught.m_20208_(0.5), caught.m_20187_(), caught.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public static boolean isWebbed(LivingEntity entity) {
        return ((LivingEntityAccess)entity).callIsWebbed();
    }

    public static void setWebbed(LivingEntity entity, boolean isWebbed) {
        ((LivingEntityAccess)entity).callSetWebbed(isWebbed);
    }

    public static boolean isPreserved(LivingEntity entity) {
        return ((LivingEntityAccess)entity).callIsPreserved();
    }

    public static void setPreserved(LivingEntity entity, boolean isPreserved) {
        ((LivingEntityAccess)entity).callSetPreserved(isPreserved);
    }
}

