/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.yellowbrossproductions.illageandspillage.Config;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class JumpscareOverlay {
    private static final ResourceLocation TEXTURE = new ResourceLocation("illageandspillage", "textures/entity/freakager/jumpscare1.png");
    private static final ResourceLocation TEXTURE_OUTLINE = new ResourceLocation("illageandspillage", "textures/entity/freakager/jumpscare2.png");
    public static JumpscareOverlay JUMPSCARE_OVERLAY = new JumpscareOverlay();
    private static final int ANIMATION_APPEAR = 10;
    private static final int ANIMATION_BLINK = 60;
    private static final int ANIMATION_SCARE1 = 20;
    private static final int ANIMATION_BLINK_START = 10;
    private static final int ANIMATION_SCARE_START = 70;
    private static final int ANIMATION_TOTAL = 90;
    private boolean visible = false;
    private float progress = 0.0f;
    private final Random random = new Random();

    public void show() {
        this.visible = true;
    }

    public void clientTick() {
        if (JumpscareOverlay.JUMPSCARE_OVERLAY.visible) {
            JumpscareOverlay.JUMPSCARE_OVERLAY.progress += 1.0f;
            if (JumpscareOverlay.JUMPSCARE_OVERLAY.progress >= 90.0f) {
                JumpscareOverlay.JUMPSCARE_OVERLAY.visible = false;
                JumpscareOverlay.JUMPSCARE_OVERLAY.progress = 0.0f;
            }
        }
    }

    public void render(GuiGraphics guiGraphics, float partialTicks, int screenWidth, int screenHeight) {
        int texH;
        if (!this.visible || !((Boolean)Config.ClientConfig.doJumpscare.get()).booleanValue()) {
            return;
        }
        float time = this.progress + partialTicks;
        if (time >= 90.0f) {
            this.visible = false;
            this.progress = 0.0f;
            return;
        }
        float shakeX = (this.random.nextFloat() * 2.0f - 1.0f) * 5.0f;
        float shakeY = (this.random.nextFloat() * 2.0f - 1.0f) * 5.0f;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        float darkening = 1.0f;
        boolean showOutline = false;
        int blinkstate = 0;
        if (time >= 10.0f) {
            if (time >= 70.0f) {
                blinkstate = 1;
                showOutline = time - 70.0f > 20.0f;
            } else {
                float fade = Math.max(0.0f, (time - 10.0f) / 60.0f);
                float blinkspeed = (float)(1.0 + Math.pow(fade, 3.0));
                blinkstate = Mth.m_14143_((float)(20.0f * blinkspeed)) & 1;
                showOutline = blinkstate == 1;
            }
        }
        int alpha = Mth.m_14143_((float)(darkening * 255.0f));
        guiGraphics.m_280509_(0, 0, screenWidth, screenHeight, alpha << 24);
        if (showOutline) {
            int texW = 2048;
            texH = 1024;
            float scale1 = (float)screenHeight / (float)texH;
            int drawY = 0;
            int drawW = Mth.m_14143_((float)((float)texW * scale1));
            int drawX = (screenWidth - drawW) / 2;
            drawX = (int)((float)drawX + shakeX);
            drawY = (int)((float)drawY + shakeY);
            this.drawScaledOutlineTexture(drawX, drawY, drawW, screenHeight);
        }
        if (blinkstate != 1) {
            int texW = 2048;
            texH = 1024;
            float scaleX = (float)screenWidth / (float)texW;
            float scaleY = (float)screenHeight / (float)texH;
            float scale = Math.max(scaleX, scaleY);
            float timeScale = Math.min(1.0f, (1.0f + time) / 11.0f);
            float drawW = (float)texW * (scale *= timeScale);
            float drawH = (float)texH * scale;
            float drawX = ((float)screenWidth - drawW) / 2.0f + shakeX;
            float drawY = ((float)screenHeight - drawH) / 2.0f + shakeY;
            this.drawScaledTexture(drawX, drawY, drawW, drawH);
        }
        poseStack.m_85849_();
    }

    private void drawScaledTexture(float targetX, float targetY, float targetW, float targetH) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_((double)targetX, (double)(targetY + targetH), -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)(targetX + targetW), (double)(targetY + targetH), -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)(targetX + targetW), (double)targetY, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_5483_((double)targetX, (double)targetY, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawScaledOutlineTexture(float targetX, float targetY, float targetW, float targetH) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_OUTLINE);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_5483_((double)targetX, (double)(targetY + targetH), -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)(targetX + targetW), (double)(targetY + targetH), -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_5483_((double)(targetX + targetW), (double)targetY, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_5483_((double)targetX, (double)targetY, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

