/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities.goal;

import com.yellowbrossproductions.illageandspillage.entities.FactoryMinion;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class FactoryMinionFollowOwnerGoal
extends Goal {
    private final Raider mob;
    private LivingEntity owner;
    private final double followSpeed;
    private final PathNavigation navigator;
    private int timeToRecalcPath;
    private final float minDist;
    private final float maxDist;
    private float oldWaterCost;

    public FactoryMinionFollowOwnerGoal(Raider entityIn, double followSpeed, float minimumDistance, float maximumDistance) {
        this.mob = entityIn;
        this.followSpeed = followSpeed;
        this.navigator = entityIn.m_21573_();
        this.minDist = minimumDistance;
        this.maxDist = maximumDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(entityIn.m_21573_() instanceof GroundPathNavigation) && !(entityIn.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FactoryMinionFollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        FactoryMinion minion;
        Raider raider = this.mob;
        if (raider instanceof FactoryMinion && (minion = (FactoryMinion)raider).getOwner() != null) {
            LivingEntity owner = minion.getOwner().getOwner();
            if (owner == null) {
                return false;
            }
            if (owner.m_5833_()) {
                return false;
            }
            if (this.mob.m_20280_((Entity)owner) <= (double)(this.minDist * this.minDist) || this.mob.m_20280_((Entity)owner) >= (double)(this.maxDist * this.maxDist)) {
                return false;
            }
            if (this.mob.m_5448_() != null) {
                return false;
            }
            this.owner = owner;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.navigator.m_26571_()) {
            return false;
        }
        if (this.mob.m_20280_((Entity)this.owner) <= (double)(this.minDist * this.minDist) || this.mob.m_20280_((Entity)this.owner) >= (double)(this.maxDist * this.maxDist)) {
            return false;
        }
        return this.mob.m_5448_() == null;
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.m_21439_(BlockPathTypes.WATER);
        this.mob.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigator.m_26573_();
        this.mob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.mob.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.mob.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.mob.m_21523_() && !this.mob.m_20159_()) {
                this.navigator.m_5624_((Entity)this.owner, this.followSpeed);
            }
        }
    }
}

