/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.Config;
import com.yellowbrossproductions.illageandspillage.client.model.animation.ICanBeAnimated;
import com.yellowbrossproductions.illageandspillage.client.sound.BossMusicPlayer;
import com.yellowbrossproductions.illageandspillage.entities.CameraShakeEntity;
import com.yellowbrossproductions.illageandspillage.entities.EyesoreEntity;
import com.yellowbrossproductions.illageandspillage.entities.FreakagerEntity;
import com.yellowbrossproductions.illageandspillage.entities.FunnyboneEntity;
import com.yellowbrossproductions.illageandspillage.entities.IllagerAttack;
import com.yellowbrossproductions.illageandspillage.entities.TrickOrTreatEntity;
import com.yellowbrossproductions.illageandspillage.entities.VillagerSoulEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.PumpkinBombEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.WebEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.WebNetEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.packet.PacketHandler;
import com.yellowbrossproductions.illageandspillage.packet.ParticlePacket;
import com.yellowbrossproductions.illageandspillage.particle.ParticleRegisterer;
import com.yellowbrossproductions.illageandspillage.util.DamageTypesRegisterer;
import com.yellowbrossproductions.illageandspillage.util.EffectRegisterer;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import com.yellowbrossproductions.illageandspillage.util.ItemRegisterer;
import com.yellowbrossproductions.illageandspillage.util.PotionRegisterer;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class RagnoEntity
extends Raider
implements ICanBeAnimated {
    public ServerBossEvent bossEvent;
    private static final UUID SPEED_PENALTY_UUID = UUID.fromString("5CD17A52-AB9A-42D3-A629-90FDE04B281E");
    private static final AttributeModifier SPEED_PENALTY;
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID;
    private static final EntityDataAccessor<Integer> ANIMATION_STATE;
    private static final EntityDataAccessor<Boolean> CRAZY;
    private static final EntityDataAccessor<Boolean> BURROWING;
    private static final EntityDataAccessor<Boolean> GRABBING;
    private static final EntityDataAccessor<Integer> STUN_HEALTH;
    private static final EntityDataAccessor<Boolean> STUNNED;
    private static final EntityDataAccessor<Integer> ATTACK_TYPE;
    private static final EntityDataAccessor<Integer> ATTACK_TICKS;
    private static final EntityDataAccessor<Integer> RAGNO_FACE;
    private static final EntityDataAccessor<Integer> SHAKE_MULTIPLIER;
    private static final EntityDataAccessor<Integer> FRAME;
    private static final EntityDataAccessor<Boolean> ANTICHEESE;
    public AnimationState intro1AnimationState = new AnimationState();
    public AnimationState intro2AnimationState = new AnimationState();
    public AnimationState phaseAnimationState = new AnimationState();
    public AnimationState blockAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState webAnimationState = new AnimationState();
    public AnimationState webNetAnimationState = new AnimationState();
    public AnimationState pullInAnimationState = new AnimationState();
    public AnimationState netSlamAnimationState = new AnimationState();
    public AnimationState jumpAnimationState = new AnimationState();
    public AnimationState landAnimationState = new AnimationState();
    public AnimationState leapAnimationState = new AnimationState();
    public AnimationState burrowAnimationState = new AnimationState();
    public AnimationState popupAnimationState = new AnimationState();
    public AnimationState chargeAnimationState = new AnimationState();
    public AnimationState coughAnimationState = new AnimationState();
    public AnimationState stunAnimationState = new AnimationState();
    public AnimationState fallAnimationState = new AnimationState();
    public AnimationState grabAnimationState = new AnimationState();
    public AnimationState breathAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public LivingEntity entityToStareAt;
    private int attackCooldown;
    private final int WEB_ATTACK = 1;
    private final int LEAP_ATTACK = 2;
    private final int BURROW_ATTACK = 3;
    private final int CHARGE_ATTACK = 4;
    private final int COUGH_ATTACK = 5;
    private final int ATTACK_ATTACK = 6;
    private final int JUMP_ATTACK = 7;
    private final int WEB_NET_ATTACK = 8;
    private final int BREATH_ATTACK = 9;
    private final int ANTICHEESE_ATTACK = 10;
    private int webCooldown;
    private int webNetCooldown;
    private int jumpCooldown;
    private int leapCooldown;
    private int burrowCooldown;
    private int chargeCooldown;
    private int coughCooldown;
    private int breathCooldown;
    int introTicks;
    int phaseTicks;
    private Mob owner;
    int blockTicks;
    boolean shouldHurtOnTouch;
    public boolean isPlayingIntro;
    public boolean isPlayingPhase;
    public boolean waitingForWeb;
    public int followupTicks;
    public double chargeX;
    public double chargeZ;
    public boolean circleDirection;
    public int circleTick;
    public int stunTick;
    private boolean hasNotBeenStunned = true;

    public RagnoEntity(EntityType<? extends Raider> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        this.f_21364_ = 40;
        this.bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(((Boolean)Config.CommonConfig.bosses_darken_sky.get()).booleanValue());
        this.bossEvent.m_8321_(false);
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.CommonConfig.ragno_health.get()).doubleValue());
        this.m_5634_(Float.MAX_VALUE);
    }

    public void m_6457_(ServerPlayer p_20119_) {
        super.m_6457_(p_20119_);
        this.bossEvent.m_6543_(p_20119_);
    }

    public void m_6452_(ServerPlayer p_20119_) {
        super.m_6452_(p_20119_);
        this.bossEvent.m_6539_(p_20119_);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new StunGoal());
        this.f_21345_.m_25352_(0, (Goal)new WebGoal());
        this.f_21345_.m_25352_(0, (Goal)new LeapGoal());
        this.f_21345_.m_25352_(0, (Goal)new WebNetGoal());
        this.f_21345_.m_25352_(0, (Goal)new BurrowGoal());
        this.f_21345_.m_25352_(0, (Goal)new ChargeGoal());
        this.f_21345_.m_25352_(0, (Goal)new CoughGoal());
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, predicate -> this.isCrazy() && predicate.m_6097_() && predicate != this && !(predicate instanceof Creeper)));
    }

    public boolean m_7327_(Entity p_21372_) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(RAGNO_FACE, (Object)0);
        this.f_19804_.m_135372_(FRAME, (Object)0);
        this.f_19804_.m_135372_(SHAKE_MULTIPLIER, (Object)0);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(CRAZY, (Object)false);
        this.f_19804_.m_135372_(BURROWING, (Object)false);
        this.f_19804_.m_135372_(GRABBING, (Object)false);
        this.f_19804_.m_135372_(STUN_HEALTH, (Object)this.getMaxStunHealth());
        this.f_19804_.m_135372_(STUNNED, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
        this.f_19804_.m_135372_(ATTACK_TICKS, (Object)0);
        this.f_19804_.m_135372_(ANTICHEESE, (Object)false);
    }

    public boolean m_6779_(LivingEntity target) {
        return (!(target instanceof IllagerAttack) || ((IllagerAttack)target).getOwner() != this) && super.m_6779_(target);
    }

    public float getStepHeight() {
        return 2.0f;
    }

    public boolean isCrazy() {
        return (Boolean)this.f_19804_.m_135370_(CRAZY);
    }

    public void setCrazy(boolean crazy) {
        this.f_19804_.m_135381_(CRAZY, (Object)crazy);
    }

    public boolean isBurrowing() {
        return (Boolean)this.f_19804_.m_135370_(BURROWING);
    }

    public void setBurrowing(boolean burrowing) {
        this.f_19804_.m_135381_(BURROWING, (Object)burrowing);
    }

    public boolean isGrabbing() {
        return (Boolean)this.f_19804_.m_135370_(GRABBING);
    }

    public void setGrabbing(boolean grabbing) {
        this.f_19804_.m_135381_(GRABBING, (Object)grabbing);
    }

    public int getRagnoFace() {
        return (Integer)this.f_19804_.m_135370_(RAGNO_FACE);
    }

    public void setRagnoFace(int face) {
        this.f_19804_.m_135381_(RAGNO_FACE, (Object)face);
    }

    public int getShakeMultiplier() {
        return (Integer)this.f_19804_.m_135370_(SHAKE_MULTIPLIER);
    }

    public void setShakeMultiplier(int shake) {
        this.f_19804_.m_135381_(SHAKE_MULTIPLIER, (Object)shake);
    }

    public int getFrame() {
        return (Integer)this.f_19804_.m_135370_(FRAME);
    }

    public void setFrame(int frame) {
        this.f_19804_.m_135381_(FRAME, (Object)frame);
    }

    public boolean isStunned() {
        return (Boolean)this.f_19804_.m_135370_(STUNNED);
    }

    public void setStunned(boolean stunned) {
        if (stunned && this.hasNotBeenStunned) {
            this.hasNotBeenStunned = false;
        }
        this.f_19804_.m_135381_(STUNNED, (Object)stunned);
    }

    public boolean isAnticheese() {
        return (Boolean)this.f_19804_.m_135370_(ANTICHEESE);
    }

    public void setAnticheese(boolean anticheese) {
        this.f_19804_.m_135381_(ANTICHEESE, (Object)anticheese);
    }

    protected PathNavigation m_6037_(Level p_33802_) {
        return new WallClimberNavigation((Mob)this, p_33802_);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_33820_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = p_33820_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("hasNotBeenStunned", this.hasNotBeenStunned);
        tag.m_128405_("face", this.getRagnoFace());
        tag.m_128405_("shake", this.getShakeMultiplier());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.bossEvent.m_6456_(this.m_5446_());
        if (tag.m_128425_("Health", 99)) {
            this.f_19804_.m_135381_(f_20961_, (Object)Float.valueOf(Mth.m_14036_((float)tag.m_128457_("Health"), (float)0.0f, (float)this.m_21233_())));
        }
        this.hasNotBeenStunned = tag.m_128471_("hasNotBeenStunned");
        this.setRagnoFace(tag.m_128451_("face"));
        this.setShakeMultiplier(tag.m_128451_("shake"));
    }

    public void m_21153_(float p_21154_) {
        float healthValue = p_21154_ - this.m_21223_();
        if (healthValue > 0.0f || this.isCrazy() && !this.isPlayingPhase && !this.isBurrowing() && !this.isGrabbing() || healthValue <= -1.0E12f) {
            if (this.isCrazy() && !this.m_9236_().f_46443_) {
                if (this.m_21223_() + healthValue > this.m_21233_() / 2.0f) {
                    this.setShakeMultiplier(20);
                    this.setRagnoFace(3);
                } else {
                    this.setShakeMultiplier(40);
                    this.setRagnoFace(4);
                }
            }
            super.m_21153_(p_21154_);
        }
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return true;
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    public boolean m_37882_() {
        return (this.isCrazy() || this.phaseTicks > 0) && super.m_37882_();
    }

    public boolean m_6087_() {
        return !this.isBurrowing() && !this.isGrabbing() && !this.isAnticheese() && super.m_6087_();
    }

    public boolean m_6097_() {
        return !this.isBurrowing() && !this.isGrabbing() && !this.isAnticheese() && super.m_6097_();
    }

    public boolean m_5789_() {
        return !this.isBurrowing() && !this.isGrabbing() && !this.isAnticheese() && super.m_5789_();
    }

    public SoundEvent getTransMusic() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_TRANS.get();
    }

    public SoundEvent getBossMusic() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_MUSIC.get();
    }

    protected boolean canPlayMusic() {
        return !this.m_20067_() && this.m_5448_() instanceof Player && this.m_5448_() != null;
    }

    public boolean canPlayerHearMusic(Player player) {
        return player != null && this.m_6779_((LivingEntity)player) && this.m_20270_((Entity)player) < 2500.0f;
    }

    public void m_7822_(byte id) {
        if (id == 67) {
            BossMusicPlayer.playBossMusic(this);
        } else if (id == 68) {
            BossMusicPlayer.stopBossMusic(this);
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_7301_(MobEffectInstance p_21197_) {
        return p_21197_.m_19544_() != EffectRegisterer.MUTATION.get() && super.m_7301_(p_21197_);
    }

    public boolean halfHealth() {
        return this.m_21223_() <= this.m_21233_() / 2.0f;
    }

    public void m_8119_() {
        double deltaZ;
        double d;
        double z2;
        double y;
        List list;
        double z;
        double d2;
        double z22;
        double x2;
        double z3;
        if (this.isPlayingIntro) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
        if (this.owner == null && this.f_19797_ > 5 && !this.isCrazy()) {
            List list2 = this.m_9236_().m_45976_(FreakagerEntity.class, this.m_20191_().m_82400_(2.0));
            if (!list2.isEmpty()) {
                this.owner = (Mob)list2.get(this.f_19796_.m_188503_(list2.size()));
            }
            if (this.owner == null && !this.m_9236_().f_46443_) {
                this.setCrazy(true);
                this.setStunHealth(this.getMaxStunHealth());
                this.setRagnoFace(3);
                this.setShakeMultiplier(20);
            }
        }
        if (EntityUtil.displayBossBar(this) && this.isCrazy() && !this.bossEvent.m_8323_()) {
            this.bossEvent.m_8321_(true);
        }
        if (this.isPlayingIntro) {
            this.m_21573_().m_26573_();
            this.m_21566_().m_24988_(0.0f, 0.0f);
            if (this.entityToStareAt != null) {
                this.m_21563_().m_24960_((Entity)this.entityToStareAt, 100.0f, 100.0f);
            }
            this.m_21566_().m_24988_(0.0f, 0.0f);
            this.f_21344_.m_26573_();
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
        if (this.isPlayingIntro) {
            ++this.introTicks;
            if (this.introTicks - 1 == 11) {
                this.setShakeMultiplier(0);
                this.setAnimationState(11);
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.2f, 0, 10);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.5f);
            }
            if (this.introTicks - 12 == 10) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_ROAR.get(), 3.0f, 1.0f);
            }
            if (this.introTicks - 12 >= 10 && this.introTicks - 12 < 15) {
                this.setShakeMultiplier(this.getShakeMultiplier() + 6);
            }
            if (this.introTicks - 12 == 13) {
                this.setRagnoFace(2);
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.05f, 48, 20);
            }
            if (this.introTicks - 12 == 54) {
                this.setRagnoFace(1);
                this.setShakeMultiplier(10);
            }
            if (this.introTicks - 12 == 73) {
                this.setRagnoFace(0);
            }
            if (this.introTicks - 12 == 90) {
                this.isPlayingIntro = false;
                this.introTicks = 0;
                this.setAnimationState(0);
            }
        }
        if (!(this.getFrame() != 10 || this.isPlayingIntro || this.isPlayingPhase || this.isBurrowing() || this.isGrabbing())) {
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_WEB.get(), 0.5f, this.m_6100_());
            if (this.getRagnoFace() == 0) {
                this.setRagnoFace(1);
            }
        }
        if (this.getFrame() == 12 && this.getRagnoFace() == 1) {
            this.setRagnoFace(0);
        }
        if (this.getFrame() > 12 && !this.isPlayingPhase && this.m_6084_() && this.f_19796_.m_188503_(30) == 0) {
            this.setFrame(0);
        }
        if (!this.m_9236_().f_46443_) {
            this.setFrame(this.getFrame() + 1);
        }
        if (this.getOwner() != null) {
            if (this.getOwner().m_6084_()) {
                this.m_6710_(this.getOwner().m_5448_());
            }
            if (this.getOwner().m_21224_() && this.m_6084_() && this.phaseTicks < 1) {
                if (!this.m_9236_().f_46443_) {
                    this.stopAttacking();
                    this.setStunned(false);
                    this.m_6842_(false);
                    this.setBurrowing(false);
                    this.setAnticheese(false);
                }
                this.isPlayingPhase = true;
                this.setAnimationState(2);
                this.phaseTicks = 1;
            }
        }
        if (!this.m_9236_().f_46443_ && (this.phaseTicks >= 27 || this.isCrazy()) && this.getBossMusic() != null) {
            if (this.canPlayMusic()) {
                this.m_9236_().m_7605_((Entity)this, (byte)67);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)68);
            }
        }
        if (!(this.getAttackType() > 0 || this.isPlayingIntro || this.isPlayingPhase || this.isStunned())) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22130_(SPEED_PENALTY);
        } else {
            AttributeInstance speedAttribute = this.m_21051_(Attributes.f_22279_);
            assert (speedAttribute != null);
            speedAttribute.m_22130_(SPEED_PENALTY);
            speedAttribute.m_22118_(SPEED_PENALTY);
        }
        if (this.f_19796_.m_188503_(200) == 0) {
            this.circleDirection = !this.circleDirection;
        }
        this.circleTick += this.circleDirection ? 1 : -1;
        if (this.stunTick > 0) {
            this.m_21573_().m_26573_();
            this.f_21344_.m_26573_();
        }
        this.stopAttackersFromAttacking();
        if (this.blockTicks > 0) {
            --this.blockTicks;
        }
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(this.f_19862_);
        }
        if (this.phaseTicks > 0 && this.m_6084_()) {
            ++this.phaseTicks;
        }
        if (this.phaseTicks == 20 || this.phaseTicks == 30 || this.phaseTicks == 63 || this.phaseTicks == 69) {
            this.m_5496_(SoundEvents.f_12314_, 2.0f, 1.0f);
        }
        if (this.phaseTicks == 40 || this.phaseTicks == 77) {
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_BLOCK.get(), 2.0f, 1.0f);
        }
        if (this.phaseTicks == 116) {
            if (!this.m_9236_().f_46443_) {
                this.setCrazy(true);
                this.setRagnoFace(3);
                this.setShakeMultiplier(20);
            }
            List eyesores = this.m_9236_().m_6443_(EyesoreEntity.class, this.m_20191_().m_82400_(50.0), predicate -> predicate.getOwner() == this.getOwner());
            for (EyesoreEntity eyesore : eyesores) {
                eyesore.setScared(true);
            }
            CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.1f, 0, 20);
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.0f);
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_LEAP.get(), 2.0f, 1.0f);
            if (!this.m_9236_().f_46443_) {
                float radius2 = 2.0f;
                double x = this.m_20185_() + (double)0.8f * Math.sin((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.sin((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                z3 = this.m_20189_() + (double)0.8f * Math.cos((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.cos((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                Iterator list3 = this.m_9236_().m_45976_(LivingEntity.class, new AABB(x - 2.0, this.m_20186_(), z3 - 2.0, x + 2.0, this.m_20186_() + 2.0, z3 + 2.0));
                Iterator iterator = list3.iterator();
                while (iterator.hasNext()) {
                    LivingEntity entity = (LivingEntity)iterator.next();
                    if (!EntityUtil.canHurtThisMob((Entity)entity, (Mob)this) || !entity.m_6084_()) continue;
                    x2 = this.m_20185_() - entity.m_20185_();
                    double y2 = this.m_20186_() - entity.m_20186_();
                    z22 = this.m_20189_() - entity.m_20189_();
                    d2 = Math.sqrt(x2 * x2 + y2 * y2 + z22 * z22);
                    if (!RagnoEntity.isMobNotInCreativeMode((Entity)entity)) continue;
                    entity.f_19864_ = true;
                    entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 15.0f);
                    entity.m_20256_(entity.m_20184_().m_82520_(-x2 / d2 * 5.0 - entity.m_21133_(Attributes.f_22278_), -y2 / d2 * 0.3 - entity.m_21133_(Attributes.f_22278_), -z22 / d2 * 5.0 - entity.m_21133_(Attributes.f_22278_)));
                    if (!entity.m_21254_()) continue;
                    EntityUtil.disableShield(entity, 100);
                }
            }
        }
        if (this.phaseTicks == 140) {
            CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.05f, 0, 30);
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.5f);
            if (!this.m_9236_().f_46443_) {
                float radius2 = 2.0f;
                double x = this.m_20185_() + (double)0.8f * Math.sin((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.sin((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                z = this.m_20189_() + (double)0.8f * Math.cos((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.cos((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                list = this.m_9236_().m_45976_(LivingEntity.class, new AABB(x - 2.0, this.m_20186_(), z - 2.0, x + 2.0, this.m_20186_() + 2.0, z + 2.0));
                for (LivingEntity entity : list) {
                    if (!EntityUtil.canHurtThisMob((Entity)entity, (Mob)this) || !entity.m_6084_()) continue;
                    double x22 = this.m_20185_() - entity.m_20185_();
                    y = this.m_20186_() - entity.m_20186_();
                    z2 = this.m_20189_() - entity.m_20189_();
                    d = Math.sqrt(x22 * x22 + y * y + z2 * z2);
                    if (!RagnoEntity.isMobNotInCreativeMode((Entity)entity)) continue;
                    entity.f_19864_ = true;
                    entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 10.0f);
                    entity.m_20256_(entity.m_20184_().m_82520_(-x22 / d * 5.0 - entity.m_21133_(Attributes.f_22278_), -y / d * 0.3 - entity.m_21133_(Attributes.f_22278_), -z2 / d * 5.0 - entity.m_21133_(Attributes.f_22278_)));
                    if (!entity.m_21254_()) continue;
                    EntityUtil.disableShield(entity, 100);
                }
            }
        }
        if (this.phaseTicks == 151 || this.phaseTicks == 161) {
            CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.05f, 0, 30);
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.4f);
            if (!this.m_9236_().f_46443_) {
                float radius2 = 2.0f;
                double x = this.m_20185_() + (double)0.8f * Math.sin((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.sin((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                z = this.m_20189_() + (double)0.8f * Math.cos((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.cos((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                list = this.m_9236_().m_45976_(LivingEntity.class, new AABB(x - 2.0, this.m_20186_(), z - 2.0, x + 2.0, this.m_20186_() + 2.0, z + 2.0));
                for (LivingEntity entity : list) {
                    if (!EntityUtil.canHurtThisMob((Entity)entity, (Mob)this) || !entity.m_6084_()) continue;
                    double x23 = this.m_20185_() - entity.m_20185_();
                    y = this.m_20186_() - entity.m_20186_();
                    z2 = this.m_20189_() - entity.m_20189_();
                    d = Math.sqrt(x23 * x23 + y * y + z2 * z2);
                    if (!RagnoEntity.isMobNotInCreativeMode((Entity)entity)) continue;
                    entity.f_19864_ = true;
                    entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 10.0f);
                    entity.m_20256_(entity.m_20184_().m_82520_(-x23 / d * 5.0 - entity.m_21133_(Attributes.f_22278_), -y / d * 0.3 - entity.m_21133_(Attributes.f_22278_), -z2 / d * 5.0 - entity.m_21133_(Attributes.f_22278_)));
                    if (!entity.m_21254_()) continue;
                    EntityUtil.disableShield(entity, 100);
                }
            }
        }
        if (this.phaseTicks == 183) {
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_PREPARECHARGE.get(), 2.0f, 1.0f);
        }
        if (this.phaseTicks == 206) {
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_LEAP.get(), 2.0f, 1.0f);
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_COUGH.get(), 2.0f, 1.0f);
        }
        if (this.phaseTicks == 223) {
            this.m_5496_(SoundEvents.f_243713_, 3.0f, 1.0f);
        }
        if (this.phaseTicks == 250) {
            this.isPlayingPhase = false;
            this.setStunHealth(this.getMaxStunHealth());
            this.setAttackTicks(0);
            this.setAttackType(0);
            this.setAnimationState(0);
            List eyesores = this.m_9236_().m_6443_(EyesoreEntity.class, this.m_20191_().m_82400_(50.0), predicate -> predicate.getOwner() == this.getOwner());
            for (EyesoreEntity eyesore : eyesores) {
                eyesore.setScared(false);
            }
        }
        if (this.getAttackType() > 0) {
            this.setAttackTicks(this.getAttackTicks() + 1);
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.getAttackType() < 1) {
            if (this.webCooldown > 0) {
                --this.webCooldown;
            }
            if (this.webNetCooldown > 0) {
                --this.webNetCooldown;
            }
            if (this.jumpCooldown > 0) {
                --this.jumpCooldown;
            }
            if (this.leapCooldown > 0) {
                --this.leapCooldown;
            }
            if (this.burrowCooldown > 0) {
                --this.burrowCooldown;
            }
            if (this.chargeCooldown > 0) {
                --this.chargeCooldown;
            }
            if (this.coughCooldown > 0) {
                --this.coughCooldown;
            }
            if (this.breathCooldown > 0) {
                --this.breathCooldown;
            }
        }
        if (this.m_6084_()) {
            double motionZ;
            double deltaY;
            double deltaX;
            double targetZ;
            double motionZ2;
            double motionY;
            double y3;
            double motionZ3;
            double motionY2;
            double motionX;
            double distance;
            if (this.canUseBreath() || this.getAttackType() == 9) {
                this.m_21573_().m_26573_();
                this.m_21566_().m_24988_(0.0f, 0.0f);
                if (this.m_5448_() != null && !this.isGrabbing()) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 100.0f, 100.0f);
                }
                this.m_21566_().m_24988_(0.0f, 0.0f);
                this.f_21344_.m_26573_();
                if (this.getAttackTicks() == 0) {
                    this.setAnimationState(18);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_PREPARECHARGE.get(), 2.0f, 0.9f);
                    this.setAttackType(this.BREATH_ATTACK);
                }
                if (this.getAttackTicks() == 30) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_BLOCK.get(), 2.0f, 1.0f);
                    if (!this.m_9236_().f_46443_) {
                        float radius2 = 2.0f;
                        double x = this.m_20185_() + (double)0.8f * Math.sin((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.sin((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                        z = this.m_20189_() + (double)0.8f * Math.cos((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.cos((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                        list = this.m_9236_().m_6443_(LivingEntity.class, new AABB(x - 2.0, this.m_20186_(), z - 2.0, x + 2.0, this.m_20186_() + 2.0, z + 2.0), predicate -> EntityUtil.canHurtThisMob((Entity)predicate, (Mob)this) && RagnoEntity.isMobNotInCreativeMode((Entity)predicate));
                        for (LivingEntity entity : list) {
                            entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 2.0f);
                            if (this.isGrabbing() || !entity.m_6084_() || !entity.m_7998_((Entity)this, true)) continue;
                            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_LEAP.get(), 2.0f, this.m_6100_());
                            this.setGrabbing(true);
                        }
                    }
                }
                if (this.getAttackTicks() == 40 && this.isGrabbing()) {
                    this.setAnimationState(19);
                }
                if (this.getAttackTicks() == 53) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SCREECH.get(), 2.0f, 0.75f);
                    CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.05f, 48, 20);
                }
                if (this.getAttackTicks() >= 53 && this.getAttackTicks() <= 109) {
                    this.makeBreath();
                }
                if (this.getAttackTicks() == 109 && !this.m_20197_().isEmpty()) {
                    this.m_20197_().forEach(Entity::m_8127_);
                }
                if (this.isGrabbing() ? this.getAttackTicks() > 125 : this.getAttackTicks() > 45) {
                    this.setAnimationState(0);
                    this.setAttackTicks(0);
                    this.setAttackType(0);
                    this.loseStunHealth(this.isGrabbing() ? 10 : 5, false);
                    this.setGrabbing(false);
                    this.breathCooldown = 100;
                    this.attackCooldown = 20;
                }
            }
            if (this.getAttackType() == this.WEB_ATTACK && this.isCrazy()) {
                LivingEntity entity = this.m_5448_();
                if (this.getAttackTicks() == 4) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.5, 0.0));
                }
                if (this.getAttackTicks() == 7 && entity != null) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_WEB.get(), 2.0f, 1.0f);
                    for (int i = 0; i < 8; ++i) {
                        if (this.m_9236_().f_46443_) continue;
                        WebEntity projectile = (WebEntity)((EntityType)ModEntityTypes.Web.get()).m_20615_(this.m_9236_());
                        assert (projectile != null);
                        projectile.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                        projectile.m_5616_(this.m_6080_());
                        projectile.m_146922_(this.m_6080_());
                        double x = projectile.m_20185_() - entity.m_20185_();
                        double y4 = projectile.m_20186_() - (entity.m_20186_() + 1.5);
                        double z4 = projectile.m_20189_() - entity.m_20189_();
                        distance = Math.sqrt(x * x + y4 * y4 + z4 * z4);
                        float power = 2.5f;
                        motionX = -(x / distance * (double)power * 0.2);
                        motionY2 = -(y4 / distance * (double)power * 0.2);
                        motionZ3 = -(z4 / distance * (double)power * 0.2);
                        double randomX = (-0.5 + this.f_19796_.m_188500_()) / 8.0;
                        double randomY = (-0.5 + this.f_19796_.m_188500_()) / 8.0;
                        double randomZ = (-0.5 + this.f_19796_.m_188500_()) / 8.0;
                        projectile.setAcceleration(motionX + randomX, motionY2 + randomY, motionZ3 + randomZ);
                        projectile.setShooter((Mob)this);
                        this.m_9236_().m_7967_((Entity)projectile);
                    }
                }
                if (this.getAttackTicks() == 10) {
                    this.m_20334_(0.0, -1.0, 0.0);
                }
            }
            if (!this.isCrazy() && (this.doesAttackMeetNormalRequirements() && this.f_19796_.m_188503_(16) == 0 && this.webCooldown < 1 || this.getAttackType() == this.WEB_ATTACK)) {
                if (this.getAttackTicks() == 0) {
                    this.setAnimationState(4);
                    this.setAttackType(this.WEB_ATTACK);
                }
                this.m_21573_().m_26573_();
                this.m_21566_().m_24988_(0.0f, 0.0f);
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 100.0f, 100.0f);
                }
                this.m_21566_().m_24988_(0.0f, 0.0f);
                this.f_21344_.m_26573_();
                if (this.getAttackTicks() == 7 && this.m_5448_() != null) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_WEB.get(), 2.0f, 1.0f);
                    for (int i = 0; i < 8; ++i) {
                        if (this.m_9236_().f_46443_) continue;
                        WebEntity projectile = (WebEntity)((EntityType)ModEntityTypes.Web.get()).m_20615_(this.m_9236_());
                        assert (projectile != null);
                        projectile.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                        projectile.m_5616_(this.m_6080_());
                        projectile.m_146922_(this.m_6080_());
                        double x = projectile.m_20185_() - this.m_5448_().m_20185_();
                        y3 = projectile.m_20186_() - (this.m_5448_().m_20186_() + 1.5);
                        double z5 = projectile.m_20189_() - this.m_5448_().m_20189_();
                        double distance2 = Math.sqrt(x * x + y3 * y3 + z5 * z5);
                        float power = 2.5f;
                        double motionX2 = -(x / distance2 * (double)power * 0.2);
                        motionY = -(y3 / distance2 * (double)power * 0.2);
                        motionZ2 = -(z5 / distance2 * (double)power * 0.2);
                        double randomX = (-0.5 + this.f_19796_.m_188500_()) / 8.0;
                        double randomY = (-0.5 + this.f_19796_.m_188500_()) / 8.0;
                        double randomZ = (-0.5 + this.f_19796_.m_188500_()) / 8.0;
                        projectile.setAcceleration(motionX2 + randomX, motionY + randomY, motionZ2 + randomZ);
                        projectile.setShooter((Mob)this);
                        this.m_9236_().m_7967_((Entity)projectile);
                    }
                }
                if (this.getAttackTicks() > 20) {
                    this.setAnimationState(0);
                    this.setAttackTicks(0);
                    this.setAttackType(0);
                    this.webCooldown = 200;
                }
            }
            if (this.getAttackType() == this.WEB_NET_ATTACK) {
                LivingEntity entity = this.m_5448_();
                if (this.getAttackTicks() == 15 && entity != null) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_WEB.get(), 2.0f, 1.0f);
                    this.waitingForWeb = true;
                    WebNetEntity webNet = (WebNetEntity)((EntityType)ModEntityTypes.WebNet.get()).m_20615_(this.m_9236_());
                    assert (webNet != null);
                    webNet.m_6034_(this.m_20185_(), this.m_20186_() + 1.5, this.m_20189_());
                    webNet.m_5616_(this.m_6080_());
                    webNet.m_146922_(this.m_6080_());
                    double x = webNet.m_20185_() - entity.m_20185_();
                    y3 = webNet.m_20186_() - (entity.m_20186_() + 1.0);
                    double z6 = webNet.m_20189_() - entity.m_20189_();
                    double d3 = Math.sqrt(x * x + y3 * y3 + z6 * z6);
                    float power = 10.0f;
                    double motionX3 = -(x / d3 * (double)power * 0.2);
                    motionY = -(y3 / d3 * (double)power * 0.2);
                    motionZ2 = -(z6 / d3 * (double)power * 0.2);
                    webNet.setAcceleration(motionX3, motionY, motionZ2);
                    if (!this.m_9236_().f_46443_) {
                        float radius2 = -2.0f;
                        double x24 = this.m_20185_() + (double)0.8f * Math.sin((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.sin((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                        double z23 = this.m_20189_() + (double)0.8f * Math.cos((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.cos((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                        webNet.setAttachPoint(x24, this.m_20186_() + 1.0, z23);
                    }
                    webNet.setShooter((LivingEntity)this);
                    this.m_9236_().m_7967_((Entity)webNet);
                }
                if (this.followupTicks == 1) {
                    this.setAnimationState(17);
                }
                if (this.followupTicks > 0) {
                    ++this.followupTicks;
                }
                if (this.followupTicks == 7) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.5f);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_LEAP.get(), 2.0f, this.m_6100_());
                    CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.2f, 0, 30);
                    if (!this.m_9236_().f_46443_) {
                        float radius2 = 2.0f;
                        double x = this.m_20185_() + (double)0.8f * Math.sin((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.sin((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                        z3 = this.m_20189_() + (double)0.8f * Math.cos((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.cos((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                        List list4 = this.m_9236_().m_45976_(LivingEntity.class, new AABB(x - 5.0, this.m_20186_(), z3 - 5.0, x + 5.0, this.m_20186_() + 5.0, z3 + 5.0));
                        for (LivingEntity entity2 : list4) {
                            if (!EntityUtil.canHurtThisMob((Entity)entity2, (Mob)this) || !entity2.m_6084_()) continue;
                            x2 = this.m_20185_() - entity2.m_20185_();
                            double y5 = this.m_20186_() - entity2.m_20186_();
                            z22 = this.m_20189_() - entity2.m_20189_();
                            d2 = Math.sqrt(x2 * x2 + y5 * y5 + z22 * z22);
                            if (!RagnoEntity.isMobNotInCreativeMode((Entity)entity2)) continue;
                            entity2.f_19864_ = true;
                            entity2.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 20.0f);
                            entity2.m_20256_(entity2.m_20184_().m_82520_(-x2 / d2 * 5.0 - entity2.m_21133_(Attributes.f_22278_), -y5 / d2 * 2.0 - entity2.m_21133_(Attributes.f_22278_), -z22 / d2 * 5.0 - entity2.m_21133_(Attributes.f_22278_)));
                            if (!entity2.m_21254_()) continue;
                            entity2.m_21211_().m_41622_(60, entity2, p_289501_ -> p_289501_.m_21190_(entity2.m_7655_()));
                            EntityUtil.disableShield(entity2, 400);
                        }
                    }
                }
            }
            if (this.getAttackType() == this.LEAP_ATTACK) {
                LivingEntity target = this.m_5448_();
                double targetX = 0.0;
                double motionY3 = 0.0;
                double targetZ2 = 0.0;
                if (target != null) {
                    double deltaX2 = this.m_20185_() - target.m_20185_();
                    double deltaY2 = this.m_20186_() - (target.m_20186_() + 1.5);
                    double deltaZ2 = this.m_20189_() - target.m_20189_();
                    double distance3 = Math.sqrt(deltaX2 * deltaX2 + deltaY2 * deltaY2 + deltaZ2 * deltaZ2);
                    float power = 10.0f;
                    targetX = -(deltaX2 / distance3 * (double)power * 0.2);
                    motionY3 = -(deltaY2 / distance3 * (double)power * 0.06);
                    targetZ2 = -(deltaZ2 / distance3 * (double)power * 0.2);
                }
                if (this.getAttackTicks() == 19) {
                    this.m_5496_(SoundEvents.f_12314_, 2.0f, 0.9f);
                }
                if (this.getAttackTicks() == 27) {
                    this.m_5496_(SoundEvents.f_12314_, 2.0f, 0.9f);
                }
                if (this.getAttackTicks() == 37) {
                    this.shouldHurtOnTouch = true;
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_LEAP.get(), 2.0f, this.m_6100_());
                    this.m_20334_(targetX, motionY3 > 0.0 ? motionY3 + 0.2 : 0.2, targetZ2);
                }
                if (this.shouldHurtOnTouch) {
                    for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                        if (!EntityUtil.canHurtThisMob(entity, (Mob)this) || !(entity instanceof LivingEntity) || !entity.m_6084_() || (entity instanceof TrickOrTreatEntity || entity instanceof FunnyboneEntity || entity instanceof EyesoreEntity) && entity.f_19797_ <= 20) continue;
                        double deltaX3 = this.m_20185_() - entity.m_20185_();
                        double deltaY3 = this.m_20186_() - entity.m_20186_();
                        double deltaZ3 = this.m_20189_() - entity.m_20189_();
                        double distance4 = Math.sqrt(deltaX3 * deltaX3 + deltaY3 * deltaY3 + deltaZ3 * deltaZ3);
                        if (!(this.m_20280_(entity) < 9.0)) continue;
                        if (entity.f_19802_ <= 0) {
                            this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                            entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
                            entity.f_19864_ = true;
                            entity.m_20334_(-deltaX3 / distance4 * 2.0, -deltaY3 / distance4 * 2.0 + 0.5, -deltaZ3 / distance4 * 2.0);
                        }
                        if (!((LivingEntity)entity).m_21254_()) continue;
                        EntityUtil.disableShield((LivingEntity)entity, 100);
                    }
                }
            }
            if ((!this.isCrazy() && this.getOwner() instanceof FreakagerEntity && ((FreakagerEntity)this.getOwner()).halfHealth() || this.isCrazy() && this.halfHealth()) && (this.doesAttackMeetNormalRequirements() && this.m_217043_().m_188503_(16) == 0 && this.jumpCooldown < 1 || this.getAttackType() == 7)) {
                double deltaY4;
                if (this.getAttackTicks() == 0) {
                    this.setAttackType(7);
                    this.setAnimationState(14);
                }
                this.m_21573_().m_26573_();
                this.m_21566_().m_24988_(0.0f, 0.0f);
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 100.0f, 100.0f);
                }
                this.m_21566_().m_24988_(0.0f, 0.0f);
                this.f_21344_.m_26573_();
                if (this.getAttackTicks() == 7 && this.m_5448_() != null) {
                    this.m_5496_(SoundEvents.f_12314_, 2.0f, 1.0f);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_LEAP.get(), 2.0f, this.m_6100_());
                    if (this.isCrazy()) {
                        this.m_20334_((this.m_5448_().m_20185_() - this.m_20185_()) * 0.15, 1.5, (this.m_5448_().m_20189_() - this.m_20189_()) * 0.15);
                    } else if (this.m_20280_((Entity)this.m_5448_()) <= 100.0) {
                        this.m_20334_((-4.0 + this.f_19796_.m_188500_() * 3.0) * 1.1, 1.5, (-4.0 + this.f_19796_.m_188500_() * 3.0) * 1.1);
                    } else {
                        double deltaX4 = this.m_20185_() - this.m_5448_().m_20185_();
                        double deltaY5 = this.m_20186_() - this.m_5448_().m_20186_();
                        deltaZ = this.m_20189_() - this.m_5448_().m_20189_();
                        double distance5 = Math.sqrt(deltaX4 * deltaX4 + deltaY5 * deltaY5 + deltaZ * deltaZ);
                        float power = 18.0f;
                        double motionX4 = -(deltaX4 / distance5 * (double)power * 0.2);
                        double motionZ4 = -(deltaZ / distance5 * (double)power * 0.2);
                        this.m_20334_(motionX4 + (-2.0 + this.f_19796_.m_188500_() * 5.0) * 1.1, 1.5, motionZ4 + (-2.0 + this.f_19796_.m_188500_() * 5.0) * 1.1);
                    }
                }
                if (this.getAttackTicks() >= 7) {
                    for (Entity hit : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                        if (!EntityUtil.canHurtThisMob(hit, (Mob)this) || !(hit instanceof LivingEntity) || !hit.m_6084_() || hit == this || (hit instanceof TrickOrTreatEntity || hit instanceof FunnyboneEntity || hit instanceof EyesoreEntity) && hit.f_19797_ <= 20) continue;
                        double deltaX5 = this.m_20185_() - hit.m_20185_();
                        deltaY4 = this.m_20186_() - hit.m_20186_();
                        double deltaZ4 = this.m_20189_() - hit.m_20189_();
                        double distance6 = Math.sqrt(deltaX5 * deltaX5 + deltaY4 * deltaY4 + deltaZ4 * deltaZ4);
                        if (!(this.m_20280_(hit) < 9.0) || hit.f_19802_ > 0) continue;
                        this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                        hit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
                        hit.f_19864_ = true;
                        hit.m_20334_(-deltaX5 / distance6 * 2.0, -deltaY4 / distance6 * 2.0 + 1.2, -deltaZ4 / distance6 * 2.0);
                        hit.m_6001_(-deltaX5 / distance6 * 2.0, -deltaY4 / distance6 * 2.0 + 1.2, -deltaZ4 / distance6 * 2.0);
                    }
                }
                if (this.getAttackTicks() > 8 && this.m_20096_()) {
                    for (Entity hit : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                        if (!EntityUtil.canHurtThisMob(hit, (Mob)this) || !(hit instanceof LivingEntity) || !hit.m_6084_() || hit == this) continue;
                        double deltaX6 = this.m_20185_() - hit.m_20185_();
                        deltaY4 = this.m_20186_() - hit.m_20186_();
                        double deltaZ5 = this.m_20189_() - hit.m_20189_();
                        double distance7 = Math.sqrt(deltaX6 * deltaX6 + deltaY4 * deltaY4 + deltaZ5 * deltaZ5);
                        if (!(this.m_20280_(hit) < 36.0) || hit.f_19802_ > 0) continue;
                        this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                        hit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
                        hit.f_19864_ = true;
                        hit.m_20334_(-deltaX6 / distance7 * 2.0, -deltaY4 / distance7 * 2.0 + 1.2, -deltaZ5 / distance7 * 2.0);
                        hit.m_6001_(-deltaX6 / distance7 * 2.0, -deltaY4 / distance7 * 2.0 + 1.2, -deltaZ5 / distance7 * 2.0);
                    }
                    CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.05f, 0, 30);
                    EntityUtil.makeCircleParticles(this.m_9236_(), (LivingEntity)this, (ParticleOptions)ParticleTypes.f_123755_, 100, 1.0, 1.0f);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.5f);
                    this.setAnimationState(15);
                    this.setAttackTicks(0);
                    if (this.isCrazy()) {
                        this.loseStunHealth(5, false);
                    }
                    this.attackCooldown = 10;
                    this.jumpCooldown = 80;
                    this.setAttackType(0);
                }
                if (this.getAttackTicks() > 107 && this.getAttackType() == 7) {
                    this.setAnimationState(0);
                    this.setAttackTicks(0);
                    if (this.isCrazy()) {
                        this.loseStunHealth(5, false);
                    }
                    this.attackCooldown = 10;
                    this.jumpCooldown = 80;
                    this.setAttackType(0);
                }
            }
            if (!this.isCrazy() && (this.doesAttackMeetNormalRequirements() && this.m_20280_((Entity)this.m_5448_()) < 49.0 || this.getAttackType() == 6)) {
                if (this.getAttackTicks() == 0) {
                    this.setAttackType(6);
                    this.setAnimationState(12);
                }
                this.m_21573_().m_26573_();
                this.m_21566_().m_24988_(0.0f, 0.0f);
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 100.0f, 100.0f);
                }
                this.m_21566_().m_24988_(0.0f, 0.0f);
                this.f_21344_.m_26573_();
                if (this.getAttackTicks() == 4) {
                    this.m_5496_(SoundEvents.f_12314_, 2.0f, 1.0f);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_LEAP.get(), 1.0f, this.m_6100_());
                    if (!this.m_9236_().f_46443_) {
                        float radius2 = 2.0f;
                        double x = this.m_20185_() + (double)0.8f * Math.sin((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.sin((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                        z = this.m_20189_() + (double)0.8f * Math.cos((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.cos((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                        List list5 = this.m_9236_().m_45976_(LivingEntity.class, new AABB(x - 2.0, this.m_20186_(), z - 2.0, x + 2.0, this.m_20186_() + 2.0, z + 2.0));
                        for (LivingEntity entity : list5) {
                            if (!EntityUtil.canHurtThisMob((Entity)entity, (Mob)this) || !entity.m_6084_()) continue;
                            double x25 = this.m_20185_() - entity.m_20185_();
                            double y6 = this.m_20186_() - entity.m_20186_();
                            z2 = this.m_20189_() - entity.m_20189_();
                            d = Math.sqrt(x25 * x25 + y6 * y6 + z2 * z2);
                            if (!RagnoEntity.isMobNotInCreativeMode((Entity)entity)) continue;
                            entity.f_19864_ = true;
                            entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 6.0f);
                            entity.m_20256_(entity.m_20184_().m_82520_(-x25 / d * 5.0 - entity.m_21133_(Attributes.f_22278_), -y6 / d * 0.3 - entity.m_21133_(Attributes.f_22278_), -z2 / d * 5.0 - entity.m_21133_(Attributes.f_22278_)));
                            if (!entity.m_21254_()) continue;
                            EntityUtil.disableShield(entity, 100);
                        }
                    }
                }
                if (this.getAttackTicks() > 10) {
                    this.setAnimationState(0);
                    this.setAttackTicks(0);
                    this.attackCooldown = 25;
                    this.setAttackType(0);
                }
            }
            if (!this.isPlayingIntro && !this.isPlayingPhase && !this.isCrazy() && this.isStunned()) {
                if (this.stunTick == 1) {
                    this.setAnimationState(13);
                }
                this.m_21573_().m_26573_();
                this.m_21566_().m_24988_(0.0f, 0.0f);
                if (this.m_5448_() != null && this.isCrazy()) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 100.0f, 100.0f);
                }
                this.m_21566_().m_24988_(0.0f, 0.0f);
                this.f_21344_.m_26573_();
                if (this.stunTick > 120) {
                    if (!this.isPlayingPhase) {
                        this.setAnimationState(0);
                    }
                    this.setAttackTicks(0);
                    this.setAttackType(0);
                    this.setStunHealth(this.getMaxStunHealth());
                    this.stunTick = 0;
                    this.setStunned(false);
                }
            }
            if (this.getAttackType() == this.BURROW_ATTACK) {
                if (this.getAttackTicks() > 6 && this.getAttackTicks() <= 30) {
                    this.m_5496_(SoundEvents.f_11993_, 2.0f, 0.7f);
                    this.makeBlockParticles(this.m_20075_());
                    this.setBurrowing(true);
                }
                if (this.getAttackTicks() >= 30 && this.m_5448_() != null) {
                    this.m_20095_();
                    if (this.getAttackTicks() < (this.halfHealth() ? 40 : 100)) {
                        this.m_5496_(SoundEvents.f_12442_, 2.0f, 0.5f);
                    }
                    LivingEntity target = this.m_5448_();
                    if (this.getAttackTicks() < (this.halfHealth() ? 40 : 100)) {
                        this.m_6842_(true);
                        double targetX = target.m_20185_();
                        targetZ = target.m_20189_();
                        double d0 = Math.min(target.m_20186_(), this.m_20186_());
                        double d1 = Math.max(target.m_20186_(), this.m_20186_());
                        this.m_146884_(this.getBurrowPosition(targetX, targetZ, d0, d1));
                    }
                    this.m_20334_(0.0, 0.0, 0.0);
                    if (this.getAttackTicks() == (this.halfHealth() ? 49 : 119)) {
                        this.setAnimationState(7);
                    }
                    if (this.getAttackTicks() == (this.halfHealth() ? 50 : 120)) {
                        this.makeBlockParticles(this.m_20075_());
                        this.m_6842_(false);
                        CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.05f, 0, 30);
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.6f);
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.2f);
                        for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                            if (!EntityUtil.canHurtThisMob(entity, (Mob)this) || !(entity instanceof LivingEntity) || !entity.m_6084_() || entity == this) continue;
                            deltaX = this.m_20185_() - entity.m_20185_();
                            double deltaY6 = this.m_20186_() - entity.m_20186_();
                            double deltaZ6 = this.m_20189_() - entity.m_20189_();
                            distance = Math.sqrt(deltaX * deltaX + deltaY6 * deltaY6 + deltaZ6 * deltaZ6);
                            if (!(this.m_20280_(entity) < 9.0) || entity.f_19802_ > 0) continue;
                            this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                            entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
                            entity.f_19864_ = true;
                            entity.m_20334_(-deltaX / distance * 2.0, -deltaY6 / distance * 2.0 + 0.8, -deltaZ6 / distance * 2.0);
                            entity.m_6001_(-deltaX / distance * 2.0, -deltaY6 / distance * 2.0 + 0.8, -deltaZ6 / distance * 2.0);
                            if (!((LivingEntity)entity).m_21254_()) continue;
                            EntityUtil.disableShield((LivingEntity)entity, 200);
                        }
                        this.m_20334_(0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.isCrazy() && this.getAttackType() == this.CHARGE_ATTACK) {
                LivingEntity target = this.m_5448_();
                if (this.getAttackTicks() == 6) {
                    this.m_5496_(SoundEvents.f_12314_, 2.0f, 0.9f);
                    this.m_5496_(SoundEvents.f_12314_, 2.0f, 0.9f);
                }
                if (this.getAttackTicks() == 26 && target != null) {
                    if (this.halfHealth()) {
                        AreaEffectCloud cloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
                        cloud.m_19712_(3.0f);
                        cloud.m_19732_(-0.5f);
                        cloud.m_19740_(10);
                        cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
                        cloud.m_19722_((Potion)PotionRegisterer.MUTATION.get());
                        cloud.m_19718_((LivingEntity)this);
                        this.m_9236_().m_7967_((Entity)cloud);
                    }
                    this.chargeX = 0.0;
                    this.chargeZ = 0.0;
                    double deltaX7 = this.m_20185_() - target.m_20185_();
                    deltaY = this.m_20186_() - target.m_20186_();
                    double deltaZ7 = this.m_20189_() - target.m_20189_();
                    double distance8 = Math.sqrt(deltaX7 * deltaX7 + deltaY * deltaY + deltaZ7 * deltaZ7);
                    EntityUtil.mobFollowingSound(this.m_9236_(), (Entity)this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_CHARGE.get(), 2.0f, this.m_6100_(), false);
                    float power = 4.5f;
                    double motionX5 = -(deltaX7 / distance8 * (double)power * 0.2);
                    motionZ = -(deltaZ7 / distance8 * (double)power * 0.2);
                    this.chargeX = motionX5;
                    this.chargeZ = motionZ;
                }
                if (this.getAttackTicks() > 26) {
                    if (this.halfHealth() && (this.getAttackTicks() - 26) % 5 == 0) {
                        AreaEffectCloud cloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
                        cloud.m_19712_(3.0f);
                        cloud.m_19732_(-0.5f);
                        cloud.m_19740_(10);
                        cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
                        cloud.m_19722_((Potion)PotionRegisterer.MUTATION.get());
                        cloud.m_19718_((LivingEntity)this);
                        this.m_9236_().m_7967_((Entity)cloud);
                    }
                    this.m_20334_(this.chargeX, this.m_20184_().f_82480_, this.chargeZ);
                    for (Entity hit : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                        if (!EntityUtil.canHurtThisMob(hit, (Mob)this) || !(hit instanceof LivingEntity) || !hit.m_6084_() || hit == this || (hit instanceof TrickOrTreatEntity || hit instanceof FunnyboneEntity || hit instanceof EyesoreEntity) && hit.f_19797_ <= 20) continue;
                        deltaX = this.m_20185_() - hit.m_20185_();
                        double deltaY7 = this.m_20186_() - hit.m_20186_();
                        double deltaZ8 = this.m_20189_() - hit.m_20189_();
                        double distance9 = Math.sqrt(deltaX * deltaX + deltaY7 * deltaY7 + deltaZ8 * deltaZ8);
                        if (!(this.m_20280_(hit) < 9.0) || hit.f_19802_ > 0) continue;
                        this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                        hit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
                        hit.f_19864_ = true;
                        hit.m_20334_(-deltaX / distance9 * 2.0, -deltaY7 / distance9 * 2.0 + 1.2, -deltaZ8 / distance9 * 2.0);
                        hit.m_6001_(-deltaX / distance9 * 2.0, -deltaY7 / distance9 * 2.0 + 1.2, -deltaZ8 / distance9 * 2.0);
                        if (!((LivingEntity)hit).m_21254_()) continue;
                        EntityUtil.disableShield((LivingEntity)hit, 200);
                    }
                }
            }
            if (!this.isPlayingIntro && !this.isPlayingPhase && !this.isCrazy() && (this.doesAttackMeetNormalRequirements() && this.m_20280_((Entity)this.m_5448_()) > 1225.0 && this.chargeCooldown < 1 || this.getAttackType() == 4)) {
                if (this.getAttackTicks() == 0) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_PREPARECHARGE.get(), 2.0f, 0.9f);
                    this.setAnimationState(8);
                    this.setAttackType(this.CHARGE_ATTACK);
                }
                this.m_21573_().m_26573_();
                this.m_21566_().m_24988_(0.0f, 0.0f);
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 100.0f, 100.0f);
                }
                this.m_21566_().m_24988_(0.0f, 0.0f);
                this.f_21344_.m_26573_();
                LivingEntity target = this.m_5448_();
                if (this.getAttackTicks() == 6) {
                    this.m_5496_(SoundEvents.f_12314_, 2.0f, 0.9f);
                    this.m_5496_(SoundEvents.f_12314_, 2.0f, 0.9f);
                }
                if (!this.m_9236_().f_46443_ && this.getAttackTicks() == 26 && target != null) {
                    this.chargeX = 0.0;
                    this.chargeZ = 0.0;
                    double deltaX8 = this.m_20185_() - target.m_20185_();
                    deltaY = this.m_20186_() - target.m_20186_();
                    double deltaZ9 = this.m_20189_() - target.m_20189_();
                    double distance10 = Math.sqrt(deltaX8 * deltaX8 + deltaY * deltaY + deltaZ9 * deltaZ9);
                    EntityUtil.mobFollowingSound(this.m_9236_(), (Entity)this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_CHARGE.get(), 2.0f, this.m_6100_(), false);
                    float power = 4.5f;
                    double motionX6 = -(deltaX8 / distance10 * (double)power * 0.2);
                    motionZ = -(deltaZ9 / distance10 * (double)power * 0.2);
                    this.chargeX = motionX6;
                    this.chargeZ = motionZ;
                }
                if (!this.m_9236_().f_46443_ && this.getAttackTicks() > 26) {
                    this.m_20334_(this.chargeX, this.m_20184_().f_82480_, this.chargeZ);
                    for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                        if (!EntityUtil.canHurtThisMob(entity, (Mob)this) || !(entity instanceof LivingEntity) || !entity.m_6084_() || entity == this || (entity instanceof TrickOrTreatEntity || entity instanceof FunnyboneEntity || entity instanceof EyesoreEntity) && entity.f_19797_ <= 20) continue;
                        deltaX = this.m_20185_() - entity.m_20185_();
                        double deltaY8 = this.m_20186_() - entity.m_20186_();
                        double deltaZ10 = this.m_20189_() - entity.m_20189_();
                        double distance11 = Math.sqrt(deltaX * deltaX + deltaY8 * deltaY8 + deltaZ10 * deltaZ10);
                        if (!(this.m_20280_(entity) < 9.0) || entity.f_19802_ > 0) continue;
                        this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                        entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
                        entity.f_19864_ = true;
                        entity.m_20334_(-deltaX / distance11 * 2.0, -deltaY8 / distance11 * 2.0 + 1.2, -deltaZ10 / distance11 * 2.0);
                        entity.m_6001_(-deltaX / distance11 * 2.0, -deltaY8 / distance11 * 2.0 + 1.2, -deltaZ10 / distance11 * 2.0);
                        if (!((LivingEntity)entity).m_21254_()) continue;
                        EntityUtil.disableShield((LivingEntity)entity, 200);
                    }
                }
                if (this.getAttackTicks() > 96) {
                    this.setAnimationState(0);
                    this.setAttackTicks(0);
                    this.setAttackType(0);
                    this.chargeX = 0.0;
                    this.chargeZ = 0.0;
                    this.chargeCooldown = 40;
                    this.attackCooldown = 20;
                }
            }
            if (this.getAttackType() == this.COUGH_ATTACK && this.getAttackTicks() == 10 && this.m_5448_() != null) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_COUGH.get(), 2.0f, 1.0f);
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.06f, 0, 10);
                LivingEntity target = this.m_5448_();
                if (this.f_19796_.m_188499_()) {
                    for (int i = 0; i < 4; ++i) {
                        if (this.m_9236_().f_46443_) continue;
                        TrickOrTreatEntity treat = (TrickOrTreatEntity)((EntityType)ModEntityTypes.TrickOrTreat.get()).m_20615_(this.m_9236_());
                        assert (treat != null);
                        treat.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                        deltaX = this.m_20185_() - target.m_20185_();
                        double deltaY9 = this.m_20186_() - target.m_20186_();
                        double deltaZ11 = this.m_20189_() - target.m_20189_();
                        double distance12 = Math.sqrt(deltaX * deltaX + deltaY9 * deltaY9 + deltaZ11 * deltaZ11);
                        float power = 4.5f;
                        motionX = -(deltaX / distance12 * (double)power * 0.2);
                        motionY2 = -(deltaY9 / distance12 * (double)power * 0.2);
                        motionZ3 = -(deltaZ11 / distance12 * (double)power * 0.2);
                        treat.m_20334_(motionX, motionY2, motionZ3);
                        treat.circleTime = i * 10;
                        treat.bounceTime = i;
                        treat.setTreat(this.f_19796_.m_188503_(6) + 1);
                        if (this.m_5647_() != null) {
                            this.m_9236_().m_6188_().m_6546_(treat.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        treat.setOwner((LivingEntity)this);
                        treat.setGoopy();
                        this.m_9236_().m_7967_((Entity)treat);
                    }
                } else {
                    for (int i = 0; i < 3; ++i) {
                        if (this.m_9236_().f_46443_) continue;
                        if (this.halfHealth()) {
                            FunnyboneEntity funnybone = (FunnyboneEntity)((EntityType)ModEntityTypes.Funnybone.get()).m_20615_(this.m_9236_());
                            assert (funnybone != null);
                            funnybone.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                            deltaX = this.m_20185_() - target.m_20185_();
                            double deltaY10 = this.m_20186_() - target.m_20186_();
                            double deltaZ12 = this.m_20189_() - target.m_20189_();
                            double distance13 = Math.sqrt(deltaX * deltaX + deltaY10 * deltaY10 + deltaZ12 * deltaZ12);
                            float power = 4.5f;
                            motionX = -(deltaX / distance13 * (double)power * 0.2);
                            motionY2 = -(deltaY10 / distance13 * (double)power * 0.2);
                            motionZ3 = -(deltaZ12 / distance13 * (double)power * 0.2);
                            if (this.m_5647_() != null) {
                                this.m_9236_().m_6188_().m_6546_(funnybone.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                            }
                            funnybone.m_20334_(motionX, motionY2, motionZ3);
                            funnybone.setOwner((LivingEntity)this);
                            funnybone.m_6710_(this.m_5448_());
                            funnybone.setGoopy(true);
                            this.m_9236_().m_7967_((Entity)funnybone);
                            continue;
                        }
                        PumpkinBombEntity bomb = (PumpkinBombEntity)((EntityType)ModEntityTypes.PumpkinBomb.get()).m_20615_(this.m_9236_());
                        assert (bomb != null);
                        bomb.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                        deltaX = this.m_20185_() - target.m_20185_();
                        double deltaY11 = this.m_20186_() - target.m_20186_();
                        double deltaZ13 = this.m_20189_() - target.m_20189_();
                        double distance14 = Math.sqrt(deltaX * deltaX + deltaY11 * deltaY11 + deltaZ13 * deltaZ13);
                        float power = 4.5f;
                        motionX = -(deltaX / distance14 * (double)power * 0.2);
                        motionY2 = -(deltaY11 / distance14 * (double)power * 0.2);
                        motionZ3 = -(deltaZ13 / distance14 * (double)power * 0.2);
                        if (this.m_5647_() != null) {
                            this.m_9236_().m_6188_().m_6546_(bomb.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        bomb.m_20334_(motionX, motionY2, motionZ3);
                        bomb.setOwner((LivingEntity)this);
                        bomb.m_6710_(this.m_5448_());
                        bomb.setGoopy();
                        this.m_9236_().m_7967_((Entity)bomb);
                    }
                }
            }
            if (this.isAnticheese() || this.getAttackType() == this.ANTICHEESE_ATTACK) {
                if (this.getAttackTicks() == 0) {
                    this.setAttackType(this.ANTICHEESE_ATTACK);
                }
                if (this.getAttackTicks() == 30) {
                    this.setAnimationState(6);
                }
                if (this.getAttackTicks() > 36 && this.getAttackTicks() <= 60) {
                    this.m_5496_(SoundEvents.f_11993_, 2.0f, 0.7f);
                    this.makeBlockParticles(this.m_20075_());
                    this.setBurrowing(true);
                }
                if (this.getAttackTicks() >= 60 && this.m_5448_() != null) {
                    this.m_20095_();
                    if (this.getAttackTicks() < 70) {
                        this.m_5496_(SoundEvents.f_12442_, 2.0f, 0.5f);
                    }
                    LivingEntity target = this.m_5448_();
                    if (this.getAttackTicks() < 70) {
                        this.m_6842_(true);
                        double targetX = target.m_20185_();
                        targetZ = target.m_20189_();
                        double d0 = Math.min(target.m_20186_(), this.m_20186_());
                        double d1 = Math.max(target.m_20186_(), this.m_20186_());
                        this.m_146884_(this.getBurrowPosition(targetX, targetZ, d0, d1));
                    }
                    this.m_20334_(0.0, 0.0, 0.0);
                    if (this.getAttackTicks() == 79) {
                        this.setAnimationState(7);
                    }
                    if (this.getAttackTicks() == 80) {
                        this.makeBlockParticles(this.m_20075_());
                        this.m_6842_(false);
                        CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.05f, 0, 30);
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.6f);
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_SLAM.get(), 2.0f, 1.2f);
                        for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                            if (!EntityUtil.canHurtThisMob(entity, (Mob)this) || !(entity instanceof LivingEntity) || !entity.m_6084_() || entity == this) continue;
                            deltaX = this.m_20185_() - entity.m_20185_();
                            double deltaY12 = this.m_20186_() - entity.m_20186_();
                            double deltaZ14 = this.m_20189_() - entity.m_20189_();
                            double distance15 = Math.sqrt(deltaX * deltaX + deltaY12 * deltaY12 + deltaZ14 * deltaZ14);
                            if (!(this.m_20280_(entity) < 9.0) || entity.f_19802_ > 0) continue;
                            this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                            entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
                            entity.f_19864_ = true;
                            entity.m_20334_(-deltaX / distance15 * 2.0, -deltaY12 / distance15 * 2.0 + 0.8, -deltaZ14 / distance15 * 2.0);
                            entity.m_6001_(-deltaX / distance15 * 2.0, -deltaY12 / distance15 * 2.0 + 0.8, -deltaZ14 / distance15 * 2.0);
                            if (!((LivingEntity)entity).m_21254_()) continue;
                            EntityUtil.disableShield((LivingEntity)entity, 200);
                        }
                        this.m_20334_(0.0, 0.0, 0.0);
                    }
                }
                this.m_21573_().m_26573_();
                this.m_21566_().m_24988_(0.0f, 0.0f);
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 100.0f, 100.0f);
                }
                this.m_21566_().m_24988_(0.0f, 0.0f);
                this.f_21344_.m_26573_();
                if (this.getAttackTicks() > 98) {
                    this.setAnimationState(0);
                    this.setAttackTicks(0);
                    this.setAttackType(0);
                    this.m_6842_(false);
                    this.setBurrowing(false);
                    if (!this.m_9236_().f_46443_) {
                        this.setAnticheese(false);
                    }
                }
            }
        }
        if (!(this.getAttackType() != 0 || this.isPlayingIntro || this.isPlayingPhase || this.m_5448_() == null || this.isStunned())) {
            this.circleTarget((Entity)this.m_5448_(), 10.0f, 0.8f, true, this.circleTick, 0.0f, 1.0f);
            this.m_21391_((Entity)this.m_5448_(), 100.0f, 100.0f);
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 100.0f, 100.0f);
        }
        if (this.getStunHealth() <= 0 && !this.isStunned()) {
            this.setStunned(true);
        }
        this.regenerateStunHealth();
        if (this.getStunHealth() <= this.getMaxStunHealth() / 3 && !this.isStunned() && !this.isBurrowing() && this.f_19796_.m_188503_(4) == 0) {
            this.makeSweatParticles(1);
        }
        if (this.isStunned()) {
            this.m_21573_().m_26573_();
            ++this.stunTick;
            if (this.stunTick == 6) {
                this.m_5496_(SoundEvents.f_12314_, 2.0f, 0.9f);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_STUN.get(), 3.0f, 1.0f);
            }
            if (this.stunTick % 5 == 0) {
                this.makeSweatParticles(2);
            }
            this.f_21344_.m_26573_();
        }
        if (this.m_5448_() != null && this.m_6084_() && (double)this.m_20270_((Entity)this.m_5448_()) < 8.0 * ((double)this.m_5448_().m_20205_() + 0.4) && this.getAttackType() == 0 && this.m_20096_() && !this.isStunned() && !this.isPlayingIntro && !this.isPlayingPhase) {
            double deltaX = this.m_20185_() - this.m_5448_().m_20185_();
            double deltaY = this.m_20186_() - this.m_5448_().m_20186_();
            deltaZ = this.m_20189_() - this.m_5448_().m_20189_();
            double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
            this.m_20256_(this.m_20184_().m_82492_(-deltaX / distance * 0.08, 0.0, -deltaZ / distance * 0.08));
        }
        if (this.isCrazy() && this.halfHealth() && !this.isBurrowing() && this.f_19796_.m_188503_(5) == 0) {
            this.makePassiveMutationParticles();
        }
        super.m_8119_();
        this.m_146922_(this.m_6080_());
        this.f_20883_ = this.m_146908_();
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.isCrazy() && (this.phaseTicks < 1 || this.phaseTicks > 250)) {
            float radius = 3.0f;
            float angle = (float)Math.PI / 180 * this.f_20883_;
            double x = this.m_20185_() + (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle))));
            double z = this.m_20189_() + (double)(radius * Mth.m_14089_((float)angle));
            moveFunction.m_20372_(passenger, x, this.m_20186_() + 0.75, z);
        } else {
            super.m_19956_(passenger, moveFunction);
        }
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity p_29487_) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() != Direction.Axis.Y) {
            int[][] aint = DismountHelper.m_38467_((Direction)direction);
            BlockPos blockpos = this.m_20183_();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (Pose pose : p_29487_.m_7431_()) {
                AABB aabb = p_29487_.m_21270_(pose);
                for (int[] aint1 : aint) {
                    blockpos$mutableblockpos.m_122178_(blockpos.m_123341_() + aint1[0], blockpos.m_123342_(), blockpos.m_123343_() + aint1[1]);
                    double d0 = this.m_9236_().m_45573_((BlockPos)blockpos$mutableblockpos);
                    if (!DismountHelper.m_38439_((double)d0)) continue;
                    Vec3 vec3 = Vec3.m_82514_((Vec3i)blockpos$mutableblockpos, (double)d0);
                    if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)p_29487_, (AABB)aabb.m_82383_(vec3))) continue;
                    p_29487_.m_20124_(pose);
                    return vec3;
                }
            }
        }
        return super.m_7688_(p_29487_);
    }

    public boolean shouldRiderSit() {
        return !this.isCrazy();
    }

    private Vec3 getBurrowPosition(double p_32673_, double p_32674_, double p_32675_, double p_32676_) {
        BlockPos blockpos = BlockPos.m_274561_((double)p_32673_, (double)p_32676_, (double)p_32674_);
        boolean flag = false;
        do {
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)p_32675_) - 1);
        return flag ? new Vec3(p_32673_, (double)blockpos.m_123342_(), p_32674_) : this.m_20182_();
    }

    public int getAttackType() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
    }

    public void setAttackType(int attackType) {
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)attackType);
    }

    public int getAttackTicks() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TICKS);
    }

    public void setAttackTicks(int attackTicks) {
        this.f_19804_.m_135381_(ATTACK_TICKS, (Object)attackTicks);
    }

    public void stopAttacking() {
        this.setAttackType(0);
    }

    public void m_7334_(Entity p_21294_) {
        if ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE) != 6) {
            super.m_7334_(p_21294_);
        }
    }

    protected void m_6138_() {
        if ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE) != 6) {
            super.m_6138_();
        }
    }

    public void m_6667_(DamageSource source) {
        List treats = this.m_9236_().m_45976_(TrickOrTreatEntity.class, this.m_20191_().m_82400_(40.0));
        if (!treats.isEmpty()) {
            for (TrickOrTreatEntity treat : treats) {
                if (treat.getOwner() != this) continue;
                treat.m_6074_();
            }
        }
        this.stopAttacking();
        this.setBurrowing(false);
        this.setGrabbing(false);
        if (!this.m_20197_().isEmpty()) {
            this.m_20197_().forEach(Entity::m_8127_);
        }
        if (this.m_37886_() && this.m_37885_() != null) {
            this.m_37885_().f_37673_ = 0L;
        }
        this.m_20095_();
        if (!this.m_9236_().f_46443_) {
            this.setAttackTicks(0);
            this.setAnimationState(21);
            this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        }
        if (this.f_20889_ > 0) {
            this.f_20889_ = 10000;
        }
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.getShakeMultiplier() > 0 && this.f_20919_ % 2 == 0) {
            this.setShakeMultiplier(this.getShakeMultiplier() - 1);
        }
        if (this.f_20919_ > 80) {
            this.setShakeMultiplier(3);
        }
        if (this.f_20919_ == 100) {
            this.setFrame(10);
            VillagerSoulEntity soul = (VillagerSoulEntity)((EntityType)ModEntityTypes.VillagerSoul.get()).m_20615_(this.m_9236_());
            assert (soul != null);
            soul.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
            soul.m_20334_(0.0, 0.3, 0.0);
            soul.m_6710_(this.m_21188_());
            this.m_9236_().m_7967_((Entity)soul);
        }
        if (this.f_20919_ == 200 && !this.m_9236_().m_5776_()) {
            super.m_6667_(this.m_269291_().m_269264_());
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void m_6668_(DamageSource source) {
        if (this.m_6125_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_) && this.f_20889_ > 0 && this.hasNotBeenStunned) {
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ItemRegisterer.FREAKAGER_DISC.get())));
        }
        super.m_6668_(source);
    }

    public boolean m_5825_() {
        return super.m_5825_() && !this.m_21224_();
    }

    private void circleTarget(Entity target, float radius, float speed, boolean direction, int circleFrame, float offset, float moveSpeedMultiplier) {
        if (!this.isStunned()) {
            int directionInt = 1;
            double t = (double)(directionInt * circleFrame) * 0.5 * (double)speed / (double)radius + (double)offset;
            Vec3 movePos = target.m_20182_().m_82520_((double)radius * Math.cos(t), 0.0, (double)radius * Math.sin(t));
            this.m_21573_().m_26519_(movePos.m_7096_(), movePos.m_7098_(), movePos.m_7094_(), (double)(speed * moveSpeedMultiplier));
        }
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_CRAWL.get(), 0.5f, 1.0f);
    }

    public void makeBlockParticles(BlockState blockstate) {
        if (!this.m_9236_().f_46443_) {
            Iterator var2 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var2.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var2.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 12; ++i) {
                    double d0 = -0.5 + this.f_19796_.m_188583_();
                    double d1 = -0.5 + this.f_19796_.m_188583_();
                    double d2 = -0.5 + this.f_19796_.m_188583_();
                    BlockParticleOption block = new BlockParticleOption(ParticleTypes.f_123794_, blockstate);
                    packet.queueParticle((ParticleOptions)block, false, new Vec3(this.m_20208_(0.5), this.m_20186_(), this.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeSweatParticles(int quantity) {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < quantity; ++i) {
                    double d0 = -0.5 + this.f_19796_.m_188583_();
                    double d1 = -0.5 + this.f_19796_.m_188583_();
                    double d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123769_, false, new Vec3(this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makePassiveMutationParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                packet.queueParticle((ParticleOptions)ParticleRegisterer.MUTATION_DRIP_PARTICLES.get(), false, new Vec3(this.m_20208_(0.6), this.m_20187_() + (this.m_6084_() ? 0.75 : 0.0), this.m_20262_(0.6)), new Vec3(0.0, 0.0, 0.0));
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeBreath() {
        if (!this.m_9236_().f_46443_) {
            double coneAngleDegrees = 50.0;
            double coneAngleRadians = Math.toRadians(coneAngleDegrees);
            double maxDistance = 8.0;
            List entitiesInRange = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(maxDistance), predicate -> predicate != this && EntityUtil.canHurtThisMob((Entity)predicate, (Mob)this) && RagnoEntity.isMobNotInCreativeMode((Entity)predicate));
            for (LivingEntity entity : entitiesInRange) {
                Vec3 toEntity = entity.m_20182_().m_82546_(this.m_20182_());
                double distance = toEntity.m_82553_();
                if (distance > maxDistance) continue;
                Vec3 toEntityNormalized = toEntity.m_82541_();
                double dotProduct = this.m_20154_().m_82526_(toEntityNormalized);
                double angle = Math.acos(dotProduct);
                if (!(angle <= coneAngleRadians / 2.0)) continue;
                entity.m_7292_(new MobEffectInstance((MobEffect)EffectRegisterer.MUTATION.get(), 600));
                entity.m_6469_(this.m_9236_().m_269111_().m_268998_(DamageTypesRegisterer.MUTATION, (Entity)entity, (Entity)this), 4.0f);
            }
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                float radius2 = 1.0f;
                for (int i = 0; i < 7; ++i) {
                    double x = this.m_20185_() + (double)0.8f * Math.sin((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.sin((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                    double z = this.m_20189_() + (double)0.8f * Math.cos((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.cos((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                    double y = this.m_20186_() + 1.5;
                    double coneAngle = this.f_19796_.m_216339_(40, 60);
                    double randomYawOffset = (this.f_19796_.m_188500_() - 0.5) * coneAngle;
                    double randomPitchOffset = (this.f_19796_.m_188500_() - 0.5) * coneAngle / 2.0;
                    double yaw = Math.toRadians((double)(-this.m_146908_()) + randomYawOffset);
                    double pitch = Math.toRadians((double)(-this.m_146909_()) + randomPitchOffset);
                    double velocityX = -Math.cos(pitch) * Math.sin(yaw);
                    double velocityY = -Math.sin(pitch);
                    double velocityZ = -Math.cos(pitch) * Math.cos(yaw);
                    double speed = this.f_19796_.m_188500_() + this.f_19796_.m_188500_();
                    if (speed < 0.4) {
                        speed += this.f_19796_.m_188500_();
                    }
                    Vec3 velocity = new Vec3(-velocityX, -velocityY, -velocityZ).m_82490_(speed);
                    if (this.f_19796_.m_188503_(10) == 0) {
                        packet.queueParticle((ParticleOptions)ParticleTypes.f_123762_, false, new Vec3(x, y, z), velocity);
                        continue;
                    }
                    packet.queueParticle(this.f_19796_.m_188499_() ? (ParticleOptions)ParticleRegisterer.MUTATION_PARTICLES.get() : (ParticleOptions)ParticleRegisterer.MUTATION_PARTICLES2.get(), false, new Vec3(x, y, z), velocity);
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public Mob getOwner() {
        return this.owner;
    }

    public void setOwner(Mob owner) {
        this.owner = owner;
    }

    public void stopAttackersFromAttacking() {
        List list = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82400_(100.0));
        if (this.getOwner() != null && this.getOwner().m_6084_()) {
            for (Mob attacker : list) {
                if (attacker.m_21188_() == this && this.getOwner() != null) {
                    attacker.m_6703_((LivingEntity)this.getOwner());
                }
                if (attacker.m_5448_() == this && this.getOwner() != null) {
                    attacker.m_6710_((LivingEntity)this.getOwner());
                }
                Mob owner = this.getOwner();
                if (attacker instanceof Warden) {
                    Warden warden = (Warden)attacker;
                    if (warden.m_5448_() != this) continue;
                    warden.m_219387_((Entity)owner, AngerLevel.ANGRY.m_219226_() + 100, false);
                    warden.m_219459_((LivingEntity)owner);
                    continue;
                }
                try {
                    if (!attacker.m_6274_().m_21874_(MemoryModuleType.f_26372_) || !attacker.m_6274_().m_21952_(MemoryModuleType.f_26372_).isPresent() || attacker.m_6274_().m_21952_(MemoryModuleType.f_26372_).get() != this) continue;
                    attacker.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)owner.m_20148_(), 600L);
                    attacker.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)owner, 600L);
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
    }

    public boolean m_20329_(Entity p_20330_) {
        return false;
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.getOwner() != null && damageSource.m_7639_() == this.getOwner()) {
            return false;
        }
        if ((this.isBurrowing() || this.isGrabbing() || this.isAnticheese()) && !damageSource.m_276093_(DamageTypes.f_268724_) && !damageSource.m_276093_(DamageTypes.f_286979_)) {
            return false;
        }
        if (!(!this.m_6084_() || damageSource.m_276093_(DamageTypes.f_268724_) || damageSource.m_276093_(DamageTypes.f_286979_) || this.isCrazy() && !RagnoEntity.isMobNotInCreativeMode(damageSource.m_7639_()))) {
            if (!this.isCrazy() || this.isPlayingPhase) {
                boolean source;
                boolean bl = source = !damageSource.m_269533_(DamageTypeTags.f_268490_);
                if (!this.isStunned() && source && this.blockTicks < 1 && ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 0 || (Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 3 || (Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 15)) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_BLOCK.get(), 2.0f, 1.0f);
                    this.setAnimationState(0);
                    this.setAnimationState(3);
                    this.blockTicks = 10;
                    this.loseStunHealth((int)amount, true);
                }
                if (damageSource.m_7639_() instanceof LivingEntity && this.m_21188_() == null) {
                    this.m_6703_((LivingEntity)damageSource.m_7639_());
                }
                return false;
            }
            if (this.isCrazy() && (this.stunTick < 10 || this.stunTick >= 105)) {
                boolean source;
                boolean bl = source = !damageSource.m_269533_(DamageTypeTags.f_268490_);
                if (!this.isStunned() && source && this.getAttackType() == 0) {
                    if (this.blockTicks < 1 && ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 0 || (Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 3 || (Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 15)) {
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_BLOCK.get(), 2.0f, 1.0f);
                        this.setAnimationState(0);
                        this.setAnimationState(3);
                        this.blockTicks = 10;
                        this.loseStunHealth((int)amount, true);
                    }
                    if (damageSource.m_7639_() instanceof LivingEntity && this.m_21188_() == null) {
                        this.m_6703_((LivingEntity)damageSource.m_7639_());
                    }
                    return false;
                }
                amount /= 3.5f;
            }
        }
        return !damageSource.m_276093_(DamageTypes.f_268612_) && super.m_6469_(damageSource, amount);
    }

    public static boolean isMobNotInCreativeMode(Entity entity) {
        if (!(entity instanceof Player)) {
            return true;
        }
        return !((Player)entity).m_7500_() && !entity.m_5833_();
    }

    public SoundEvent m_7930_() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 6 ? null : (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_AMBIENT.get();
    }

    protected SoundEvent m_7515_() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 6 ? null : (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_DEATH.get();
    }

    public boolean m_7490_() {
        return false;
    }

    public boolean m_21532_() {
        return (Boolean)Config.CommonConfig.ULTIMATE_NIGHTMARE.get() == false;
    }

    public double m_6048_() {
        if (this.getAttackType() == 7) {
            return this.getAttackTicks() >= 7 ? 3.75 : 2.5;
        }
        return this.stunTick > 6 && this.stunTick < 115 ? 2.3 : 2.5;
    }

    @Override
    public AnimationState getAnimationState(String input) {
        if (Objects.equals(input, "intro1")) {
            return this.intro1AnimationState;
        }
        if (Objects.equals(input, "intro2")) {
            return this.intro2AnimationState;
        }
        if (Objects.equals(input, "phase")) {
            return this.phaseAnimationState;
        }
        if (Objects.equals(input, "block")) {
            return this.blockAnimationState;
        }
        if (Objects.equals(input, "web")) {
            return this.webAnimationState;
        }
        if (Objects.equals(input, "webNet")) {
            return this.webNetAnimationState;
        }
        if (Objects.equals(input, "pullIn")) {
            return this.pullInAnimationState;
        }
        if (Objects.equals(input, "netSlam")) {
            return this.netSlamAnimationState;
        }
        if (Objects.equals(input, "jump")) {
            return this.jumpAnimationState;
        }
        if (Objects.equals(input, "land")) {
            return this.landAnimationState;
        }
        if (Objects.equals(input, "leap")) {
            return this.leapAnimationState;
        }
        if (Objects.equals(input, "burrow")) {
            return this.burrowAnimationState;
        }
        if (Objects.equals(input, "popup")) {
            return this.popupAnimationState;
        }
        if (Objects.equals(input, "charge")) {
            return this.chargeAnimationState;
        }
        if (Objects.equals(input, "cough")) {
            return this.coughAnimationState;
        }
        if (Objects.equals(input, "attack")) {
            return this.attackAnimationState;
        }
        if (Objects.equals(input, "stun")) {
            return this.stunAnimationState;
        }
        if (Objects.equals(input, "fall")) {
            return this.fallAnimationState;
        }
        if (Objects.equals(input, "grab")) {
            return this.grabAnimationState;
        }
        if (Objects.equals(input, "breath")) {
            return this.breathAnimationState;
        }
        if (Objects.equals(input, "death")) {
            return this.deathAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ANIMATION_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE)) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.intro1AnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.phaseAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.blockAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.webAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.leapAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.burrowAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.popupAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.stopAllAnimationStates();
                    this.chargeAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 9: {
                    this.stopAllAnimationStates();
                    this.coughAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 10: {
                    this.stopAllAnimationStates();
                    this.fallAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 11: {
                    this.stopAllAnimationStates();
                    this.intro2AnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 12: {
                    this.stopAllAnimationStates();
                    this.attackAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 13: {
                    this.stopAllAnimationStates();
                    this.stunAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 14: {
                    this.stopAllAnimationStates();
                    this.jumpAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 15: {
                    this.stopAllAnimationStates();
                    this.landAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 16: {
                    this.stopAllAnimationStates();
                    this.webNetAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 17: {
                    this.stopAllAnimationStates();
                    this.netSlamAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 18: {
                    this.stopAllAnimationStates();
                    this.grabAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 19: {
                    this.stopAllAnimationStates();
                    this.breathAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 20: {
                    this.stopAllAnimationStates();
                    this.pullInAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 21: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.intro1AnimationState.m_216973_();
        this.phaseAnimationState.m_216973_();
        this.blockAnimationState.m_216973_();
        this.attackAnimationState.m_216973_();
        this.webAnimationState.m_216973_();
        this.webNetAnimationState.m_216973_();
        this.pullInAnimationState.m_216973_();
        this.netSlamAnimationState.m_216973_();
        this.jumpAnimationState.m_216973_();
        this.landAnimationState.m_216973_();
        this.leapAnimationState.m_216973_();
        this.burrowAnimationState.m_216973_();
        this.popupAnimationState.m_216973_();
        this.chargeAnimationState.m_216973_();
        this.coughAnimationState.m_216973_();
        this.stunAnimationState.m_216973_();
        this.fallAnimationState.m_216973_();
        this.grabAnimationState.m_216973_();
        this.breathAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
    }

    public void playIntro() {
        this.setAnimationState(1);
        this.introTicks = 1;
        this.isPlayingIntro = true;
    }

    public void setAnimationState(int input) {
        if (!this.m_6084_() && input == 0) {
            return;
        }
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)input);
    }

    public int getStunHealth() {
        return (Integer)this.f_19804_.m_135370_(STUN_HEALTH);
    }

    public void setStunHealth(int stunHealth) {
        this.f_19804_.m_135381_(STUN_HEALTH, (Object)stunHealth);
    }

    public void regenerateStunHealth() {
        if (!this.m_9236_().f_46443_ && !this.isStunned() && this.getStunHealth() < this.getMaxStunHealth()) {
            int rate = this.isCrazy() ? (this.halfHealth() ? 10 : 15) : 40;
            if (this.isBurrowing()) {
                rate *= 2;
            }
            if (this.f_19797_ % rate == 0) {
                this.setStunHealth(this.getStunHealth() + 1);
            }
        }
    }

    public void loseStunHealth(int amount, boolean canStun) {
        if (!this.m_9236_().f_46443_) {
            int trueAmount = Math.min(amount, 30);
            this.setStunHealth(canStun ? this.getStunHealth() - trueAmount : this.getStunHealth() - Math.min(this.getStunHealth() - 1, trueAmount));
            this.makeSweatParticles(trueAmount);
        }
    }

    public int getMaxStunHealth() {
        if (this.isCrazy()) {
            return this.halfHealth() ? 70 : 90;
        }
        return 50;
    }

    public boolean doesAttackMeetNormalRequirements() {
        return this.getAttackType() == 0 && this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_()) && this.attackCooldown < 1 && !this.isStunned() && !this.isPlayingIntro && !this.isPlayingPhase && !this.isAnticheese() && !this.canUseBreath();
    }

    public boolean canUseBreath() {
        return this.getAttackType() == 0 && this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_()) && this.attackCooldown < 1 && !this.isStunned() && !this.isPlayingIntro && !this.isPlayingPhase && !this.isAnticheese() && this.halfHealth() && this.breathCooldown < 1 && this.isCrazy() && this.m_20280_((Entity)this.m_5448_()) < 36.0;
    }

    static {
        BURROWING = SynchedEntityData.m_135353_(RagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        GRABBING = SynchedEntityData.m_135353_(RagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        STUN_HEALTH = SynchedEntityData.m_135353_(RagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        ATTACK_TICKS = SynchedEntityData.m_135353_(RagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        RAGNO_FACE = SynchedEntityData.m_135353_(RagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        SHAKE_MULTIPLIER = SynchedEntityData.m_135353_(RagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        FRAME = SynchedEntityData.m_135353_(RagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        ANTICHEESE = SynchedEntityData.m_135353_(RagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        ANIMATION_STATE = SynchedEntityData.m_135353_(RagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        CRAZY = SynchedEntityData.m_135353_(RagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        STUNNED = SynchedEntityData.m_135353_(RagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        ATTACK_TYPE = SynchedEntityData.m_135353_(RagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        DATA_FLAGS_ID = SynchedEntityData.m_135353_(RagnoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        SPEED_PENALTY = new AttributeModifier(SPEED_PENALTY_UUID, "STOP MOVING AROUND STUPID", -0.35, AttributeModifier.Operation.ADDITION);
    }

    class StunGoal
    extends Goal {
        public StunGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return RagnoEntity.this.isStunned() && !RagnoEntity.this.isPlayingPhase;
        }

        public void m_8056_() {
            RagnoEntity.this.setAnimationState(10);
        }

        public boolean m_8045_() {
            return RagnoEntity.this.stunTick <= 114 && this.m_8036_();
        }

        public void m_8037_() {
            RagnoEntity.this.m_21573_().m_26573_();
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (RagnoEntity.this.m_5448_() != null && RagnoEntity.this.isCrazy()) {
                RagnoEntity.this.m_21563_().m_24960_((Entity)RagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            RagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            RagnoEntity.this.setAnimationState(0);
            RagnoEntity.this.setAttackTicks(0);
            RagnoEntity.this.setAttackType(0);
            RagnoEntity.this.attackCooldown = 20;
            RagnoEntity.this.setStunHealth(RagnoEntity.this.getMaxStunHealth());
            RagnoEntity.this.stunTick = 0;
            RagnoEntity.this.setStunned(false);
        }
    }

    class WebGoal
    extends Goal {
        public WebGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return RagnoEntity.this.doesAttackMeetNormalRequirements() && (RagnoEntity.this.halfHealth() || RagnoEntity.this.f_19796_.m_188503_(16) == 0) && RagnoEntity.this.webCooldown < 1;
        }

        public void m_8056_() {
            RagnoEntity.this.setAnimationState(4);
            RagnoEntity.this.setAttackType(RagnoEntity.this.WEB_ATTACK);
        }

        public boolean m_8045_() {
            return RagnoEntity.this.getAttackTicks() <= 20 && RagnoEntity.this.getAttackType() == RagnoEntity.this.WEB_ATTACK;
        }

        public void m_8037_() {
            RagnoEntity.this.m_21573_().m_26573_();
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (RagnoEntity.this.m_5448_() != null) {
                RagnoEntity.this.m_21563_().m_24960_((Entity)RagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            RagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            RagnoEntity.this.setAnimationState(0);
            RagnoEntity.this.setAttackTicks(0);
            RagnoEntity.this.setAttackType(0);
            RagnoEntity.this.loseStunHealth(5, false);
            RagnoEntity.this.webCooldown = 200;
            RagnoEntity.this.attackCooldown = 20;
        }
    }

    class LeapGoal
    extends Goal {
        public LeapGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return RagnoEntity.this.doesAttackMeetNormalRequirements() && (RagnoEntity.this.halfHealth() || RagnoEntity.this.f_19796_.m_188503_(16) == 0) && RagnoEntity.this.leapCooldown < 1 && RagnoEntity.this.m_5448_() != null && RagnoEntity.this.m_20280_((Entity)RagnoEntity.this.m_5448_()) < 144.0 && RagnoEntity.this.isCrazy();
        }

        public void m_8056_() {
            RagnoEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_PREPARECHARGE.get(), 2.0f, 1.0f);
            RagnoEntity.this.setAnimationState(5);
            RagnoEntity.this.setAttackType(RagnoEntity.this.LEAP_ATTACK);
        }

        public boolean m_8045_() {
            if (RagnoEntity.this.getAttackTicks() >= 130) {
                return false;
            }
            return (RagnoEntity.this.getAttackTicks() <= 47 || !RagnoEntity.this.m_20096_()) && RagnoEntity.this.getAttackType() == RagnoEntity.this.LEAP_ATTACK;
        }

        public void m_8037_() {
            RagnoEntity.this.m_21573_().m_26573_();
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (RagnoEntity.this.m_5448_() != null) {
                RagnoEntity.this.m_21563_().m_24960_((Entity)RagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            RagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            RagnoEntity.this.setAnimationState(0);
            RagnoEntity.this.setAttackTicks(0);
            RagnoEntity.this.setAttackType(0);
            RagnoEntity.this.loseStunHealth(7, false);
            RagnoEntity.this.shouldHurtOnTouch = false;
            RagnoEntity.this.leapCooldown = 100;
            RagnoEntity.this.attackCooldown = 20;
        }
    }

    class WebNetGoal
    extends Goal {
        public WebNetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return RagnoEntity.this.doesAttackMeetNormalRequirements() && RagnoEntity.this.isCrazy() && (RagnoEntity.this.halfHealth() || RagnoEntity.this.f_19796_.m_188503_(16) == 0) && RagnoEntity.this.webNetCooldown < 1 && RagnoEntity.this.m_20280_((Entity)RagnoEntity.this.m_5448_()) > 121.0;
        }

        public void m_8056_() {
            RagnoEntity.this.setAnimationState(16);
            RagnoEntity.this.setAttackType(RagnoEntity.this.WEB_NET_ATTACK);
            RagnoEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_PREPARECHARGE.get(), 2.0f, 1.25f);
        }

        public boolean m_8045_() {
            return (RagnoEntity.this.getAttackTicks() <= 16 || RagnoEntity.this.waitingForWeb || RagnoEntity.this.followupTicks > 0 && RagnoEntity.this.followupTicks <= 20) && RagnoEntity.this.getAttackType() == RagnoEntity.this.WEB_NET_ATTACK;
        }

        public void m_8037_() {
            RagnoEntity.this.m_21573_().m_26573_();
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (RagnoEntity.this.m_5448_() != null && (RagnoEntity.this.getAttackTicks() < 16 || (Integer)RagnoEntity.this.m_20088_().m_135370_(ANIMATION_STATE) == 20 || RagnoEntity.this.followupTicks > 0)) {
                RagnoEntity.this.m_21563_().m_24960_((Entity)RagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            RagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            RagnoEntity.this.setAttackTicks(0);
            RagnoEntity.this.setAnimationState(0);
            RagnoEntity.this.setAttackType(0);
            RagnoEntity.this.webNetCooldown = 200;
            RagnoEntity.this.loseStunHealth(RagnoEntity.this.followupTicks > 0 ? 7 : 5, false);
            RagnoEntity.this.attackCooldown = 20;
            RagnoEntity.this.followupTicks = 0;
        }
    }

    class BurrowGoal
    extends Goal {
        public BurrowGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return RagnoEntity.this.doesAttackMeetNormalRequirements() && RagnoEntity.this.m_20096_() && (RagnoEntity.this.halfHealth() || RagnoEntity.this.f_19796_.m_188503_(16) == 0) && RagnoEntity.this.burrowCooldown < 1 && RagnoEntity.this.isCrazy();
        }

        public void m_8056_() {
            RagnoEntity.this.setAnimationState(6);
            RagnoEntity.this.setAttackType(RagnoEntity.this.BURROW_ATTACK);
        }

        public boolean m_8045_() {
            return RagnoEntity.this.getAttackTicks() <= (RagnoEntity.this.halfHealth() ? 68 : 138);
        }

        public void m_8037_() {
            RagnoEntity.this.m_21573_().m_26573_();
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (RagnoEntity.this.m_5448_() != null) {
                RagnoEntity.this.m_21563_().m_24960_((Entity)RagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            RagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            RagnoEntity.this.setAnimationState(0);
            RagnoEntity.this.setAttackTicks(0);
            RagnoEntity.this.setAttackType(0);
            RagnoEntity.this.loseStunHealth(RagnoEntity.this.halfHealth() ? 5 : 10, false);
            RagnoEntity.this.burrowCooldown = 160;
            RagnoEntity.this.attackCooldown = 20;
            RagnoEntity.this.m_6842_(false);
            RagnoEntity.this.setBurrowing(false);
        }
    }

    class ChargeGoal
    extends Goal {
        public ChargeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return RagnoEntity.this.doesAttackMeetNormalRequirements() && (RagnoEntity.this.halfHealth() || RagnoEntity.this.f_19796_.m_188503_(16) == 0) && RagnoEntity.this.chargeCooldown < 1 && RagnoEntity.this.isCrazy();
        }

        public void m_8056_() {
            RagnoEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_RAGNO_PREPARECHARGE.get(), 2.0f, 0.9f);
            RagnoEntity.this.setAnimationState(8);
            RagnoEntity.this.setAttackType(RagnoEntity.this.CHARGE_ATTACK);
        }

        public boolean m_8045_() {
            return RagnoEntity.this.getAttackTicks() <= 66;
        }

        public void m_8037_() {
            RagnoEntity.this.m_21573_().m_26573_();
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (RagnoEntity.this.m_5448_() != null) {
                RagnoEntity.this.m_21563_().m_24960_((Entity)RagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            RagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            RagnoEntity.this.setAnimationState(0);
            RagnoEntity.this.setAttackTicks(0);
            RagnoEntity.this.setAttackType(0);
            RagnoEntity.this.loseStunHealth(10, false);
            RagnoEntity.this.chargeCooldown = 160;
            RagnoEntity.this.attackCooldown = 20;
        }
    }

    class CoughGoal
    extends Goal {
        public CoughGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return RagnoEntity.this.doesAttackMeetNormalRequirements() && (RagnoEntity.this.halfHealth() || RagnoEntity.this.f_19796_.m_188503_(16) == 0) && RagnoEntity.this.coughCooldown < 1 && RagnoEntity.this.isCrazy();
        }

        public void m_8056_() {
            RagnoEntity.this.setAnimationState(9);
            RagnoEntity.this.setAttackType(RagnoEntity.this.COUGH_ATTACK);
        }

        public boolean m_8045_() {
            return RagnoEntity.this.halfHealth() ? RagnoEntity.this.getAttackTicks() <= 20 : RagnoEntity.this.getAttackTicks() <= 70;
        }

        public void m_8037_() {
            RagnoEntity.this.m_21573_().m_26573_();
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            if (RagnoEntity.this.m_5448_() != null) {
                RagnoEntity.this.m_21563_().m_24960_((Entity)RagnoEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            RagnoEntity.this.m_21566_().m_24988_(0.0f, 0.0f);
            RagnoEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            RagnoEntity.this.setAnimationState(0);
            RagnoEntity.this.setAttackTicks(0);
            RagnoEntity.this.setAttackType(0);
            RagnoEntity.this.loseStunHealth(5, false);
            RagnoEntity.this.coughCooldown = 200;
            RagnoEntity.this.attackCooldown = 20;
        }
    }
}

