/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.Config;
import com.yellowbrossproductions.illageandspillage.entities.IllagerSoulEntity;
import com.yellowbrossproductions.illageandspillage.entities.SpiritcallerEntity;
import com.yellowbrossproductions.illageandspillage.util.EffectRegisterer;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class MobSpiritEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> GOOD_OR_EVIL = SynchedEntityData.m_135353_(MobSpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SPIRITCALLER = SynchedEntityData.m_135353_(MobSpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private LivingEntity owner;
    private LivingEntity originalMob;
    private int attackTicks;

    public MobSpiritEntity(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.f_21364_ = 0;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public boolean m_7301_(MobEffectInstance p_21197_) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 50.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GOOD_OR_EVIL, (Object)true);
        this.f_19804_.m_135372_(SPIRITCALLER, (Object)false);
    }

    public void m_7380_(CompoundTag p_21484_) {
        super.m_7380_(p_21484_);
        p_21484_.m_128379_("IsGoodOrEvil", this.isGoodOrEvil());
        p_21484_.m_128379_("corrupted", this.isSpiritcaller());
    }

    public void m_7378_(CompoundTag p_21450_) {
        super.m_7378_(p_21450_);
        this.setGoodOrEvil(p_21450_.m_128471_("IsGoodOrEvil"));
        this.setSpiritcaller(p_21450_.m_128471_("corrupted"));
    }

    protected boolean m_7341_(Entity entity) {
        return entity instanceof Mob && super.m_7341_(entity);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity attacker = source.m_7639_();
        if (((Boolean)Config.CommonConfig.nightmare_mode.get()).booleanValue() && (attacker instanceof SpiritcallerEntity || attacker instanceof IllagerSoulEntity)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_8119_() {
        LivingEntity entity;
        this.f_19794_ = true;
        super.m_8119_();
        this.m_20242_(true);
        this.m_146922_(this.m_6080_());
        this.f_20883_ = this.m_146908_();
        if (this.m_5448_() != null) {
            ++this.attackTicks;
            if (this.attackTicks < 40) {
                entity = this.m_5448_();
                double x = this.m_20185_() - entity.m_20185_();
                double y = this.m_20186_() - entity.m_20186_();
                double z = this.m_20189_() - entity.m_20189_();
                double d = Math.sqrt(x * x + y * y + z * z);
                float power = 0.3f;
                double motionX = this.m_20184_().f_82479_ - x / d * (double)power * 0.2;
                double motionY = this.m_20184_().f_82480_ - y / d * (double)power * 0.2;
                double motionZ = this.m_20184_().f_82481_ - z / d * (double)power * 0.2;
                if (this.m_20280_((Entity)entity) > 9.0) {
                    this.m_20334_(motionX, motionY, motionZ);
                }
            }
            if (this.attackTicks > 100 && this.f_19796_.m_188503_(12) == 0) {
                this.attackTicks = 0;
            }
        }
        if (this.m_9236_().m_8055_(this.m_20183_().m_7495_()) != Blocks.f_50016_.m_49966_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
        } else if (this.m_20184_().f_82480_ > 0.0) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.01, 0.0));
        }
        if (this.getOriginalMob() instanceof Mob) {
            this.getOriginalMob().m_7292_(new MobEffectInstance((MobEffect)EffectRegisterer.DISABILITY.get(), 5, 0, true, true, true));
        }
        if (this.getOwner() instanceof Mob) {
            SpiritcallerEntity spiritcaller;
            this.m_6710_(((Mob)this.getOwner()).m_5448_());
            if (this.getOriginalMob() != null && !this.getOriginalMob().m_6084_() && (entity = this.getOwner()) instanceof SpiritcallerEntity && (spiritcaller = (SpiritcallerEntity)entity).getSoulPower() < 8) {
                entity = this.getOwner();
                double x = this.m_20185_() - entity.m_20185_();
                double y = this.m_20186_() - entity.m_20186_();
                double z = this.m_20189_() - entity.m_20189_();
                double d = Math.sqrt(x * x + y * y + z * z);
                float power = 0.3f;
                double motionX = this.m_20184_().f_82479_ - x / d * (double)power * 0.2;
                double motionY = this.m_20184_().f_82480_ - y / d * (double)power * 0.2;
                double motionZ = this.m_20184_().f_82481_ - z / d * (double)power * 0.2;
                this.m_20334_(motionX, motionY, motionZ);
                if (this.m_20280_((Entity)this.getOwner()) < 6.0) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_SPIRITABSORB.get(), 2.0f, this.m_6100_());
                    spiritcaller.setSoulPower(spiritcaller.getSoulPower() + 1);
                    spiritcaller.makeParticles();
                    this.m_146870_();
                }
            }
        }
    }

    public void m_7334_(Entity p_21294_) {
        super.m_7334_(p_21294_);
        if (this.m_5448_() == p_21294_) {
            p_21294_.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22115_());
        }
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    public LivingEntity getOwner() {
        return this.owner;
    }

    public void setOriginalMob(LivingEntity originalMob) {
        this.originalMob = originalMob;
    }

    public LivingEntity getOriginalMob() {
        return this.originalMob;
    }

    public boolean m_21532_() {
        return true;
    }

    public boolean isGoodOrEvil() {
        return (Boolean)this.f_19804_.m_135370_(GOOD_OR_EVIL);
    }

    public void setGoodOrEvil(boolean goodOrEvil) {
        this.f_19804_.m_135381_(GOOD_OR_EVIL, (Object)goodOrEvil);
    }

    public boolean isSpiritcaller() {
        return (Boolean)this.f_19804_.m_135370_(SPIRITCALLER);
    }

    public void setSpiritcaller(boolean corrupted) {
        this.f_19804_.m_135381_(SPIRITCALLER, (Object)corrupted);
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return this.isSpiritcaller() ? (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MOBSPIRIT_HURTCORRUPTED.get() : (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MOBSPIRIT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return this.isSpiritcaller() ? (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MOBSPIRIT_DEATHCORRUPTED.get() : (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MOBSPIRIT_DEATH.get();
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ != 60) {
            super.m_7822_(p_21375_);
        }
    }
}

