/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.client.model.animation.ICanBeAnimated;
import com.yellowbrossproductions.illageandspillage.entities.EngineerMachine;
import com.yellowbrossproductions.illageandspillage.entities.FactoryMinion;
import com.yellowbrossproductions.illageandspillage.entities.IllagerAttack;
import com.yellowbrossproductions.illageandspillage.packet.PacketHandler;
import com.yellowbrossproductions.illageandspillage.packet.ParticlePacket;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class HinderEntity
extends Raider
implements ICanBeAnimated,
EngineerMachine,
IllagerAttack {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(HinderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IN_MOTION = SynchedEntityData.m_135353_(HinderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HEALING = SynchedEntityData.m_135353_(HinderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public AnimationState introAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    private int introTicks;
    private LivingEntity owner;

    public HinderEntity(EntityType<? extends Raider> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void setAnimationState(int state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state);
    }

    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof Raider || entity instanceof EngineerMachine || entity instanceof FactoryMinion) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    @Override
    public LivingEntity getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(IN_MOTION, (Object)false);
        this.f_19804_.m_135372_(HEALING, (Object)false);
    }

    public boolean m_37882_() {
        return false;
    }

    public boolean m_7490_() {
        return false;
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public void setHealing(boolean healing) {
        this.f_19804_.m_135381_(HEALING, (Object)healing);
    }

    public boolean isHealing() {
        return (Boolean)this.f_19804_.m_135370_(HEALING);
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource p_147189_) {
        if (this.isInMotion()) {
            this.introTicks = 1;
            this.setAnimationState(1);
            this.setInMotion(false);
        }
        return false;
    }

    public boolean isInMotion() {
        return (Boolean)this.f_19804_.m_135370_(IN_MOTION);
    }

    public void setInMotion(boolean motion) {
        this.f_19804_.m_135381_(IN_MOTION, (Object)motion);
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return SoundEvents.f_12600_;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_DISPENSER_DESTROY.get();
    }

    @Override
    public AnimationState getAnimationState(String var1) {
        if (Objects.equals(var1, "intro")) {
            return this.introAnimationState;
        }
        if (Objects.equals(var1, "idle")) {
            return this.idleAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ANIMATION_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE)) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.introAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.idleAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    private void stopAllAnimationStates() {
        this.introAnimationState.m_216973_();
        this.idleAnimationState.m_216973_();
    }

    public void makeParticleTrail(double srcX, double srcY, double srcZ, double destX, double destY, double destZ) {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                int particles = (int)(6.0 * (this.m_20275_(destX, destY, destZ) / this.m_20275_(destX, destY, destZ)));
                for (int i = 0; i < particles; ++i) {
                    double trailFactor = (double)i / ((double)particles - 1.0);
                    double tx = srcX + (destX - srcX) * trailFactor;
                    double ty = srcY + (destY - srcY) * trailFactor;
                    double tz = srcZ + (destZ - srcZ) * trailFactor;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123811_, false, tx, ty, tz, 0.8, 0.36, 0.67);
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void m_8119_() {
        if (this.introTicks == 1) {
            this.m_216990_(SoundEvents.f_12600_);
        }
        if (this.introTicks > 0) {
            ++this.introTicks;
        }
        if (this.introTicks == 5) {
            this.m_216990_(SoundEvents.f_12312_);
        }
        if (this.introTicks == 10) {
            this.m_216990_(SoundEvents.f_12312_);
        }
        if (this.introTicks == 15) {
            this.m_216990_(SoundEvents.f_12312_);
        }
        if (this.introTicks == 20) {
            this.setAnimationState(0);
            this.setAnimationState(2);
        }
        if (!this.isInMotion()) {
            if ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE) != 1 && (Integer)this.f_19804_.m_135370_(ANIMATION_STATE) != 2) {
                this.setAnimationState(0);
                this.setAnimationState(2);
            }
            if ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 2) {
                List list = this.m_9236_().m_6443_(Raider.class, this.m_20191_().m_82400_(5.0), predicate -> !(predicate instanceof IllagerAttack) && this.m_142582_((Entity)predicate) && predicate.m_6084_() && predicate.m_21223_() < predicate.m_21233_() && predicate.m_6336_() != MobType.f_21641_);
                if (list.isEmpty()) {
                    if (this.isHealing()) {
                        this.setHealing(false);
                    }
                } else {
                    if (!this.isHealing()) {
                        this.setHealing(true);
                        EntityUtil.mobFollowingSound(this.m_9236_(), (Entity)this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_ENGINEER_HINDER_HEAL.get(), 0.5f, 2.0f, true);
                    }
                    for (Raider entity : list) {
                        this.makeParticleTrail(this.m_20185_(), this.m_20186_() + 0.6, this.m_20189_(), entity.m_20191_().m_82399_().f_82479_, entity.m_20191_().m_82399_().f_82480_, entity.m_20191_().m_82399_().f_82481_);
                        if (this.f_19797_ % 2 != 0) continue;
                        entity.m_5634_(1.0f);
                        if (!entity.m_37886_()) continue;
                        entity.m_37885_().m_37776_();
                    }
                }
            }
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
        if (this.m_20096_() && this.isInMotion()) {
            if (this.introTicks < 1) {
                this.introTicks = 1;
            }
            this.setInMotion(false);
        }
        super.m_8119_();
    }

    public boolean m_21532_() {
        return true;
    }

    public void m_6667_(DamageSource p_70645_1_) {
        super.m_6667_(p_70645_1_);
        if (this.m_9236_().f_46443_) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), d0, d1, d2);
        }
        this.f_20919_ = 19;
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12600_;
    }
}

