/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.client.model.animation.ICanBeAnimated;
import com.yellowbrossproductions.illageandspillage.entities.IllagerAttack;
import com.yellowbrossproductions.illageandspillage.entities.goal.StareAtDeadFreakGoal;
import com.yellowbrossproductions.illageandspillage.entities.projectile.BoneEntity;
import com.yellowbrossproductions.illageandspillage.util.EffectRegisterer;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FunnyboneEntity
extends Monster
implements ICanBeAnimated,
IllagerAttack {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(FunnyboneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(FunnyboneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> GOOPY = SynchedEntityData.m_135353_(FunnyboneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOW_BONE = SynchedEntityData.m_135353_(FunnyboneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState runAnimationState = new AnimationState();
    public AnimationState flyAnimationState = new AnimationState();
    public AnimationState spawnAnimationState = new AnimationState();
    public AnimationState throwAnimationState = new AnimationState();
    private LivingEntity owner;
    public boolean isThrowing;
    private int throwTicks;
    private int introTicks;
    private boolean circleDirection = true;
    protected int circleTick = 0;

    public FunnyboneEntity(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.f_21364_ = 0;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new StareAtDeadFreakGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FunnyboneAttackGoal(this, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new FunnyboneRandomStrollGoal((PathfinderMob)this, 0.3));
        this.f_21345_.m_25352_(9, (Goal)new FunnyboneLookAtEntityGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new FunnyboneLookAtEntityGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.9).m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    @Override
    public LivingEntity getOwner() {
        return this.owner;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_7301_(MobEffectInstance p_21197_) {
        return (!this.isGoopy() || p_21197_.m_19544_() != EffectRegisterer.MUTATION.get()) && super.m_7301_(p_21197_);
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.5f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.isFlying() ? null : (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_FUNNYBONE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_FUNNYBONE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_FUNNYBONE_DEATH.get();
    }

    protected void m_7355_(BlockPos p_32159_, BlockState p_32160_) {
        this.m_5496_(SoundEvents.f_12383_, 0.15f, 1.0f);
    }

    public void m_6710_(@Nullable LivingEntity p_21544_) {
        if (this.owner != null && this.owner.m_6084_() && this.owner instanceof Mob && p_21544_ == ((Mob)this.owner).m_5448_()) {
            super.m_6710_(p_21544_);
        } else if (this.owner == null || !this.owner.m_6084_()) {
            super.m_6710_(p_21544_);
        }
    }

    public void setAnimationState(int state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state);
    }

    public void setGoopy(boolean goopy) {
        this.f_19804_.m_135381_(GOOPY, (Object)goopy);
    }

    public boolean isGoopy() {
        return (Boolean)this.f_19804_.m_135370_(GOOPY);
    }

    public void setShowBone(boolean showBone) {
        this.f_19804_.m_135381_(SHOW_BONE, (Object)showBone);
    }

    public boolean shouldShowBone() {
        return (Boolean)this.f_19804_.m_135370_(SHOW_BONE);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(GOOPY, (Object)false);
        this.f_19804_.m_135372_(SHOW_BONE, (Object)false);
        this.f_19804_.m_135372_(FLYING, (Object)false);
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    @Override
    public AnimationState getAnimationState(String var1) {
        if (Objects.equals(var1, "idle")) {
            return this.idleAnimationState;
        }
        if (Objects.equals(var1, "run")) {
            return this.runAnimationState;
        }
        if (Objects.equals(var1, "fly")) {
            return this.flyAnimationState;
        }
        if (Objects.equals(var1, "spawn")) {
            return this.spawnAnimationState;
        }
        return Objects.equals(var1, "throw") ? this.throwAnimationState : new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ANIMATION_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAnimationState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.flyAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.spawnAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.throwAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    private void stopAllAnimationStates() {
        this.flyAnimationState.m_216973_();
        this.spawnAnimationState.m_216973_();
        this.throwAnimationState.m_216973_();
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource p_147189_) {
        if (this.isFlying()) {
            this.introTicks = 1;
            this.setFlying(false);
            return false;
        }
        return super.m_142535_(p_225503_1_, p_225503_2_, p_147189_);
    }

    public void m_7380_(CompoundTag p_36848_) {
        super.m_7380_(p_36848_);
        p_36848_.m_128379_("goopy", this.isGoopy());
    }

    public void m_7378_(CompoundTag p_36844_) {
        super.m_7378_(p_36844_);
        this.setGoopy(p_36844_.m_128471_("goopy"));
    }

    public void m_8119_() {
        if (this.introTicks == 1) {
            this.m_216990_(SoundEvents.f_12383_);
            this.m_8032_();
            this.setAnimationState(2);
        }
        if (this.introTicks > 0) {
            ++this.introTicks;
        }
        if (this.introTicks == 22) {
            this.setAnimationState(0);
        }
        if (this.owner != null && this.owner.m_6084_() && this.owner instanceof Mob && this.m_5448_() != ((Mob)this.owner).m_5448_()) {
            this.m_6710_(((Mob)this.owner).m_5448_());
        }
        if (this.isFlying() && this.getAnimationState() != 1) {
            this.setAnimationState(1);
        }
        if (this.m_20096_() && this.isFlying()) {
            if (this.introTicks < 1) {
                this.introTicks = 1;
            }
            this.setFlying(false);
        }
        if (this.m_6084_()) {
            if (this.isThrowing) {
                ++this.throwTicks;
            }
            if (this.throwTicks == 1) {
                this.setAnimationState(3);
                this.setShowBone(true);
            }
            if (this.throwTicks == 7) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_FUNNYBONE_THROW.get(), this.m_6121_(), this.m_6100_());
                this.m_5496_(SoundEvents.f_12553_, 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                this.setShowBone(false);
                if (!this.m_9236_().f_46443_ && this.m_5448_() != null) {
                    double x = this.m_20185_() - this.m_5448_().m_20185_();
                    double y = this.m_20186_() + 1.0 - (this.m_5448_().m_20186_() + (double)(this.m_5448_().m_20192_() / 2.0f) + 0.5);
                    double z = this.m_20189_() - this.m_5448_().m_20189_();
                    BoneEntity projectile = new BoneEntity(this.m_9236_(), (LivingEntity)this, -x, -y, -z);
                    projectile.m_6027_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                    CompoundTag tag = this.getPersistentData().m_128469_("Rotation");
                    projectile.m_7378_(tag);
                    projectile.isGoopy = this.isGoopy();
                    projectile.m_5602_((Entity)this);
                    this.m_9236_().m_7967_((Entity)projectile);
                }
            }
            if (this.throwTicks == 15) {
                this.setAnimationState(0);
                this.isThrowing = false;
                this.throwTicks = 0;
            }
        }
        super.m_8119_();
    }

    private boolean canMove() {
        return !this.isFlying() && (this.introTicks == 0 || this.introTicks > 22);
    }

    protected Vec3 updateCirclingPosition(float radius, float speed) {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            if (this.f_19796_.m_188503_(200) == 0) {
                boolean bl = this.circleDirection = !this.circleDirection;
            }
            this.circleTick = this.circleDirection ? ++this.circleTick : --this.circleTick;
            return this.circleEntityPosition((Entity)target, radius, speed, true, this.circleTick, 0.0f);
        }
        return null;
    }

    public Vec3 circleEntityPosition(Entity target, float radius, float speed, boolean direction, int circleFrame, float offset) {
        int directionInt = direction ? 1 : -1;
        double t = (double)(directionInt * circleFrame) * 0.5 * (double)speed / (double)radius + (double)offset;
        return target.m_20182_().m_82520_((double)radius * Math.cos(t), 0.0, (double)radius * Math.sin(t));
    }

    protected static class FunnyboneAttackGoal
    extends Goal {
        private final FunnyboneEntity mob;
        private final float attackRadius;
        private int strafingLeftRightMul;
        private int strafingFrontBackMul;
        private boolean chasing = false;
        protected boolean attacking = false;
        private int timeSinceAttack = 0;

        public FunnyboneAttackGoal(FunnyboneEntity mob, float attackRadius) {
            this.mob = mob;
            this.attackRadius = attackRadius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.canMove() && !this.mob.isThrowing;
        }

        public boolean m_8045_() {
            return (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.mob.canMove() && !this.mob.isThrowing;
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.m_21561_(true);
            this.timeSinceAttack = this.mob.f_19796_.m_188503_(80);
        }

        public void m_8041_() {
            super.m_8041_();
            this.mob.m_21561_(false);
            this.mob.m_21566_().m_24988_(0.0f, 0.0f);
            this.attacking = false;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            if (target != null) {
                if (this.timeSinceAttack < 80) {
                    ++this.timeSinceAttack;
                }
                double distToTarget = this.mob.m_20270_((Entity)target);
                float frontBackDistBuffer = 2.0f;
                float leftRightDistBuffer = 1.5f;
                if (this.chasing && distToTarget <= (double)this.attackRadius) {
                    this.chasing = false;
                }
                if (!this.chasing && distToTarget >= (double)(this.attackRadius + frontBackDistBuffer)) {
                    this.chasing = true;
                }
                if (this.chasing) {
                    this.mob.m_21573_().m_5624_((Entity)target, 0.35);
                    this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    this.mob.m_21566_().m_24988_(0.0f, 0.0f);
                } else {
                    if (!this.attacking) {
                        this.mob.m_21573_().m_26573_();
                        float strafeSpeed = 0.55f;
                        Vec3 circlePos = this.mob.updateCirclingPosition(this.attackRadius, strafeSpeed - 0.2f);
                        double distToCirclePos = this.mob.m_20182_().m_82554_(circlePos);
                        if (distToCirclePos <= (double)leftRightDistBuffer) {
                            this.strafingFrontBackMul = distToTarget > (double)this.attackRadius + 0.5 ? 1 : (distToTarget < (double)this.attackRadius - 0.5 ? -1 : 0);
                            Vec3 toTarget = target.m_20182_().m_82546_(this.mob.m_20182_()).m_82542_(1.0, 0.0, 1.0).m_82541_();
                            Vec3 toCirclePos = circlePos.m_82546_(this.mob.m_20182_()).m_82542_(1.0, 0.0, 1.0).m_82541_();
                            Vec3 cross = toTarget.m_82537_(toCirclePos);
                            this.strafingLeftRightMul = cross.f_82480_ > 0.0 ? 1 : (cross.f_82480_ < 0.0 ? -1 : 0);
                            float distScale = (float)Math.min(Math.pow(distToCirclePos * 1.0 / (double)leftRightDistBuffer, 0.7), 1.0);
                            this.mob.m_21566_().m_24988_((float)this.strafingFrontBackMul * strafeSpeed, (float)this.strafingLeftRightMul * strafeSpeed * distScale);
                            this.mob.m_21391_((Entity)target, 30.0f, 30.0f);
                        } else {
                            this.mob.m_21566_().m_24988_(0.0f, 0.0f);
                            this.mob.m_21573_().m_26519_(circlePos.f_82479_, circlePos.f_82480_, circlePos.f_82481_, 0.35);
                            this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                        }
                    } else {
                        this.mob.m_21566_().m_24988_(0.0f, 0.0f);
                    }
                    if (this.mob.f_19796_.m_188503_(80) == 0 && this.timeSinceAttack >= 80 && this.mob.m_21574_().m_148306_((Entity)target)) {
                        this.attacking = true;
                    }
                    if (this.attacking) {
                        this.mob.isThrowing = true;
                    }
                }
            }
        }
    }

    class FunnyboneRandomStrollGoal
    extends RandomStrollGoal {
        public FunnyboneRandomStrollGoal(PathfinderMob p_25734_, double p_25735_) {
            super(p_25734_, p_25735_);
        }

        public boolean m_8036_() {
            return super.m_8036_() && FunnyboneEntity.this.canMove();
        }

        public boolean m_8045_() {
            return super.m_8045_() && FunnyboneEntity.this.canMove();
        }
    }

    class FunnyboneLookAtEntityGoal
    extends LookAtPlayerGoal {
        public FunnyboneLookAtEntityGoal(Mob p_25524_, Class<? extends LivingEntity> p_25525_, float p_25526_, float p_25527_) {
            super(p_25524_, p_25525_, p_25526_, p_25527_);
        }

        public FunnyboneLookAtEntityGoal(Mob p_25524_, Class<? extends LivingEntity> p_25525_, float p_25526_) {
            super(p_25524_, p_25525_, p_25526_);
        }

        public boolean m_8036_() {
            return super.m_8036_() && FunnyboneEntity.this.canMove();
        }

        public boolean m_8045_() {
            return super.m_8045_() && FunnyboneEntity.this.canMove();
        }
    }
}

