/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yellowbrossproductions.illageandspillage.client.model.WebNetModel;
import com.yellowbrossproductions.illageandspillage.entities.projectile.WebNetEntity;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class WebNetRenderer
extends MobRenderer<WebNetEntity, WebNetModel<WebNetEntity>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("illageandspillage", "textures/entity/freakager/web_net.png");

    public WebNetRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, new WebNetModel(renderManagerIn.m_174023_(WebNetModel.LAYER_LOCATION)), 0.0f);
    }

    public ResourceLocation getTextureLocation(WebNetEntity p_114482_) {
        return TEXTURE;
    }

    public void render(WebNetEntity p_114485_, float p_114486_, float p_114487_, PoseStack p_114488_, MultiBufferSource p_114489_, int p_114490_) {
        if (!p_114485_.m_20145_()) {
            this.renderLeash(p_114485_, p_114487_, p_114488_, p_114489_, p_114485_);
        }
        super.m_7392_((Mob)p_114485_, p_114486_, p_114487_, p_114488_, p_114489_, p_114490_);
    }

    private void renderLeash(WebNetEntity web, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, WebNetEntity netEntity) {
        int i;
        poseStack.m_85836_();
        double rotation = (double)(Mth.m_14179_((float)partialTicks, (float)web.f_19859_, (float)web.m_146908_()) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 vec31 = new Vec3(0.0, (double)web.m_20192_() + 0.75, 0.0);
        double d1 = Math.cos(rotation) * vec31.f_82481_ + Math.sin(rotation) * vec31.f_82479_;
        double d2 = Math.sin(rotation) * vec31.f_82481_ - Math.cos(rotation) * vec31.f_82479_;
        double d3 = Mth.m_14139_((double)partialTicks, (double)web.f_19854_, (double)web.m_20185_()) + d1;
        double d4 = Mth.m_14139_((double)partialTicks, (double)web.f_19855_, (double)web.m_20186_()) + vec31.f_82480_;
        double d5 = Mth.m_14139_((double)partialTicks, (double)web.f_19856_, (double)web.m_20189_()) + d2;
        poseStack.m_85837_(d1, vec31.f_82480_, d2);
        float deltaX = (float)(netEntity.getAttachPoint().f_82479_ - d3);
        float deltaY = (float)(netEntity.getAttachPoint().f_82480_ - d4);
        float deltaZ = (float)(netEntity.getAttachPoint().f_82481_ - d5);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        float f4 = (float)(Mth.m_14193_((double)(deltaX * deltaX + deltaZ * deltaZ)) * (double)0.025f / 2.0);
        float offsetX = deltaZ * f4;
        float offsetZ = deltaX * f4;
        BlockPos blockpos = BlockPos.m_274446_((Position)web.m_20299_(partialTicks));
        BlockPos blockpos1 = BlockPos.m_274446_((Position)netEntity.getAttachPoint());
        int blockLightStart = this.m_6086_((Entity)web, blockpos);
        int blockLightEnd = this.blockLightLevel((Entity)netEntity, blockpos1);
        int skyLightStart = web.m_9236_().m_45517_(LightLayer.SKY, blockpos);
        int skyLightEnd = web.m_9236_().m_45517_(LightLayer.SKY, blockpos1);
        for (i = 0; i <= 24; ++i) {
            WebNetRenderer.m_174307_(vertexConsumer, matrix4f, deltaX, deltaY, deltaZ, blockLightStart, blockLightEnd, skyLightStart, skyLightEnd, 0.025f, 0.025f, offsetX, offsetZ, i, false);
        }
        for (i = 24; i >= 0; --i) {
            WebNetRenderer.m_174307_(vertexConsumer, matrix4f, deltaX, deltaY, deltaZ, blockLightStart, blockLightEnd, skyLightStart, skyLightEnd, 0.025f, 0.0f, offsetX, offsetZ, i, true);
        }
        poseStack.m_85849_();
    }

    private static void m_174307_(VertexConsumer vertexConsumer, Matrix4f matrix4f, float deltaX, float deltaY, float deltaZ, int blockLightStart, int blockLightEnd, int skyLightStart, int skyLightEnd, float widthStart, float widthEnd, float offsetX, float offsetZ, int segment, boolean flag) {
        float f = (float)segment / 24.0f;
        int blockLight = (int)Mth.m_14179_((float)f, (float)blockLightStart, (float)blockLightEnd);
        int skyLight = (int)Mth.m_14179_((float)f, (float)skyLightStart, (float)skyLightEnd);
        int packedLight = LightTexture.m_109885_((int)blockLight, (int)skyLight);
        float brightness = segment % 2 == (flag ? 1 : 0) ? 0.7f : 1.0f;
        float posX = deltaX * f;
        float posY = deltaY * f;
        float posZ = deltaZ * f;
        vertexConsumer.m_252986_(matrix4f, posX - offsetX, posY + widthEnd, posZ + offsetZ).m_85950_(brightness, brightness, brightness, 1.0f).m_85969_(packedLight).m_5752_();
        vertexConsumer.m_252986_(matrix4f, posX + offsetX, posY + widthStart - widthEnd, posZ - offsetZ).m_85950_(brightness, brightness, brightness, 1.0f).m_85969_(packedLight).m_5752_();
    }

    private int blockLightLevel(Entity p_114496_, BlockPos p_114497_) {
        return p_114496_.m_9236_().m_45517_(LightLayer.BLOCK, p_114497_);
    }

    public Vec3 getRenderOffset(WebNetEntity p_114483_, float p_114484_) {
        return new Vec3(0.0, -0.8, 0.0);
    }
}

