/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.yellowbrossproductions.illageandspillage.client.model.SpiritcallerModel;
import com.yellowbrossproductions.illageandspillage.client.render.layer.SpiritcallerArmorLayer;
import com.yellowbrossproductions.illageandspillage.client.render.layer.SpiritcallerFakerLayer;
import com.yellowbrossproductions.illageandspillage.client.render.layer.SpiritcallerGlowLayer;
import com.yellowbrossproductions.illageandspillage.entities.SpiritcallerEntity;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class SpiritcallerRenderer
extends MobRenderer<SpiritcallerEntity, SpiritcallerModel<SpiritcallerEntity>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("illageandspillage", "textures/entity/spiritcaller/spiritcaller_inactive.png");
    private static final ResourceLocation ACTIVE = new ResourceLocation("illageandspillage", "textures/entity/spiritcaller/spiritcaller.png");
    private static final ResourceLocation DEATH = new ResourceLocation("illageandspillage", "textures/entity/spiritcaller/spiritcaller_death.png");
    private static final ResourceLocation NOTHING = new ResourceLocation("illageandspillage", "textures/entity/magispeller/magispeller_nothing.png");
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public SpiritcallerRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, new SpiritcallerModel(renderManagerIn.m_174023_(SpiritcallerModel.LAYER_LOCATION)), 0.5f);
        this.m_115326_((RenderLayer)new SpiritcallerGlowLayer(this));
        this.m_115326_((RenderLayer)new SpiritcallerArmorLayer(this));
        this.m_115326_((RenderLayer)new SpiritcallerFakerLayer(this));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, renderManagerIn.m_174027_(), renderManagerIn.m_234598_()));
    }

    public Vec3 getRenderOffset(SpiritcallerEntity p_114336_, float p_114337_) {
        if (p_114336_.getRitualTicks() > 30 && !p_114336_.isActive()) {
            return new Vec3(p_114336_.m_217043_().m_188583_() * 5.217391304347826E-4 * (double)(p_114336_.getRitualTicks() - 30), 0.0, p_114336_.m_217043_().m_188583_() * 5.217391304347826E-4 * (double)(p_114336_.getRitualTicks() - 30));
        }
        if (p_114336_.m_21224_() && p_114336_.isActive()) {
            return new Vec3(p_114336_.m_217043_().m_188583_() * 0.15, p_114336_.m_217043_().m_188583_() * 0.15, p_114336_.m_217043_().m_188583_() * 0.15);
        }
        if (p_114336_.isClap()) {
            return new Vec3(p_114336_.m_217043_().m_188583_() * 0.25, p_114336_.m_217043_().m_188583_() * 0.25, p_114336_.m_217043_().m_188583_() * 0.25);
        }
        return p_114336_.isShootingLaser() ? new Vec3(p_114336_.m_217043_().m_188583_() * 0.06, p_114336_.m_217043_().m_188583_() * 0.06, p_114336_.m_217043_().m_188583_() * 0.06) : super.m_7860_((Entity)p_114336_, p_114337_);
    }

    protected float getWhiteOverlayProgress(SpiritcallerEntity caller, float p_114044_) {
        return (float)caller.getSoulPower() / 10.0f;
    }

    protected float getFlipDegrees(SpiritcallerEntity p_115337_) {
        return p_115337_.isActive() ? 0.0f : super.m_6441_((LivingEntity)p_115337_);
    }

    protected void scale(SpiritcallerEntity p_115314_, PoseStack p_115315_, float p_115316_) {
        if (p_115314_.m_21224_()) {
            p_115315_.m_85841_(1.0f - (float)(p_115314_.f_20919_ / 131 / 2), 1.0f - (float)(p_115314_.f_20919_ / 131 / 2), 1.0f - (float)(p_115314_.f_20919_ / 131 / 2));
        } else {
            super.m_7546_((LivingEntity)p_115314_, p_115315_, p_115316_);
        }
    }

    public void render(SpiritcallerEntity p_115455_, float p_115456_, float p_115457_, PoseStack p_115458_, MultiBufferSource p_115459_, int p_115460_) {
        super.m_7392_((Mob)p_115455_, p_115456_, p_115457_, p_115458_, p_115459_, p_115460_);
        if (p_115455_.f_20919_ > 0 && p_115455_.isActive()) {
            float f5 = ((float)p_115455_.f_20919_ + p_115457_) / 200.0f;
            float f7 = Math.min(f5 > 0.8f ? (f5 - 0.8f) / 0.2f : 0.0f, 1.0f);
            Random random = new Random(432L);
            VertexConsumer vertexconsumer2 = p_115459_.m_6299_(RenderType.m_110502_());
            p_115458_.m_85836_();
            p_115458_.m_85837_(0.0, 1.0, 0.0);
            p_115458_.m_85841_(((float)p_115455_.f_20919_ + p_115457_) / 131.0f / 2.0f, ((float)p_115455_.f_20919_ + p_115457_) / 131.0f / 2.0f, ((float)p_115455_.f_20919_ + p_115457_) / 131.0f / 2.0f);
            int i = 0;
            while ((float)i < (f5 + f5 * f5) / 2.0f * 60.0f) {
                p_115458_.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
                p_115458_.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
                p_115458_.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f));
                p_115458_.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
                p_115458_.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
                p_115458_.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f + f5 * 90.0f));
                float f3 = random.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
                float f4 = random.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
                Matrix4f matrix4f = p_115458_.m_85850_().m_252922_();
                int j = (int)(255.0f * (1.0f - f7));
                SpiritcallerRenderer.vertex01(vertexconsumer2, matrix4f, j);
                SpiritcallerRenderer.vertex2(vertexconsumer2, matrix4f, f3, f4);
                SpiritcallerRenderer.vertex3(vertexconsumer2, matrix4f, f3, f4);
                SpiritcallerRenderer.vertex01(vertexconsumer2, matrix4f, j);
                SpiritcallerRenderer.vertex3(vertexconsumer2, matrix4f, f3, f4);
                SpiritcallerRenderer.vertex4(vertexconsumer2, matrix4f, f3, f4);
                SpiritcallerRenderer.vertex01(vertexconsumer2, matrix4f, j);
                SpiritcallerRenderer.vertex4(vertexconsumer2, matrix4f, f3, f4);
                SpiritcallerRenderer.vertex2(vertexconsumer2, matrix4f, f3, f4);
                ++i;
            }
            p_115458_.m_85849_();
        }
    }

    private static void vertex01(VertexConsumer p_114220_, Matrix4f p_114221_, int p_114222_) {
        p_114220_.m_252986_(p_114221_, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, p_114222_).m_5752_();
    }

    private static void vertex2(VertexConsumer p_114215_, Matrix4f p_114216_, float p_114217_, float p_114218_) {
        p_114215_.m_252986_(p_114216_, -HALF_SQRT_3 * p_114218_, p_114217_, -0.5f * p_114218_).m_6122_(0, 255, 255, 0).m_5752_();
    }

    private static void vertex3(VertexConsumer p_114224_, Matrix4f p_114225_, float p_114226_, float p_114227_) {
        p_114224_.m_252986_(p_114225_, HALF_SQRT_3 * p_114227_, p_114226_, -0.5f * p_114227_).m_6122_(255, 0, 0, 0).m_5752_();
    }

    private static void vertex4(VertexConsumer p_114229_, Matrix4f p_114230_, float p_114231_, float p_114232_) {
        p_114229_.m_252986_(p_114230_, 0.0f, p_114231_, p_114232_).m_6122_(255, 255, 255, 0).m_5752_();
    }

    public boolean shouldRender(SpiritcallerEntity p_115468_, Frustum p_115469_, double p_115470_, double p_115471_, double p_115472_) {
        return !p_115468_.isPhasedOut() && super.m_5523_((Mob)p_115468_, p_115469_, p_115470_, p_115471_, p_115472_);
    }

    public ResourceLocation getTextureLocation(SpiritcallerEntity p_110775_1_) {
        if (p_110775_1_.m_21224_() && p_110775_1_.isActive()) {
            return DEATH;
        }
        if (p_110775_1_.isFaking()) {
            return NOTHING;
        }
        return p_110775_1_.isActive() ? ACTIVE : TEXTURE;
    }
}

