/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yellowbrossproductions.illageandspillage.client.model.animation.ChagrinSentryAnimation;
import com.yellowbrossproductions.illageandspillage.entities.ChagrinSentryEntity;
import java.util.Calendar;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ChagrinSentryModel<T extends Entity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("illageandspillage", "chagrinsentry"), "main");
    private final ModelPart root;
    private final ModelPart sentry;
    private final ModelPart locker;
    private final ModelPart locker_lid;
    private final ModelPart upperBody;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart glow;
    private final ModelPart chest;
    private final ModelPart arm1;
    private final ModelPart elbow1;
    private final ModelPart arm2;
    private final ModelPart elbow2;
    private final ModelPart joint;
    private final ModelPart slab;

    public ChagrinSentryModel(ModelPart root) {
        this.root = root;
        this.sentry = this.root.m_171324_("sentry");
        this.locker = this.sentry.m_171324_("locker");
        this.locker_lid = this.locker.m_171324_("locker_lid");
        this.upperBody = this.sentry.m_171324_("upper_body");
        this.neck = this.upperBody.m_171324_("neck");
        this.head = this.upperBody.m_171324_("head");
        this.glow = this.head.m_171324_("glow");
        this.chest = this.upperBody.m_171324_("chest");
        this.arm1 = this.upperBody.m_171324_("arm1");
        this.elbow1 = this.arm1.m_171324_("elbow1");
        this.arm2 = this.upperBody.m_171324_("arm2");
        this.elbow2 = this.arm2.m_171324_("elbow2");
        this.joint = this.upperBody.m_171324_("joint");
        this.slab = this.sentry.m_171324_("slab");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition sentry = partdefinition.m_171599_("sentry", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition locker = sentry.m_171599_("locker", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-7.0f, -2.0f, -7.0f, 14.0f, 2.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        locker.m_171599_("locker_lid", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-7.0f, -4.0f, -14.0f, 14.0f, 4.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(0, 16).m_171488_(-1.0f, -3.0f, -15.0f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)7.0f));
        PartDefinition upper_body = sentry.m_171599_("upper_body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        upper_body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171488_(-1.0f, -18.0f, -1.0f, 2.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition head = upper_body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(-6.0f, -12.0f, -6.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        head.m_171599_("glow", CubeListBuilder.m_171558_().m_171514_(64, 64).m_171488_(-6.0f, -12.0f, -6.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition birthday = head.m_171599_("birthday", CubeListBuilder.m_171558_().m_171514_(72, 27).m_171488_(-2.0f, -9.3333f, 6.0833f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(60, 27).m_171488_(-1.5f, -12.3333f, 6.5833f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(85, 21).m_171488_(0.0f, -15.3333f, 6.5833f, 0.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.6667f, (float)-8.0833f));
        birthday.m_171599_("thingy", CubeListBuilder.m_171558_().m_171514_(85, 27).m_171488_(-1.5f, -15.3333f, 8.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        upper_body.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(104, 0).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition arm1 = upper_body.m_171599_("arm1", CubeListBuilder.m_171558_().m_171514_(104, 24).m_171488_(-2.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-9.0f, (float)0.0f));
        arm1.m_171599_("elbow1", CubeListBuilder.m_171558_().m_171514_(92, 28).m_171488_(-2.0f, -2.0f, -11.0f, 4.0f, 4.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)0.0f, (float)0.0f));
        PartDefinition arm2 = upper_body.m_171599_("arm2", CubeListBuilder.m_171558_().m_171514_(104, 24).m_171480_().m_171488_(-8.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)-9.0f, (float)0.0f));
        arm2.m_171599_("elbow2", CubeListBuilder.m_171558_().m_171514_(92, 28).m_171480_().m_171488_(-2.0f, -2.0f, -11.0f, 4.0f, 4.0f, 14.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-8.0f, (float)0.0f, (float)0.0f));
        upper_body.m_171599_("joint", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        sentry.m_171599_("slab", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(-6.0f, -4.0f, -6.0f, 12.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_6973_(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entity instanceof ChagrinSentryEntity) {
            float deltaYaw;
            ChagrinSentryEntity sentry = (ChagrinSentryEntity)entity;
            Calendar calendar = Calendar.getInstance();
            this.head.m_171324_((String)"birthday").f_104207_ = calendar.get(2) == 1 && calendar.get(5) < 8;
            for (deltaYaw = sentry.f_20883_ - sentry.f_20884_; deltaYaw < -180.0f; deltaYaw += 360.0f) {
            }
            while (deltaYaw >= 180.0f) {
                deltaYaw -= 360.0f;
            }
            this.upperBody.f_104204_ = (sentry.f_20884_ + deltaYaw * sentry.getPartialTicks()) * ((float)Math.PI / 180);
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.arm1.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.arm2.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.slab.m_171327_(0.0f, 0.0f, 0.0f);
            this.m_233385_(sentry.getAnimationState("intro"), ChagrinSentryAnimation.INTRO, ageInTicks, sentry.getAnimationSpeed());
            this.m_233385_(sentry.getAnimationState("shooting"), ChagrinSentryAnimation.SHOOT, ageInTicks, sentry.getAnimationSpeed());
            this.m_233385_(sentry.getAnimationState("stun"), ChagrinSentryAnimation.POWER_DOWN, ageInTicks, sentry.getAnimationSpeed());
            this.locker.f_104207_ = sentry.shouldShowLocker();
            if (sentry.isInMotion()) {
                this.locker.f_104203_ = ageInTicks * 25.0f * ((float)Math.PI / 180);
                this.locker.f_104204_ = ageInTicks * 15.0f * ((float)Math.PI / 180);
                this.locker.f_104205_ = ageInTicks * 20.0f * ((float)Math.PI / 180);
                this.upperBody.f_104207_ = false;
                this.slab.f_104207_ = false;
            } else {
                this.locker.f_104203_ = 0.0f;
                this.locker.f_104204_ = 0.0f;
                this.locker.f_104205_ = 0.0f;
                this.upperBody.f_104207_ = true;
                this.slab.f_104207_ = true;
            }
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

