/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.datagen;

import com.github.alexthe666.iceandfire.datagen.IafProcessorLists;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class IafStructurePieces {
    public static final ResourceKey<StructureTemplatePool> GRAVEYARD_START = IafStructurePieces.createKey("graveyard/start_pool");
    public static final ResourceKey<StructureTemplatePool> MAUSOLEUM_START = IafStructurePieces.createKey("mausoleum/start_pool");
    public static final ResourceKey<StructureTemplatePool> GORGON_TEMPLE_START = IafStructurePieces.createKey("gorgon_temple/start_pool");

    private static ResourceKey<StructureTemplatePool> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation("iceandfire", name));
    }

    public static void registerGraveyard(BootstapContext<StructureTemplatePool> pContext) {
        HolderGetter processorListHolderGetter = pContext.m_255420_(Registries.f_257011_);
        Holder.Reference graveyardProcessor = processorListHolderGetter.m_255043_(IafProcessorLists.GRAVEYARD_PROCESSORS);
        HolderGetter templatePoolHolderGetter = pContext.m_255420_(Registries.f_256948_);
        Holder.Reference fallback = templatePoolHolderGetter.m_255043_(Pools.f_127186_);
        pContext.m_255272_(GRAVEYARD_START, (Object)new StructureTemplatePool((Holder)fallback, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)"iceandfire:graveyard/graveyard_top", (Holder)graveyardProcessor), (Object)1)), StructureTemplatePool.Projection.RIGID));
        pContext.m_255272_(IafStructurePieces.createKey("graveyard/bottom_pool"), (Object)new StructureTemplatePool((Holder)fallback, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)"iceandfire:graveyard/graveyard_bottom", (Holder)graveyardProcessor), (Object)1)), StructureTemplatePool.Projection.RIGID));
    }

    public static void registerMausoleum(BootstapContext<StructureTemplatePool> pContext) {
        HolderGetter processorListHolderGetter = pContext.m_255420_(Registries.f_257011_);
        Holder.Reference graveyardProcessor = processorListHolderGetter.m_255043_(IafProcessorLists.MAUSOLEUM_PROCESSORS);
        HolderGetter templatePoolHolderGetter = pContext.m_255420_(Registries.f_256948_);
        Holder.Reference fallback = templatePoolHolderGetter.m_255043_(Pools.f_127186_);
        pContext.m_255272_(MAUSOLEUM_START, (Object)new StructureTemplatePool((Holder)fallback, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)"iceandfire:mausoleum/building", (Holder)graveyardProcessor), (Object)1)), StructureTemplatePool.Projection.RIGID));
    }

    public static void registerGorgonTemple(BootstapContext<StructureTemplatePool> pContext) {
        HolderGetter processorListHolderGetter = pContext.m_255420_(Registries.f_257011_);
        Holder.Reference graveyardProcessor = processorListHolderGetter.m_255043_(IafProcessorLists.GORGON_TEMPLE_PROCESSORS);
        HolderGetter templatePoolHolderGetter = pContext.m_255420_(Registries.f_256948_);
        Holder.Reference fallback = templatePoolHolderGetter.m_255043_(Pools.f_127186_);
        pContext.m_255272_(GORGON_TEMPLE_START, (Object)new StructureTemplatePool((Holder)fallback, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)"iceandfire:gorgon_temple/building", (Holder)graveyardProcessor), (Object)1)), StructureTemplatePool.Projection.RIGID));
        pContext.m_255272_(IafStructurePieces.createKey("gorgon_temple/bottom_pool"), (Object)new StructureTemplatePool((Holder)fallback, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)"iceandfire:gorgon_temple/basement", (Holder)graveyardProcessor), (Object)1)), StructureTemplatePool.Projection.RIGID));
        pContext.m_255272_(IafStructurePieces.createKey("gorgon_temple/gorgon_pool"), (Object)new StructureTemplatePool((Holder)fallback, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.m_210531_((String)"iceandfire:gorgon_temple/gorgon", (Holder)graveyardProcessor), (Object)1)), StructureTemplatePool.Projection.RIGID));
    }

    public static void bootstrap(BootstapContext<StructureTemplatePool> pContext) {
        IafStructurePieces.registerGraveyard(pContext);
        IafStructurePieces.registerMausoleum(pContext);
        IafStructurePieces.registerGorgonTemple(pContext);
    }
}

