/*
 * Decompiled with CFR 0.152.
 */
package net.donne431.ice_and_fire_delight.block;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.donne431.ice_and_fire_delight.init.IceAndFireDelightModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class FrostPieBlock
extends Block {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.m_61631_((String)"blockstate", (int)0, (int)3);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public FrostPieBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_279557_).m_60913_(1.0f, 10.0f).m_60953_(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.m_61143_((Property)BLOCKSTATE) == 1) {
                    return 0;
                }
                if ((Integer)this.val$s.m_61143_((Property)BLOCKSTATE) == 2) {
                    return 0;
                }
                if ((Integer)this.val$s.m_61143_((Property)BLOCKSTATE) == 3) {
                    return 0;
                }
                return 0;
            }
        }.getLightLevel()).m_60955_().m_60924_((bs, br, bp) -> false));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public ItemStack getPieSliceItem() {
        return new ItemStack((ItemLike)IceAndFireDelightModItems.FROST_PIE_SLICE.get());
    }

    public int getMaxBites() {
        return 4;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        if (level.f_46443_) {
            if (heldStack.m_204117_(ModTags.KNIVES)) {
                return this.cutSlice(level, pos, state, player);
            }
            if (this.consumeBite(level, pos, state, player) == InteractionResult.SUCCESS) {
                return InteractionResult.SUCCESS;
            }
            if (heldStack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        if (heldStack.m_204117_(ModTags.KNIVES)) {
            return this.cutSlice(level, pos, state, player);
        }
        return this.consumeBite(level, pos, state, player);
    }

    protected InteractionResult consumeBite(Level level, BlockPos pos, BlockState state, Player playerIn) {
        int bites;
        if (!playerIn.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        ItemStack sliceStack = this.getPieSliceItem();
        ItemStack sliceCopy = sliceStack.m_41777_();
        FoodProperties sliceFood = sliceStack.m_41720_().m_41473_();
        playerIn.m_36324_().m_38707_(0, 0.4f);
        playerIn.m_36324_().m_38712_(sliceStack.m_41720_(), sliceStack);
        ForgeEventFactory.onItemUseFinish((LivingEntity)playerIn, (ItemStack)sliceCopy, (int)0, (ItemStack)ItemStack.f_41583_);
        if (this.getPieSliceItem().m_41720_().m_41472_() && sliceFood != null) {
            for (Pair pair : sliceFood.m_38749_()) {
                if (level.f_46443_ || pair.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                playerIn.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
        if ((bites = ((Integer)state.m_61143_((Property)BLOCKSTATE)).intValue()) < this.getMaxBites() - 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BLOCKSTATE, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Player player) {
        int bites = (Integer)state.m_61143_((Property)BLOCKSTATE);
        if (bites < this.getMaxBites() - 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BLOCKSTATE, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        Direction direction = player.m_6350_().m_122424_();
        ItemUtils.spawnItemEntity((Level)level, (ItemStack)this.getPieSliceItem(), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.3), (double)((double)pos.m_123343_() + 0.5), (double)((double)direction.m_122429_() * 0.15), (double)0.05, (double)((double)direction.m_122431_() * 0.15));
        level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public void m_5871_(ItemStack itemstack, BlockGetter world, List<Component> list, TooltipFlag flag) {
        super.m_5871_(itemstack, world, list, flag);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83110_((VoxelShape)FrostPieBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), (VoxelShape)FrostPieBlock.m_49796_((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, BLOCKSTATE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return this.getMaxBites() - (Integer)blockState.m_61143_((Property)BLOCKSTATE);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

