/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.loader.forge;

import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.network.PacketChannel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketChannelForge
extends PacketChannel {
    private final SimpleChannel channel;

    @SafeVarargs
    public PacketChannelForge(ResourceLocation name, int protocolVersion, Class<? extends AbstractPacket> ... packetTypes) {
        this(name, protocolVersion, true, true, packetTypes);
    }

    @SafeVarargs
    public PacketChannelForge(ResourceLocation name, int protocolVersion, boolean clientRequired, boolean serverRequired, Class<? extends AbstractPacket> ... packetTypes) {
        super(name, packetTypes);
        String protVersion = Integer.toString(protocolVersion);
        this.channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)name).networkProtocolVersion(() -> protVersion).clientAcceptedVersions(version -> protVersion.equals(version) || !clientRequired).serverAcceptedVersions(version -> protVersion.equals(version) || !serverRequired).simpleChannel();
        this.channel.messageBuilder(PacketChannel.PacketPayload.class, 0).encoder(PacketChannel.PacketPayload::write).decoder(x$0 -> this.readPacket((FriendlyByteBuf)x$0)).consumerNetworkThread((payload, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            ServerPlayer player = context.getDirection().getReceptionSide() == LogicalSide.SERVER ? context.getSender() : this.getPlayer();
            payload.process((Player)player).ifPresent(arg_0 -> ((NetworkEvent.Context)context).enqueueWork(arg_0));
            context.setPacketHandled(true);
        }).add();
    }

    @Override
    public void sendToServer(AbstractPacket packet) {
        this.channel.sendToServer((Object)this.payload(packet));
    }

    @Override
    public void sendTo(AbstractPacket packet, ServerPlayer player) {
        this.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)this.payload(packet));
    }

    @Override
    public void sendToAll(AbstractPacket packet) {
        this.channel.send(PacketDistributor.ALL.noArg(), (Object)this.payload(packet));
    }

    @Override
    public void sendToTracking(AbstractPacket packet, Entity entity) {
        this.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)this.payload(packet));
    }

    @Override
    public void sendToAround(AbstractPacket packet, ServerLevel world, double x, double y, double z, double radius) {
        this.channel.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, radius, world.m_46472_())), (Object)this.payload(packet));
    }
}

