/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.util;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import me.ichun.mods.ichunutil.common.iChunUtil;
import org.jetbrains.annotations.NotNull;

public final class IOUtil {
    static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public static boolean areNativeImagesEqual(NativeImage img1, NativeImage img2) {
        if (img1 == null && img2 == null) {
            return true;
        }
        if (img1 == null || img2 == null) {
            return false;
        }
        if (img1.m_84982_() == img2.m_84982_() && img1.m_85084_() == img2.m_85084_()) {
            for (int x = 0; x < img1.m_84982_(); ++x) {
                for (int y = 0; y < img1.m_85084_(); ++y) {
                    if (img1.m_84985_(x, y) == img2.m_84985_(x, y)) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public static void renameFilesToLowerCaseInDir(File dir) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                IOUtil.renameFilesToLowerCaseInDir(file);
                continue;
            }
            if (file.getName().equals(file.getName().toLowerCase(Locale.ROOT))) continue;
            String name = file.getName().toLowerCase();
            File newFile = new File(dir, name);
            if (file.renameTo(newFile)) {
                iChunUtil.LOGGER.info("Renaming {} to {}", (Object)file.getAbsolutePath(), (Object)newFile.getAbsolutePath());
                continue;
            }
            iChunUtil.LOGGER.error("Failed to rename {} to {}", (Object)file.getAbsolutePath(), (Object)newFile.getAbsolutePath());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int extractFiles(@NotNull Path dir, @NotNull InputStream inputStream, boolean overwrite) throws IOException {
        int i = 0;
        try (ZipInputStream zipStream = new ZipInputStream(inputStream);){
            ZipEntry entry;
            while ((entry = zipStream.getNextEntry()) != null) {
                Path path = dir.resolve(entry.getName());
                if (!overwrite && Files.exists(path, new LinkOption[0]) && Files.size(path) > 3L) continue;
                if (entry.isDirectory()) {
                    if (Files.exists(path, new LinkOption[0])) continue;
                    Files.createDirectories(path, new FileAttribute[0]);
                    continue;
                }
                OutputStream out = Files.newOutputStream(path, new OpenOption[0]);
                try {
                    int len;
                    byte[] buffer = new byte[8192];
                    while ((len = zipStream.read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                    }
                    ++i;
                }
                finally {
                    if (out == null) continue;
                    out.close();
                }
            }
            return i;
        }
    }

    public static int scourDirectoryForFiles(Path path, Function<Path, Boolean> fileFunction) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        int count = 0;
        List files = Files.list(path).collect(Collectors.toList());
        for (Path p : files) {
            if (Files.isDirectory(p, new LinkOption[0])) {
                count += IOUtil.scourDirectoryForFiles(p, fileFunction);
                continue;
            }
            if (!fileFunction.apply(p).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    private static byte[] createChecksum(File filename) throws Exception {
        int numRead;
        FileInputStream fis = new FileInputStream(filename);
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return complete.digest();
    }

    public static String getMD5Checksum(File file) {
        try {
            byte[] b = IOUtil.createChecksum(file);
            String hex = IOUtil.getHexString(b);
            return hex;
        }
        catch (Exception e) {
            iChunUtil.LOGGER.warn("Failed to generate MD5 checksum for {}", (Object)file.getName());
            return null;
        }
    }

    private static String getHexString(byte[] raw) throws UnsupportedEncodingException {
        byte[] hex = new byte[2 * raw.length];
        int index = 0;
        for (byte b : raw) {
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }
        return new String(hex, "ASCII");
    }

    public static byte[] compress(String string) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(string.length());
        GZIPOutputStream gos = new GZIPOutputStream(os);
        gos.write(string.getBytes());
        gos.close();
        byte[] compressed = os.toByteArray();
        os.close();
        return compressed;
    }

    public static String decompress(byte[] compressed) throws IOException {
        int bytesRead;
        int BUFFER_SIZE = 32;
        ByteArrayInputStream is = new ByteArrayInputStream(compressed);
        GZIPInputStream gis = new GZIPInputStream((InputStream)is, 32);
        StringBuilder string = new StringBuilder();
        byte[] data = new byte[32];
        while ((bytesRead = gis.read(data)) != -1) {
            string.append(new String(data, 0, bytesRead));
        }
        gis.close();
        is.close();
        return string.toString();
    }
}

