/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.config;

import com.google.common.base.Splitter;
import com.google.gson.Gson;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.util.StringUtil;
import me.ichun.shadow.com.moandjiezana.toml.Toml;

public final class ConfigToToml {
    private static final Splitter ON_LINE_BREAK = Splitter.on((String)"\n");

    public static String convertToToml(ConfigBase config, boolean minify) {
        StringWriter writer = new StringWriter();
        for (ConfigBase.Category category : config.categories) {
            if (category.comment != null && !minify) {
                ConfigToToml.writeComment(writer, category.comment, false);
            }
            ConfigToToml.writeKey(writer, category.name);
            if (!minify) {
                writer.write("\n");
            }
            for (ConfigBase.Category.Entry entry : category.getEntries()) {
                if (entry.prop.skip()) continue;
                if (entry.comment != null && !minify) {
                    ConfigToToml.writeComment(writer, entry.comment, true);
                }
                if (!minify) {
                    ConfigToToml.writeOptions(writer, entry);
                }
                ConfigToToml.writeField(writer, entry, config);
                if (minify) continue;
                writer.write("\n");
            }
        }
        return writer.toString();
    }

    private static void writeField(StringWriter writer, ConfigBase.Category.Entry entry, ConfigBase config) {
        writer.write("\t");
        try {
            String value = StringUtil.GSON.toJson(entry.field.get(config));
            writer.write(entry.field.getName());
            writer.write(" = ");
            writer.write(value);
        }
        catch (IllegalAccessException e) {
            iChunUtil.LOGGER.error("Error getting field value {} for config {}", new Object[]{entry.field.getName(), config.getClass().getName(), e});
            writer.write("# UMMM Something went wrong, you might wanna check your console and report this to the dev.");
        }
        writer.write("\n");
    }

    private static void writeOptions(StringWriter writer, ConfigBase.Category.Entry entry) {
        if (entry.prop.values().length > 0 && !entry.prop.values()[0].isEmpty()) {
            writer.write("\t# Allowed Values: ");
            for (int i = 0; i < entry.prop.values().length; ++i) {
                writer.write(entry.prop.values()[i]);
                if (i >= entry.prop.values().length - 1) continue;
                writer.write(", ");
            }
            writer.write("\n");
        } else if (entry.field.getType().isEnum()) {
            writer.write("\t# Allowed Values: ");
            ?[] enums = entry.field.getType().getEnumConstants();
            for (int i = 0; i < enums.length; ++i) {
                writer.write(enums[i].toString());
                if (i >= enums.length - 1) continue;
                writer.write(", ");
            }
            writer.write("\n");
        } else if (entry.field.getType() == Integer.TYPE || entry.field.getType() == Double.TYPE) {
            boolean isInt;
            writer.write("\t# Range: ");
            boolean bl = isInt = entry.field.getType() == Integer.TYPE;
            if (entry.prop.min() != -1.7976931348623157E308) {
                if (entry.prop.intBool()) {
                    writer.write("0 ~ 1");
                } else if (entry.prop.max() != Double.MAX_VALUE) {
                    writer.write(isInt ? Integer.toString((int)Math.floor(entry.prop.min())) : Double.toString(entry.prop.min()));
                    writer.write(" ~ ");
                    writer.write(isInt ? Integer.toString((int)Math.floor(entry.prop.max())) : Double.toString(entry.prop.max()));
                } else {
                    writer.write("> ");
                    writer.write(isInt ? Integer.toString((int)Math.floor(entry.prop.min())) : Double.toString(entry.prop.min()));
                }
            } else if (entry.prop.max() != Double.MAX_VALUE) {
                writer.write("< ");
                writer.write(isInt ? Integer.toString((int)Math.floor(entry.prop.max())) : Double.toString(entry.prop.max()));
            } else {
                writer.write("Go wild, but not too wild");
            }
            writer.write("\n");
        }
    }

    private static void writeKey(StringWriter writer, String name) {
        writer.write("[");
        writer.write(name);
        writer.write("]");
        writer.write("\n");
    }

    private static void writeComment(StringWriter writer, String comment, boolean indent) {
        String prefix = indent ? "\t" : "";
        List lines = ON_LINE_BREAK.splitToList((CharSequence)comment);
        for (String line : lines) {
            writer.write(prefix);
            writer.write("# ");
            writer.write(line);
            writer.write("\n");
        }
    }

    public static boolean assignValuesFromToml(ConfigBase config, Toml toml, boolean isReload) throws IllegalAccessException, IllegalStateException {
        HashMap<ConfigBase.Category.Entry, Object> entryToValue = new HashMap<ConfigBase.Category.Entry, Object>();
        HashMap tomlToValue = new HashMap();
        for (ConfigBase.Category category : config.categories) {
            for (ConfigBase.Category.Entry entry : category.getEntries()) {
                if (entry.prop.skip()) continue;
                entryToValue.put(entry, entry.field.get(config));
            }
        }
        toml.toMap().forEach((k, v) -> {
            if (v instanceof Map) {
                tomlToValue.putAll((Map)v);
            }
        });
        entryToValue.entrySet().removeIf(e -> {
            block33: {
                ConfigBase.Category.Entry entry = (ConfigBase.Category.Entry)e.getKey();
                String fieldName = entry.field.getName();
                if (tomlToValue.containsKey(fieldName)) {
                    try {
                        Object oriValue = entry.field.get(config);
                        Object tomlValue = tomlToValue.get(fieldName);
                        if (entry.field.getType() == Integer.TYPE) {
                            if (tomlValue instanceof Number) {
                                int newValue = ((Number)tomlValue).intValue();
                                if (entry.prop.intBool() && newValue >= 0 && newValue <= 1 || !entry.prop.intBool() && (double)newValue >= entry.prop.min() && (double)newValue <= entry.prop.max()) {
                                    entry.field.set(config, newValue);
                                    if (isReload && !oriValue.equals(newValue)) {
                                        config.onPropertyChanged(true, fieldName, entry.field, oriValue, newValue);
                                    }
                                    tomlToValue.remove(fieldName);
                                    return true;
                                }
                            }
                            break block33;
                        }
                        if (entry.field.getType() == Double.TYPE) {
                            double newValue;
                            if (tomlValue instanceof Number && (newValue = ((Number)tomlValue).doubleValue()) >= entry.prop.min() && newValue <= entry.prop.max()) {
                                entry.field.set(config, newValue);
                                if (isReload && !oriValue.equals(newValue)) {
                                    config.onPropertyChanged(true, fieldName, entry.field, oriValue, newValue);
                                }
                                tomlToValue.remove(fieldName);
                                return true;
                            }
                            break block33;
                        }
                        if (entry.field.getType() == Boolean.TYPE) {
                            if (tomlValue instanceof Boolean) {
                                entry.field.set(config, tomlValue);
                                if (isReload && oriValue != tomlValue) {
                                    config.onPropertyChanged(true, fieldName, entry.field, oriValue, tomlValue);
                                }
                                tomlToValue.remove(fieldName);
                                return true;
                            }
                            break block33;
                        }
                        if (entry.field.getType() == String.class) {
                            boolean invalid = true;
                            String newValue = tomlValue.toString();
                            if (entry.prop.values().length != 1 || !entry.prop.values()[0].isEmpty()) {
                                for (String string : entry.prop.values()) {
                                    if (!newValue.equals(string)) continue;
                                    invalid = false;
                                    break;
                                }
                            } else if (entry.prop.validator().equals("undefined") || entry.prop.validator().isEmpty()) {
                                invalid = false;
                            } else if (config.validate(config.getValidatorMethod(entry.prop.validator()), newValue)) {
                                invalid = false;
                            }
                            if (!invalid) {
                                entry.field.set(config, newValue);
                                if (isReload && oriValue.equals(newValue)) {
                                    config.onPropertyChanged(true, fieldName, entry.field, oriValue, newValue);
                                }
                                tomlToValue.remove(fieldName);
                                return true;
                            }
                            break block33;
                        }
                        if (entry.field.getType().isEnum()) {
                            ?[] enumConstants;
                            String newValue = tomlValue.toString();
                            for (Object obj : enumConstants = entry.field.getType().getEnumConstants()) {
                                if (!obj.toString().equals(newValue)) continue;
                                entry.field.set(config, obj);
                                if (isReload && oriValue.equals(obj)) {
                                    config.onPropertyChanged(true, fieldName, entry.field, oriValue, obj);
                                }
                                tomlToValue.remove(fieldName);
                                return true;
                            }
                        } else if (List.class.isAssignableFrom(entry.field.getType()) && tomlValue instanceof List) {
                            Gson gson = StringUtil.GSON;
                            ArrayList<Object> newList = new ArrayList<Object>((List)gson.fromJson(gson.toJson(tomlValue), entry.field.getType()));
                            if (!newList.isEmpty()) {
                                ArrayList<Integer> newListInts = new ArrayList<Integer>();
                                boolean isAllInts = true;
                                for (Object e2 : newList) {
                                    Double d;
                                    if (e2 instanceof Double && (double)(d = (Double)e2).intValue() == d) {
                                        newListInts.add(d.intValue());
                                        continue;
                                    }
                                    isAllInts = false;
                                    break;
                                }
                                if (isAllInts) {
                                    newList = newListInts;
                                }
                            }
                            if (!entry.prop.validator().equals("undefined") && !entry.prop.validator().isEmpty()) {
                                newList.removeIf(o -> !config.validate(config.getValidatorMethod(entry.prop.validator()), o));
                            }
                            entry.field.set(config, newList);
                            if (isReload && oriValue.equals(newList)) {
                                config.onPropertyChanged(true, fieldName, entry.field, oriValue, tomlValue);
                            }
                            tomlToValue.remove(fieldName);
                            return true;
                        }
                    }
                    catch (IllegalAccessException ex) {
                        iChunUtil.LOGGER.error("Error with setting field {} with object {} from config {}", new Object[]{fieldName, tomlToValue.get(fieldName), config.getFileName(), ex});
                    }
                }
            }
            return false;
        });
        boolean errorFree = entryToValue.isEmpty() && tomlToValue.isEmpty();
        for (ConfigBase.Category.Entry entry : entryToValue.keySet()) {
            if (tomlToValue.containsKey(entry.field.getName())) {
                iChunUtil.LOGGER.warn("Error getting value for {} from config {}. Config value invalid: {}.", new Object[]{entry.field.getName(), config.getFileName(), tomlToValue.get(entry.field.getName())});
                tomlToValue.remove(entry.field.getName());
                continue;
            }
            iChunUtil.LOGGER.warn("Error getting value for {} from config {}. Does not exist in config.", (Object)entry.field.getName(), (Object)config.getFileName());
        }
        for (String s : tomlToValue.keySet()) {
            iChunUtil.LOGGER.warn("Discarding key {} in config {}. No such field exists in config.", (Object)s, (Object)config.getFileName());
        }
        return errorFree;
    }
}

