/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.config.view;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constrainable;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowGeneric;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementButton;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementDropdownContextMenu;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementList;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementNumberInput;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementPadding;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementScrollBar;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextField;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextWrapper;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementToggle;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementToggleTextable;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.impl.ViewEditList;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.impl.ViewPopup;
import me.ichun.mods.ichunutil.client.gui.config.WorkspaceConfigs;
import me.ichun.mods.ichunutil.client.key.KeyBind;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.config.annotations.Prop;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.NotNull;

public class ViewValues
extends View<WindowGeneric<WorkspaceConfigs, ViewValues>> {
    public final TreeSet<ConfigBase> configs;
    public final ElementList<?> list;

    public ViewValues(@NotNull WindowGeneric<WorkspaceConfigs, ViewValues> parent, @NotNull String s, TreeSet<ConfigBase> configs) {
        super(parent, s);
        this.configs = configs;
        Fragment lastRotatable = null;
        int i = 0;
        for (ConfigBase config : configs) {
            ElementToggle<ElementToggle> rotatable = new ElementToggle<ElementToggle>(this, config.getConfigType().toString(), b -> {
                if (b.toggleState) {
                    this.elements.stream().filter(element -> "configType".equals(element.id)).forEach(e -> {
                        ((ElementToggle)e).toggleState = false;
                    });
                    b.toggleState = true;
                    this.populateList();
                } else {
                    b.toggleState = true;
                }
            });
            ((Fragment)rotatable.setSize(60, 14)).setId("configType");
            rotatable.setConstraint(new Constraint(rotatable).left(lastRotatable != null ? lastRotatable : this, lastRotatable != null ? Constraint.Property.Type.RIGHT : Constraint.Property.Type.LEFT, 0).top(this, Constraint.Property.Type.TOP, 0));
            if (i == 0) {
                rotatable.setToggled(true);
            }
            this.elements.add(rotatable);
            lastRotatable = rotatable;
            ++i;
        }
        ElementScrollBar sv = new ElementScrollBar(this, ElementScrollBar.Orientation.VERTICAL, 0.6f);
        sv.setConstraint(new Constraint(sv).top(lastRotatable, Constraint.Property.Type.BOTTOM, 0).bottom(this, Constraint.Property.Type.BOTTOM, 0).right(this, Constraint.Property.Type.RIGHT, 0));
        this.elements.add(sv);
        this.list = new ElementList<ViewValues>(this).setScrollVertical(sv);
        this.list.setConstraint(new Constraint(this.list).left(this, Constraint.Property.Type.LEFT, 0).bottom(this, Constraint.Property.Type.BOTTOM, 0).top(lastRotatable, Constraint.Property.Type.BOTTOM, 0).right(sv, Constraint.Property.Type.LEFT, 0));
        this.populateList();
        this.elements.add(this.list);
    }

    public void populateList() {
        ConfigBase config = this.getCurrentConfig();
        if (config != null) {
            this.list.m_7522_(null);
            this.list.items.clear();
            if (config.getConfigType().equals((Object)ConfigBase.Type.SERVER) && (this.getMinecraft().f_91074_ == null || !iChunUtil.d().getServer().m_129792_() || iChunUtil.d().getServer().m_6846_().m_11309_() > 1)) {
                ViewPopup.popup((WorkspaceConfigs)((WindowGeneric)this.parent).parent, 0.6, 140.0, null, I18n.m_118938_((String)"gui.ichunutil.configs.noEditingServerConfig", (Object[])new Object[0]));
                return;
            }
            for (ConfigBase.Category category : config.categories) {
                if (!category.showInGui) continue;
                ElementList.Item<Comparable<ConfigBase.Category>> item = this.list.addItem(category).setBorderSize(0);
                Object wrapper = new ElementTextWrapper((Fragment<?>)item).setText(ChatFormatting.YELLOW + config.getLocalisedName(category, false));
                ((Fragment)wrapper).setConstraint(new Constraint((Constrainable)wrapper).left(item, Constraint.Property.Type.LEFT, 3).right(item, Constraint.Property.Type.RIGHT, 90));
                String desc = config.getLocalisedName(category, true);
                ((Element)wrapper).setTooltip(desc);
                item.setTooltip(desc);
                item.addElement((Element<?>)wrapper);
                ElementPadding padding = new ElementPadding(item, 0, 20);
                padding.setConstraint(new Constraint(padding).right(item, Constraint.Property.Type.RIGHT, 0));
                item.addElement(padding);
                for (ConfigBase.Category.Entry entry : category.getEntries()) {
                    item = this.list.addItem(entry).setBorderSize(0);
                    item.setSelectionHandler(itemObj -> {
                        if (itemObj.selected) {
                            itemObj.selected = false;
                            Element<?> e = this.getControlElement((ElementList.Item<?>)itemObj);
                            if (e != null) {
                                ((Fragment)e.parent).m_7522_((GuiEventListener)e);
                                if (e instanceof ElementTextField) {
                                    ElementTextField text = (ElementTextField)e;
                                    text.focus();
                                } else {
                                    e.m_6375_((double)e.getLeft() + (double)e.getWidth() / 2.0, (double)e.getTop() + (double)e.getHeight() / 2.0, 0);
                                    e.m_6348_((double)e.getLeft() + (double)e.getWidth() / 2.0, (double)e.getTop() + (double)e.getHeight() / 2.0, 0);
                                }
                            }
                            this.save();
                        }
                    });
                    wrapper = new ElementTextWrapper((Fragment<?>)item).setText(config.getLocalisedName(entry, false));
                    ((Fragment)wrapper).setConstraint(new Constraint((Constrainable)wrapper).left(item, Constraint.Property.Type.LEFT, 8).right(item, Constraint.Property.Type.RIGHT, 90));
                    desc = config.getLocalisedName(entry, true);
                    ((Element)wrapper).setTooltip(desc);
                    item.setTooltip(desc);
                    item.addElement((Element<?>)wrapper);
                    padding = new ElementPadding(item, 0, 20);
                    padding.setConstraint(new Constraint(padding).right(item, Constraint.Property.Type.RIGHT, 0));
                    item.addElement(padding);
                    this.addControlFor(config, entry, item);
                }
            }
            this.list.init();
        }
    }

    public ConfigBase getCurrentConfig() {
        for (ConfigBase config : this.configs) {
            Optional<Element> any = this.elements.stream().filter(element -> {
                if (!"configType".equals(element.id)) return false;
                if (!(element instanceof ElementToggle)) return false;
                ElementToggle toggle = (ElementToggle)element;
                if (!toggle.toggleState) return false;
                if (!toggle.text.equals(config.getConfigType().toString())) return false;
                return true;
            }).findAny();
            if (!any.isPresent()) continue;
            return config;
        }
        return null;
    }

    public Element<?> getControlElement(ElementList.Item<?> item) {
        for (Element<?> element : item.elements) {
            if (element instanceof ElementTextWrapper || element instanceof ElementPadding) continue;
            return element;
        }
        return null;
    }

    public void save() {
        ConfigBase config = this.getCurrentConfig();
        boolean isDirty = false;
        for (ElementList.Item<?> item : this.list.items) {
            Element<?> e = this.getControlElement(item);
            if (e == null) continue;
            ConfigBase.Category.Entry e1 = (ConfigBase.Category.Entry)item.getObject();
            Field field = e1.field;
            field.setAccessible(true);
            Class<?> clz = field.getType();
            try {
                Object o = field.get(config);
                if (clz == Integer.TYPE && e instanceof ElementNumberInput) {
                    field.set(config, ((ElementNumberInput)e).getInt());
                } else if (clz == Double.TYPE && e instanceof ElementNumberInput) {
                    field.set(config, ((ElementNumberInput)e).getDouble());
                } else if (clz == Boolean.TYPE && e instanceof ElementToggleTextable) {
                    field.set(config, ((ElementToggle)e).toggleState);
                } else if (clz == String.class && e instanceof ElementTextField) {
                    field.set(config, ((ElementTextField)e).getText());
                } else if (clz.isEnum() && e instanceof ElementDropdownContextMenu) {
                    ?[] enums;
                    for (Object en : enums = clz.getEnumConstants()) {
                        if (!en.toString().equals(((ElementDropdownContextMenu)e).text)) continue;
                        field.set(config, en);
                        break;
                    }
                } else if (o instanceof List) {
                    // empty if block
                }
                if (o == field.get(config)) continue;
                if (e1.prop.needsRestart()) {
                    ((WorkspaceConfigs)((WindowGeneric)this.parent).parent).viewConfigs.createRestartAlertButton();
                }
                isDirty = true;
                config.onPropertyChanged(false, field.getName(), field, o, field.get(config));
            }
            catch (IllegalAccessException ex) {
                iChunUtil.LOGGER.error("Error accessing field {} for config {} of type {}", new Object[]{field.getName(), config.getConfigName(), config.getConfigType(), ex});
            }
        }
        if (isDirty) {
            config.save();
        }
    }

    public void addControlFor(ConfigBase config, ConfigBase.Category.Entry entry, ElementList.Item<?> item) {
        BiFunction<ConfigBase.Category.Entry, ElementList.Item<?>, Boolean> entryGuiOverride;
        Object o;
        Field field = entry.field;
        Class<?> clz = field.getType();
        Prop props = entry.prop;
        try {
            o = field.get(config);
        }
        catch (IllegalAccessException e) {
            return;
        }
        boolean handled = false;
        if (!props.guiElementOverride().isEmpty() && (entryGuiOverride = config.guiElementOverrides.get(props.guiElementOverride())) != null && entryGuiOverride.apply(entry, item).booleanValue()) {
            handled = true;
        }
        if (!handled) {
            String entryName = config.getLocalisedName(entry, false);
            if (clz == Integer.TYPE) {
                ElementNumberInput input = new ElementNumberInput(item, false);
                input.setMin(props.min() == -1.7976931348623157E308 ? -2.147483648E9 : (double)((int)props.min()));
                input.setMax(props.max() == Double.MAX_VALUE ? 2.147483647E9 : (double)((int)props.max()));
                input.setDefaultText(o.toString());
                input.setSize(80, 14);
                input.setConstraint(new Constraint(input).top(item, Constraint.Property.Type.TOP, 3).bottom(item, Constraint.Property.Type.BOTTOM, 3).right(item, Constraint.Property.Type.RIGHT, 8));
                item.addElement(input);
            } else if (clz == Double.TYPE) {
                ElementNumberInput input = new ElementNumberInput(item, true);
                input.setMin(props.min());
                input.setMax(props.max());
                input.setMaxDec(2);
                input.setDefaultText(o.toString());
                input.setSize(80, 14);
                input.setConstraint(new Constraint(input).top(item, Constraint.Property.Type.TOP, 3).bottom(item, Constraint.Property.Type.BOTTOM, 3).right(item, Constraint.Property.Type.RIGHT, 8));
                item.addElement(input);
            } else if (clz == Boolean.TYPE) {
                ElementToggleTextable toggle = new ElementToggleTextable<ElementToggleTextable>(item, entryName, elementClickable -> {}).setToggled((Boolean)o);
                toggle.setSize(80, 14);
                toggle.setConstraint(new Constraint(toggle).top(item, Constraint.Property.Type.TOP, 3).bottom(item, Constraint.Property.Type.BOTTOM, 3).right(item, Constraint.Property.Type.RIGHT, 8));
                item.addElement(toggle);
            } else if (clz == String.class) {
                ElementTextField input = new ElementTextField(item);
                input.setDefaultText(o.toString());
                input.setSize(80, 14);
                input.setConstraint(new Constraint(input).top(item, Constraint.Property.Type.TOP, 3).bottom(item, Constraint.Property.Type.BOTTOM, 3).right(item, Constraint.Property.Type.RIGHT, 8));
                item.addElement(input);
            } else if (clz.isEnum()) {
                ElementDropdownContextMenu input = new ElementDropdownContextMenu(item, o.toString(), Arrays.asList(clz.getEnumConstants()), (menu, listItem) -> {
                    if (listItem.selected) {
                        ElementDropdownContextMenu contextMenu = (ElementDropdownContextMenu)menu;
                        contextMenu.text = listItem.getObject().toString();
                    }
                });
                input.setSize(80, 14);
                input.setConstraint(new Constraint(input).top(item, Constraint.Property.Type.TOP, 3).bottom(item, Constraint.Property.Type.BOTTOM, 3).right(item, Constraint.Property.Type.RIGHT, 8));
                item.addElement(input);
            } else if (o instanceof List) {
                StringBuilder sb = new StringBuilder();
                List list = (List)o;
                for (int i = 0; i < list.size(); ++i) {
                    Object o1 = list.get(i);
                    sb.append(o1);
                    if (i >= list.size() - 1) continue;
                    sb.append("\n");
                }
                ElementButton<ElementButton> button = new ElementButton<ElementButton>(item, "selectWorld.edit", btn -> {
                    ParameterizedType type;
                    Type[] types;
                    entry.field.setAccessible(true);
                    Type typefield = entry.field.getGenericType();
                    if (typefield instanceof ParameterizedType && (types = (type = (ParameterizedType)typefield).getActualTypeArguments()).length == 1) {
                        Predicate<String> validator = null;
                        if (types[0] == String.class) {
                            validator = str -> true;
                        } else if (types[0] == Double.class) {
                            validator = ElementTextField.NUMBERS;
                        } else if (types[0] == Integer.class) {
                            validator = ElementTextField.INTEGERS;
                        }
                        if (validator != null) {
                            if (props.values().length != 1 || !props.values()[0].isEmpty()) {
                                String[] values = props.values();
                                validator = validator.and(s -> {
                                    for (String value1 : values) {
                                        if (!value1.startsWith((String)s)) continue;
                                        return true;
                                    }
                                    return false;
                                });
                            }
                            Predicate<String> finalValidator = validator;
                            Object window = WindowGeneric.create((WorkspaceConfigs)((WindowGeneric)this.parent).parent, windowGeneric -> new ViewEditList<WindowGeneric>((WindowGeneric)windowGeneric, entryName, list, finalValidator, list1 -> {
                                try {
                                    List listToUse = list;
                                    if (list instanceof ArrayList) {
                                        listToUse = (List)((ArrayList)list).clone();
                                    }
                                    listToUse.clear();
                                    for (ElementList.Item<?> item1 : list1.items) {
                                        ElementTextField oriText = (ElementTextField)item1.elements.get(0);
                                        if (oriText.getText().isEmpty()) continue;
                                        if (types[0] == String.class) {
                                            listToUse.add(oriText.getText());
                                            continue;
                                        }
                                        if (types[0] == Double.class) {
                                            listToUse.add(Double.parseDouble(oriText.getText()));
                                            continue;
                                        }
                                        if (types[0] != Integer.class) continue;
                                        listToUse.add(Integer.parseInt(oriText.getText()));
                                    }
                                    entry.field.set(config, listToUse);
                                    if (entry.prop.needsRestart()) {
                                        ((WorkspaceConfigs)((WindowGeneric)this.parent).parent).viewConfigs.createRestartAlertButton();
                                    }
                                    config.save();
                                }
                                catch (IllegalAccessException illegalAccessException) {
                                    // empty catch block
                                }
                            }));
                            ((Workspace)this.getWorkspace()).openWindowInCenter((Window<?, ?>)window, 0.6, 0.8);
                            ((Fragment)window).init();
                        }
                    }
                });
                button.setTooltip(sb.toString());
                button.setSize(80, 14);
                button.setConstraint(new Constraint(button).top(item, Constraint.Property.Type.TOP, 3).bottom(item, Constraint.Property.Type.BOTTOM, 3).right(item, Constraint.Property.Type.RIGHT, 8));
                item.addElement(button);
            } else if (clz == KeyBind.class) {
                WorkspaceConfigs.createButtonToKeyBinds(entry, item);
            }
        }
    }

    @Override
    public void setWindowGenericProperties(WindowGeneric<?, ?> window) {
        window.pos(20, 20);
        window.size(200, 300);
        window.disableUndocking();
        window.disableDrag();
        window.disableBringToFront();
    }
}

