/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.Rectangle;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constrainable;
import me.ichun.mods.ichunutil.client.gui.bns.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementFertile;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementScrollBar;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextWrapper;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.util.StringUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementList<P extends Fragment<?>>
extends ElementFertile<P> {
    public List<Item<?>> items = new ArrayList();
    @Nullable
    private ElementScrollBar<?> scrollVert;
    @Nullable
    private ElementScrollBar<?> scrollHori;
    @Nullable
    private BiConsumer<Item<?>, Item<?>> dragHandler;
    @Nullable
    private BiConsumer<Item<?>, Integer> rearrangeHandler;
    public boolean renderBackground = true;
    public boolean hasInit;
    private MousePosItem pos;

    public ElementList(@NotNull P parent) {
        super(parent);
    }

    public <T extends ElementList<P>> T setScrollVertical(ElementScrollBar<?> scroll) {
        this.scrollVert = scroll;
        this.scrollVert.setCallback(scr -> this.alignItems());
        return (T)this;
    }

    public <T extends ElementList<P>> T setScrollHorizontal(ElementScrollBar<?> scroll) {
        this.scrollHori = scroll;
        this.scrollHori.setCallback(scr -> this.alignItems());
        return (T)this;
    }

    public <T extends ElementList<P>> T setDragHandler(BiConsumer<Item<?>, Item<?>> dragHandler) {
        this.dragHandler = dragHandler;
        return (T)this;
    }

    public <T extends ElementList<P>> T setRearrangeHandler(BiConsumer<Item<?>, Integer> rearrangeHandler) {
        this.rearrangeHandler = rearrangeHandler;
        return (T)this;
    }

    public <T extends ElementList<P>> T disableBackground() {
        this.renderBackground = false;
        return (T)this;
    }

    public <T extends Item<?>> T addItem(T item, int index) {
        if (index >= 0) {
            this.items.add(index, item);
        } else {
            this.items.add(item);
        }
        item.constraint = Constraint.sizeOnly(item);
        if (this.hasInit) {
            this.alignItems();
            this.updateScrollBarSizes();
        }
        return item;
    }

    public <T extends Item<?>> T addItem(T item) {
        return (T)this.addItem((Object)item, -1);
    }

    public <M> Item<M> addItem(M o, int index) {
        return this.addItem((M)new Item<M>(this, o), index);
    }

    public <M> Item<M> addItem(M o) {
        return this.addItem(o, -1);
    }

    public boolean removeItemWithObject(Object o) {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            Item<?> item = this.items.get(i);
            if (!item.getObject().equals(o)) continue;
            this.items.remove(item);
            this.updateScrollBarSizes();
            return true;
        }
        return false;
    }

    @Nullable
    public Item<?> getItemWithObject(Object o) {
        for (Item<?> item : this.items) {
            if (!item.getObject().equals(o)) continue;
            return item;
        }
        return null;
    }

    public List<Item<?>> getSelectedItems() {
        ArrayList listItems = new ArrayList();
        this.items.forEach(item -> {
            if (item.selected) {
                listItems.add((Item<?>)item);
            }
        });
        return listItems;
    }

    @Override
    public void init() {
        super.init();
        this.hasInit = true;
        this.alignItems();
        this.updateScrollBarSizes();
    }

    @Override
    public void resize(Minecraft mc, int width, int height) {
        super.resize(mc, width, height);
        this.alignItems();
        super.resize(mc, width, height);
        this.alignItems();
        this.updateScrollBarSizes();
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        PoseStack stack = graphics.m_280168_();
        if (this.renderBackground) {
            if (this.renderMinecraftStyle() > 0) {
                ElementList.bindTexture(this.resourceHorse());
                ElementList.cropAndStitch(stack, this.getLeft(), this.getTop(), this.width, this.height, 2, 79.0, 17.0, 90, 54, 256.0, 256.0);
            } else {
                RenderHelper.drawColour(graphics, this.getTheme().elementListBorder, 255, (double)this.getLeft(), (double)this.getTop(), (double)this.width, 1.0, 0.0);
                RenderHelper.drawColour(graphics, this.getTheme().elementListBorder, 255, (double)this.getLeft(), (double)this.getTop(), 1.0, (double)this.height, 0.0);
                RenderHelper.drawColour(graphics, this.getTheme().elementListBorder, 255, (double)this.getLeft(), (double)(this.getBottom() - 1), (double)this.width, 1.0, 0.0);
                RenderHelper.drawColour(graphics, this.getTheme().elementListBorder, 255, (double)(this.getRight() - 1), (double)this.getTop(), 1.0, (double)this.height, 0.0);
            }
        }
        this.setScissor();
        this.items.forEach(item -> item.m_88315_(graphics, mouseX, mouseY, partialTick));
        if (this.m_7222_() instanceof Item) {
            ((Item)this.m_7222_()).m_88315_(graphics, mouseX, mouseY, partialTick);
        }
        this.resetScissorToParent();
    }

    public Item<?> getItemAt(double mouseX, double mouseY) {
        Optional child = this.m_94729_(mouseX, mouseY);
        if (child.isPresent() && child.get() instanceof Item) {
            return (Item)child.get();
        }
        return null;
    }

    public int getMouseRelation(double mouseX, double mouseY, Item<?> item) {
        if (this.rearrangeHandler != null) {
            if (mouseY < (double)(item.getTop() + 3)) {
                return -1;
            }
            if (mouseY > (double)(item.getBottom() - 3)) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public void unfocus(@Nullable GuiEventListener guiReplacing) {
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY)) {
            boolean hasElement = this.defaultMouseClicked(mouseX, mouseY, button);
            if (this.dragHandler != null && button == 0) {
                if (hasElement) {
                    this.pos = new MousePosItem((int)mouseX, (int)mouseY, this.getItemAt(mouseX, mouseY));
                } else if (this.m_7222_() instanceof Fragment) {
                    this.m_7522_(null);
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double distX, double distY) {
        return this.pos != null;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.pos != null) {
            Item<?> item = this.getItemAt(mouseX, mouseY);
            Item<?> draggedItem = this.pos.item;
            if (draggedItem != null && item != draggedItem) {
                if (item != null) {
                    int relation = this.getMouseRelation(mouseX, mouseY, item);
                    if (relation != 0) {
                        int draggedIndex;
                        int itemIndex = this.items.indexOf(item);
                        if (!(itemIndex == (draggedIndex = this.items.indexOf(this.pos.item)) - 1 && relation == 1 || itemIndex == draggedIndex + 1 && relation == -1)) {
                            int newIndex;
                            int n = newIndex = relation > 0 ? itemIndex + 1 : itemIndex;
                            if (draggedIndex < newIndex) {
                                --newIndex;
                            }
                            this.items.remove(draggedItem);
                            this.items.add(newIndex, draggedItem);
                            this.rearrangeHandler.accept(draggedItem, draggedIndex);
                        }
                    } else {
                        this.dragHandler.accept(draggedItem, item);
                    }
                } else if (this.rearrangeHandler != null) {
                    int draggedIndex = this.items.indexOf(this.pos.item);
                    this.items.remove(draggedItem);
                    if (mouseY < (double)this.getTop()) {
                        this.items.add(0, draggedItem);
                    } else {
                        this.items.add(draggedItem);
                    }
                    this.rearrangeHandler.accept(draggedItem, draggedIndex);
                }
                this.alignItems();
            }
            this.pos = null;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (this.m_5953_(mouseX, mouseY)) {
            boolean defaultScroll = super.m_6050_(mouseX, mouseY, scrollY);
            if (defaultScroll) {
                return true;
            }
            if (Screen.m_96638_()) {
                if (this.scrollHori != null) {
                    this.scrollHori.secondHandScroll(scrollY * 70.0 / (double)this.getTotalItemHeight() * 2.0);
                    return true;
                }
            } else if (this.scrollVert != null) {
                this.scrollVert.secondHandScroll(scrollY * 70.0 / (double)this.getTotalItemHeight() * 2.0);
                return true;
            }
        }
        return false;
    }

    public void alignItems() {
        int itemHeight = this.getTotalItemHeight();
        int itemWidth = this.getMinItemWidth();
        int offsetY = 0;
        if (this.scrollVert != null) {
            offsetY = (int)((float)Math.max(0, itemHeight - (this.height - 2)) * this.scrollVert.scrollProg);
        }
        int offsetX = 0;
        if (this.scrollHori != null) {
            offsetX = (int)((float)Math.max(0, itemWidth - (this.width - 2)) * this.scrollHori.scrollProg);
        }
        int currentWidth = 1;
        int currentHeight = 1;
        for (Item<?> item : this.items) {
            item.posX = currentWidth - offsetX;
            item.posY = currentHeight - offsetY;
            boolean flag = false;
            if (item.width != this.width - 2) {
                item.width = Math.max(itemWidth, this.width - 2);
                flag = true;
            }
            if (item.height != item.getMinHeight()) {
                item.height = item.getMinHeight();
                flag = true;
            }
            if (flag) {
                item.constraint.apply();
            }
            currentHeight += item.getHeight();
        }
    }

    public void updateScrollBarSizes() {
        if (this.scrollVert != null) {
            int itemHeight = this.getTotalItemHeight();
            this.scrollVert.setScrollBarSize((float)this.height / (float)itemHeight);
        }
        if (this.scrollHori != null) {
            int itemWidth = this.getMinItemWidth();
            this.scrollHori.setScrollBarSize((float)this.width / (float)itemWidth);
        }
    }

    public int getTotalItemHeight() {
        int itemHeight = 0;
        for (Item<?> item : this.items) {
            itemHeight += item.height;
        }
        return itemHeight;
    }

    public int getMinItemWidth() {
        int itemWidth = 0;
        for (Item<?> item : this.items) {
            if (item.getMinWidth() <= itemWidth) continue;
            itemWidth = item.getMinWidth();
        }
        return itemWidth;
    }

    @Override
    public List<? extends Item<?>> m_6702_() {
        return this.items;
    }

    @Override
    public void setScissor() {
        RenderHelper.startGlScissor(this.getLeft() + 1, this.getTop() + 1, this.width - 2, this.height - 2);
    }

    @Override
    public boolean requireScissor() {
        return true;
    }

    @Override
    public ComponentPath m_264064_(FocusNavigationEvent event) {
        return null;
    }

    @Override
    public int getMinWidth() {
        if (this.scrollHori != null) {
            return 14;
        }
        return super.getMinWidth();
    }

    @Override
    public int getMinHeight() {
        if (this.scrollVert != null) {
            return 14;
        }
        return super.getMinHeight();
    }

    @Override
    public int getBorderSize() {
        return 1;
    }

    public static class Item<M>
    extends ElementFertile<ElementList<?>> {
        @NotNull
        protected final M heldObject;
        public List<Element<?>> elements = new ArrayList();
        private boolean deselectOnUnfocus = true;
        private TriConsumer<Double, Double, Item<M>> rightClickConsumer;
        public boolean selected;
        @Nullable
        private Consumer<Item<M>> selectionHandler;
        @Nullable
        private Consumer<Item<M>> doubleClickHandler;
        @Nullable
        private Function<Item<M>, Boolean> enterResponder;
        private int borderSize = 1;
        private int clickTimeout;

        public Item(@NotNull ElementList<?> parent, @NotNull M heldObject) {
            super(parent);
            this.heldObject = heldObject;
        }

        public Item<M> staySelectedOnDefocus() {
            this.deselectOnUnfocus = false;
            return this;
        }

        public Item<M> setRightClickConsumer(TriConsumer<Double, Double, Item<M>> rightClickConsumer) {
            this.rightClickConsumer = rightClickConsumer;
            return this;
        }

        public Item<M> setEnterResponder(Function<Item<M>, Boolean> enterResponder) {
            this.enterResponder = enterResponder;
            return this;
        }

        public Item<M> setDefaultAppearance() {
            if (this.heldObject instanceof File) {
                File file = (File)this.heldObject;
                Object wrapper = new ElementTextWrapper(this).setText(file.getName());
                ((Fragment)((ElementTextWrapper)wrapper).setNoWrap()).setConstraint(new Constraint((Constrainable)wrapper).left(this, Constraint.Property.Type.LEFT, this.getBorderSize() + 2).top(this, Constraint.Property.Type.TOP, this.getBorderSize()));
                this.addElement((Element<?>)wrapper);
                Object wrapper1 = new ElementTextWrapper(this).setText(new SimpleDateFormat().format(new Date(file.lastModified())));
                ((Fragment)((ElementTextWrapper)wrapper1).setNoWrap()).setConstraint(new Constraint((Constrainable)wrapper1).left(this, Constraint.Property.Type.LEFT, this.getBorderSize() + 2).top((Rectangle)wrapper, Constraint.Property.Type.BOTTOM, 0));
                this.addElement((Element<?>)wrapper1);
                wrapper = new ElementTextWrapper(this).setText(StringUtil.readableFileSize(file.length()));
                ((Fragment)((ElementTextWrapper)wrapper).setNoWrap()).setConstraint(new Constraint((Constrainable)wrapper).right(this, Constraint.Property.Type.RIGHT, this.getBorderSize() + 4).top(this, Constraint.Property.Type.TOP, this.getBorderSize()));
                this.addElement((Element<?>)wrapper);
            } else {
                Object wrapper = new ElementTextWrapper(this).setText(StringUtil.getInterpretedInfo(this.heldObject));
                ((Fragment)wrapper).setConstraint(Constraint.matchParent(wrapper, this, this.getBorderSize()).bottom(null, Constraint.Property.Type.BOTTOM, 0));
                this.elements.add((Element<?>)wrapper);
            }
            return this;
        }

        public Item<M> setSelectionHandler(Consumer<Item<M>> handler) {
            this.selectionHandler = handler;
            return this;
        }

        public Item<M> setDoubleClickHandler(Consumer<Item<M>> handler) {
            this.doubleClickHandler = handler;
            return this;
        }

        public Item<M> setBorderSize(int size) {
            this.borderSize = size;
            return this;
        }

        public Item<M> addTextWrapper(String s) {
            Object wrapper = new ElementTextWrapper(this).setText(s);
            ((Fragment)wrapper).setConstraint(Constraint.matchParent(wrapper, this, this.getBorderSize()).bottom(null, Constraint.Property.Type.BOTTOM, 0));
            this.addElement((Element<?>)wrapper);
            return this;
        }

        public Element<?> addElement(Element<?> e) {
            this.elements.add(e);
            return e;
        }

        public M getObject() {
            return this.heldObject;
        }

        @Override
        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            PoseStack stack = graphics.m_280168_();
            if (this.shouldRender()) {
                boolean draggingUs = ((ElementList)this.parent).m_7282_() && ((ElementList)this.parent).m_7222_() == this && ((ElementList)this.parent).pos != null;
                ElementList list = (ElementList)this.parent;
                MousePosItem pos = list.pos;
                if (this.m_5953_(mouseX, mouseY) && ((ElementList)this.parent).dragHandler != null || draggingUs) {
                    ((Workspace)this.getWorkspace()).cursorState = Workspace.CURSOR_CROSSHAIR;
                }
                if (draggingUs) {
                    stack.m_85836_();
                    double x = mouseX - pos.x;
                    double y = mouseY - pos.y;
                    stack.m_85837_(x, y, 0.0);
                }
                if (this.renderMinecraftStyle() > 0) {
                    Item.bindTexture(this.resourceHorse());
                    boolean canRearrange = false;
                    if (draggingUs && list.rearrangeHandler != null) {
                        Item<?> item = list.getItemAt(mouseX, mouseY);
                        Item<?> draggedItem = pos.item;
                        if (draggedItem != null && item != draggedItem) {
                            if (item != null) {
                                int draggedIndex;
                                int itemIndex;
                                int relation = list.getMouseRelation(mouseX, mouseY, item);
                                if (!(relation == 0 || (itemIndex = list.items.indexOf(item)) == (draggedIndex = list.items.indexOf(pos.item)) - 1 && relation == 1 || itemIndex == draggedIndex + 1 && relation == -1)) {
                                    canRearrange = true;
                                }
                            } else {
                                canRearrange = true;
                            }
                        }
                    }
                    if (canRearrange) {
                        Item.cropAndStitch(stack, this.getLeft(), this.getTop(), this.width, this.height, 2, 79.0, 17.0, 90, 54, 256.0, 256.0);
                    } else {
                        Item.cropAndStitch(stack, this.getLeft(), this.getTop(), this.width, this.height, 2, 43.0, 141.0, 18, 18, 256.0, 256.0);
                    }
                } else {
                    int[] borderColour = this.getTheme().elementListItemBorder;
                    if (draggingUs && list.rearrangeHandler != null) {
                        Item<?> item = list.getItemAt(mouseX, mouseY);
                        Item<?> draggedItem = pos.item;
                        if (draggedItem != null && item != draggedItem) {
                            if (item != null) {
                                int draggedIndex;
                                int itemIndex;
                                int relation = list.getMouseRelation(mouseX, mouseY, item);
                                if (!(relation == 0 || (itemIndex = list.items.indexOf(item)) == (draggedIndex = list.items.indexOf(pos.item)) - 1 && relation == 1 || itemIndex == draggedIndex + 1 && relation == -1)) {
                                    borderColour = this.getTheme().elementListItemBackgroundHover;
                                }
                            } else {
                                borderColour = this.getTheme().elementListItemBackgroundHover;
                            }
                        }
                    }
                    this.fill(graphics, borderColour, 0);
                    this.fill(graphics, ((ElementList)this.parent).m_7282_() && ((ElementList)this.parent).m_7222_() == this ? this.getTheme().elementButtonClick : (this.m_5953_(mouseX, mouseY) && (!((ElementList)this.parent).m_7282_() || ((ElementList)this.parent).m_7222_() == this) ? this.getTheme().elementListItemBackgroundHover : (this.selected ? this.getTheme().elementListItemBackgroundSelect : this.getTheme().elementListItemBackground)), this.getBorderSize());
                }
                this.elements.forEach(element -> element.m_88315_(graphics, mouseX, mouseY, partialTick));
                if (draggingUs) {
                    stack.m_85849_();
                }
            }
        }

        @Override
        public boolean m_6348_(double mouseX, double mouseY, int button) {
            if (((ElementList)this.parent).m_7222_() == this && this.m_5953_(mouseX, mouseY)) {
                boolean oldSelected = this.selected;
                if (button == 0) {
                    this.selected = true;
                    if (this.doubleClickHandler != null) {
                        if (this.clickTimeout > 0) {
                            this.clickTimeout = 0;
                            this.doubleClickHandler.accept(this);
                        } else {
                            this.clickTimeout = iChunUtil.configClient.bnsDoubleClickSpeed;
                        }
                    }
                } else if (button == 1) {
                    if (this.rightClickConsumer != null) {
                        this.rightClickConsumer.accept((Object)mouseX, (Object)mouseY, (Object)this);
                    } else {
                        this.selected = false;
                    }
                }
                if (oldSelected != this.selected && this.selectionHandler != null) {
                    this.selectionHandler.accept(this);
                }
            }
            return super.m_6348_(mouseX, mouseY, button);
        }

        @Override
        public void tick() {
            super.tick();
            if (this.clickTimeout > 0) {
                --this.clickTimeout;
            }
        }

        public boolean shouldRender() {
            return this.getRight() > ((ElementList)this.parent).getLeft() && this.getLeft() < ((ElementList)this.parent).getRight() && this.getBottom() > ((ElementList)this.parent).getTop() && this.getTop() < ((ElementList)this.parent).getBottom() || ((ElementList)this.parent).m_7282_() && ((ElementList)this.parent).m_7222_() == this && ((ElementList)this.parent).pos != null;
        }

        @Override
        public List<? extends Fragment<?>> m_6702_() {
            return this.elements;
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (((ElementList)this.parent).m_7222_() == this) {
                boolean flag = super.m_7933_(keyCode, scanCode, modifiers);
                if (!flag) {
                    if (keyCode == 265 || keyCode == 263) {
                        for (int i = 0; i < ((ElementList)this.parent).items.size(); ++i) {
                            Item<?> item = ((ElementList)this.parent).items.get(i);
                            if (item != this || i <= 0) continue;
                            Item<?> item1 = ((ElementList)this.parent).items.get(i - 1);
                            ((ElementList)this.parent).m_7522_((GuiEventListener)item1);
                            boolean oldSelected = item1.selected;
                            item1.selected = true;
                            if (oldSelected != item1.selected && item1.selectionHandler != null) {
                                item1.selectionHandler.accept(item1);
                            }
                            return true;
                        }
                    } else if (keyCode == 264 || keyCode == 262) {
                        for (int i = 0; i < ((ElementList)this.parent).items.size(); ++i) {
                            Item<?> item = ((ElementList)this.parent).items.get(i);
                            if (item != this || i >= ((ElementList)this.parent).items.size() - 1) continue;
                            Item<?> item1 = ((ElementList)this.parent).items.get(i + 1);
                            ((ElementList)this.parent).m_7522_((GuiEventListener)item1);
                            boolean oldSelected = item1.selected;
                            item1.selected = true;
                            if (oldSelected != item1.selected && item1.selectionHandler != null) {
                                item1.selectionHandler.accept(item1);
                            }
                            return true;
                        }
                    }
                }
                return flag;
            }
            if ((keyCode == 257 || keyCode == 335) && this.enterResponder != null) {
                return this.enterResponder.apply(this);
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        @Override
        public void unfocus(@Nullable GuiEventListener guiReplacing) {
            super.unfocus(guiReplacing);
            if (this.deselectOnUnfocus) {
                boolean oldSelected = this.selected;
                this.selected = false;
                if (oldSelected && this.selectionHandler != null) {
                    this.selectionHandler.accept(this);
                }
            }
        }

        @Override
        public int getBorderSize() {
            return this.borderSize;
        }
    }

    public static class MousePosItem {
        int x;
        int y;
        Item<?> item;

        public MousePosItem(int x, int y, Item<?> item) {
            this.x = x;
            this.y = y;
            this.item = item;
        }
    }
}

